<h3>[% $user->gettext('Volltextsuche') %]</h3>



[% if $cntEntries %]

    [% if $FAQSearchResultShow == true %]        
        <p>[% $cntEntries %] [% if $cntEntries != 1 %][% $user->gettext('Suchergebnisse') %][% else %][% $user->gettext('Suchergebnis') %][% /if %]</p>

        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr class="fields">
                        <th>
                            [% $user->gettext('Titel') %]
                        </th>
                        <th>
                            [% $user->gettext('Beschreibung') %]
                        </th>
                        <th>
                            [% $user->gettext('Rubriken') %]
                        </th>
                        <th>
                            [% $user->gettext('Geändert am') %]
                        </th>
                    </tr>
                </thead>
                <tbody>
                    [% foreach from=$FAQSearchResult item=category %]
                        <tr [% if $available %]style="line-height: 30px;"[% /if %]>
                                                        
                            <td>
                                <a href="index.php?module=knowledgebase&fid=[% $category->FAQDataID %]&cid=[% $category->FAQCategoryID %]">[% strip_tags($category->ShortDescription) %]</a>
                            </td>
                            <td>
                                [% substr(strip_tags($category->Description), 0, 100) %]
                            </td>
                            <td>
                                [% $category->get_cat_strings() %]
                            </td>
                            <td>
                                [% $category->UpdateDate|date_format:"%d.%m.%Y %H:%M"  %]
                            </td>
                        </tr>
                    [% /foreach %]
                </tbody>
            </table>
        </div>
    [% else %]
        <p>
            <b>[% $user->gettext('Artikel finden') %]:</b><br />
            [% $user->gettext('Mit der Eingabe') %]
            <span class="notice">
                [% $user->gettext('Begriff1 Begriff2') %]
            </span>
            [% $user->gettext('k&ouml;nnen zwei oder mehrere Suchbegriffe nach der Relevanz absteigend suchen lassen.') %]
        </p>

        <p>
            <b>[% $user->gettext('Hinweis') %]:</b> [% $user->gettext('Suchbegriff muss mindestens 4 Zeichen lang sein, kürzere Anfragen werden automatisch abgewiesen.') %]
        </p>
    [% /if %]

[% else %]

    <p>[% $user->gettext('Keine Einträge gefunden.') %]</p>
[% /if %]





<div class="form-group row mb-3">
    <label class="col-lg-4 control-label">[% $user->gettext('Suchbegriff') %]</label>
    <div class="col-lg-8">
        <input type="text" value="[% $FAQSearch %]" name="search" class="form-control" size="50" onkeyup="keyEvent(event)" />
    </div>
</div>


<div class="form-group row mb-3">
    <label class="col-lg-4 control-label">[% $user->gettext('Suche in Rubriken') %]</label>
    <div class="col-lg-8">
        <select size="1" name="cid" class="form-control" onchange="submitForm();">
            <option value="0" [% if $cid == 0 %]selected="selected"[% /if %]>[% $user->gettext('... allen Kategorien') %]</option>
            [% foreach from=$FAQCategories item=category %]
                <option value="[% $category->FAQCategoryID %]" [% if $cid == $category->FAQCategoryID %]selected="selected"[% /if %]>[% $category->Name %]</option>
            [% /foreach %]
        </select>
    </div>
</div>

<div class="row">
    <div class="col-sm-12">
        <a href="javascript:void(0);" class="btn btn-outline-primary pull-right" onclick="submitForm();" >[% $user->gettext('Volltextsuche') %]</a>
    </div>
</div>

<hr/>



