<div class="card panel-info shadow-sm rounded">
    <div class="card-header portlet-header handle">
        <h3 class="card-title">[% $user->gettext('Aktuelle Meldungen') %]</h3>
    </div>
    <div class="card-body portlet-content">
        <div class="Newslist">

            [% if file_exists($modulePath|cat:"/VBRB.tpl") %]
                [% include file=$modulePath|cat:"/VBRB.tpl" %]           
            [% /if %]                
        
            [% foreach from=$NewsList item=news %]
                <div class="card panel-info shadow-sm rounded" id='NewsItem_[% $news.NewsID %]'>
                    <div class="card-header" style="background-color:[% $news.ContainerColor %]" >
                        <h3 class="card-title">
                            [% $user->gettext($news.Title) %]
                        </h3>
                    </div>
                    <div class="card-body">
                        <p class="intro">
                            [% $user->gettext($Tools->bbcode($news.Intro)) %]
                        </p>
                        [% if $news.Main|count_characters > 0 %]
                            <a href="javascript:showSingleNews([% $news.NewsID %]);">[% $user->gettext('weiterlesen...') %]</a>
                        [% else %]
                            <p class="main">[% $user->gettext($Tools->bbcode($news.Main)) %]</p>
                        [% /if %]
                    </div>
                    <div class="card-footer">
                        <div class="row ">
                            <div class="col-md-6">
                                <span class="date">
                                    <span class="fa fa-calendar" aria-hidden="true"></span>
                                    [% if $news.UpdateDate %]
                                        [% $news.UpdateDate|date_format:"%d.%m.%Y" %]
                                    [% else %]
                                        [% $news.CreateDate|date_format:"%d.%m.%Y" %]
                                    [% /if %]
                                </span>
                            </div>

                            <div class="col-md-6 text-end">
                                [% if $news.Autor|trim != '' %]
                                    <span class="fa fa-user" aria-hidden="true"></span> [% $news.Autor %]
                                [% /if %]
                            </div>
                        </div>
                    </div>
                </div>
            [% /foreach %]
        </div>
    </div>
</div>
