<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

<form action="" method="post" name="hm" id="ListForm" enctype="multipart/form-data" class="form-inline">
    <div class="card panel-fcs-border shadow-sm">
        <div class="card-header">
            <h2 class="card-title-fcs">[% $user->gettext('REST-Request') %]</h2>
        </div>

        <div class="card-body">


            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6 text-left" >
                            <h3 class="card-title text-left" style="font-size: 24px; display:inline">[% $user->gettext('Verfügbare Requests')%]</h3> 
                        </div>

                    </div>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped" id="newsList">
                            <thead>
                                <tr>
                                    <th>[% $user->gettext('Aufruf') %]</th>
                                    <th>[% $user->gettext('Beschreibung') %]</th>
                                    <th>[% $user->gettext('Modul') %]</th>
                                    <th>[% $user->gettext('Parameter') %]</th>
                                    <th>[% $user->gettext('Aktion') %]</th>
                                </tr>
                            </thead>
                            <tbody>
                                [% foreach from=$AvailableRequests item=Request key=Aufruf %]
                                    <tr>
                                        <td>[% $Aufruf %]</td>
                                        <td>[% $Request.Description %]</td>
                                        <td>[% $Request.module %]</td>
                                        <td>
                                            [% foreach from=$Request.Parameter key=Key item=ParamDescr  %]
                                                [% $Key %] => [% $ParamDescr %]<br/>
                                            [% /foreach %]
                                        </td> 
                                        <td></td>
                                    </tr>
                                [% foreachelse %]
                                    <tr class="even">
                                        <td colspan="8">[% $user->gettext('Keine Requests gefunden') %]</td>
                                    </tr>
                                [% /foreach %]

                            </tbody>

                            <tfoot>
                                <tr>
                                    <th>[% $user->gettext('Aufruf') %]</th>
                                    <th>[% $user->gettext('Beschreibung') %]</th>
                                    <th>[% $user->gettext('Modul') %]</th>
                                    <th>[% $user->gettext('Parameter') %]</th>
                                    <th>[% $user->gettext('Aktion') %]</th>
                                </tr>
                            </tfoot>
                            
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
</form>

<script>
    $(document).ready(function () {
        $('.table').DataTable({
            dom: 'Bfrtip',
            buttons: [
//                'colvis',
                'excel',
                'print',
                'csvHtml5',
                'pdfHtml5',
//                'columnsVisibility',
                {
                    text: 'JSON',
                    action: function (e, dt, button, config) {
                        var data = dt.buttons.exportData();

                        $.fn.dataTable.fileSave(
                                new Blob([JSON.stringify(data)]),
                                'Export.json'
                                );
                    }
                }
            ],
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            },
            initComplete: function () {
        /*        
        this.api().columns().every(function () {
                    var column = this;
                    var select = $('<select><option value=""></option></select>')
                            .appendTo($(column.footer()).empty())
                            .on('change', function () {
                                var val = $.fn.dataTable.util.escapeRegex(
                                        $(this).val()
                                        );

                                column
                                        .search(val ? '^' + val : '', true, true)
                                        .draw();
                            });
                    column.data().unique().sort().each(function (d, j) {
                        select.append('<option value="' + d + '">' + d + '</option>')
                    });
                });
                */
            }
        });
    })
</script>