<div class="row">
    <div class="col-md-6">
        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <h3 class="card-title">[% $user->gettext('Version') %]</h3>
            </div>            
            <div class="card-body">
                <div class="table-responsive">
                    <table class='table'>
                        <tr>
                            <td>[% $user->gettext('Version') %]</td>
                            <td>[% $user->Version->RELEASE %] [% $ZendVersion %]</td>
                        </tr>
                        <tr>
                            <td>[% $user->gettext('Handbuch') %]</td>
                            <td><a href="https://iccm.fair-computer.de/heinzelmann/Dokumentation/Heinzelmann_Handbuch.pdf" target="_blank">[% $user->gettext('Handbuch') %]</a></td>
                        </tr>
                        <tr>
                            <td>[% $user->gettext('Change-Log') %]</td>
                            <td><a style="cursor:pointer" onclick="ShowUpdateLog();">[% $user->gettext('Change-Log') %]</a></td>
                            
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        [% if $UpdateData && $UpdateData.updateAvailable %]                    
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <h3 class="card-title">[% $user->gettext('Neue Version verfügbar') %]</h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class='table'>
                            <tr>
                                <td>[% $user->gettext('Download') %]</td>
                                <td><a href="[% $UpdateData.downloadPath %]" target="_blank">[% $UpdateData.availableVersion %] ([% $UpdateData.VersionType %]) </a></td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>                     
        [% /if %]        
        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <h3 class="card-title">[% $user->gettext('Lizenz') %]</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class='table'>
                        <tr>
                            <td>[% $user->gettext('Lizenziert für') %]</td>
                            <td>[% $user->Security->Company %]</td>
                        </tr>
                        <tr>
                            <td>[% $user->gettext('Ansprechpartner') %]</td>
                            <td>[% $user->Security->Contact %] ([% $user->Security->EMail %])</td>
                        </tr>
                        <tr>
                            <td>[% $user->gettext('Lizenziert bis') %]</td>
                            <td>[% $user->Security->ExpireTS %]</td>
                        </tr>
                        <tr>
                            <td>[% $user->gettext('Anzahl Supporter') %]</td>
                            <td>
                                <span title="[% $user->gettext('aktive Supporter') %]">[% $user->Security->UsedLicences-1 %]</span>
                                [% $user->gettext('von') %]
                                <span title="[% $user->gettext('erlaubte Supporter (inkl. Admin-Benutzer)') %]"> [% $user->Security->Licenses-1 %]</span>
                                ( + 1 [% $user->gettext('Administrator') %] )
                            </td>
                        </tr>        
                        [% if $user->Security->Fachsupporter %]
                            <tr>
                                <td>[% $user->gettext('Anzahl Fachsupporter') %]</td>
                                <td>
                                    <span title="[% $user->gettext('aktive Fachsupporter') %]">[% $user->cntFachsupporter %]</span>
                                    [% $user->gettext('von') %]
                                    <span title="[% $user->gettext('erlaubte Fachsupporter') %]"> [% $user->Security->Fachsupporter %]</span>
                                </td>
                            </tr> 
                        [% /if %]
                    </table>
                </div>
            </div> 
        </div>        
    </div>
    <div class="col-md-6">

        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <h3 class="card-title">[% $user->gettext('Lizenzierte Module') %]</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class='table'>
                        <tr>
                            <td>[% $user->gettext('LDAP (ActiveDirectory)') %]</td>
                            <td>
                                [% if $user->Security->LDAP %]
                                    <span class="fa fa-check"></span>                                    
                                [% else %]
                                    <span class="fa fa-times"></span>
                                [% /if %]
                            </td>
                        </tr>                   
                        <tr>
                            <td>[% $user->gettext('Formulare') %]</td>
                            <td>
                                [% if $user->Security->FormWizard %]
                                    <span class="fa fa-check"></span>
                                [% else %]
                                    <span class="fa fa-times"></span>
                                [% /if %]                            
                            </td>
                        </tr>    
                        <tr>
                            <td>[% $user->gettext('Vorlagen') %]</td>
                            <td>
                                [% if $user->Security->TicketTemplate %]
                                    <span class="fa fa-check"></span>
                                [% else %]
                                    <span class="fa fa-times"></span>
                                [% /if %]                            
                            </td>
                        </tr>              
                        <tr>
                            <td>[% $user->gettext('E-Mail in Ticket') %]</td>
                            <td>
                                [% if $user->Security->POP3 %]
                                    <span class="fa fa-check"></span>
                                [% else %]
                                    <span class="fa fa-times"></span>
                                [% /if %]                            
                            </td>
                        </tr>  
                        <tr>
                            <td>[% $user->gettext('ITIL Change') %]</td>
                            <td>
                                [% if $user->Security->ChangeRequest %]
                                    <span class="fa fa-check"></span>
                                [% else %]
                                    <span class="fa fa-times"></span>
                                [% /if %]                            
                            </td>
                        </tr>  
                        <tr>
                            <td>[% $user->gettext('ITIL Service') %]</td>
                            <td>
                                [% if $user->Security->ITILServices %]
                                    <span class="fa fa-check"></span>
                                [% else %]
                                    <span class="fa fa-times"></span>
                                [% /if %]                            
                            </td>
                        </tr>                                                  
                        <tr>
                            <td>[% $user->gettext('Projekt') %]</td>
                            <td>
                                [% if $user->Security->Projects %]
                                    <span class="fa fa-check"></span>
                                [% else %]
                                    <span class="fa fa-times"></span>
                                [% /if %]                            
                            </td>
                        </tr>            
                        <tr>
                            <td>[% $user->gettext('Erweitertes Reporting') %]</td>
                            <td>
                                [% if $user->Security->Reporting %]
                                    <span class="fa fa-check"></span>
                                [% else %]
                                    <span class="fa fa-times"></span>
                                [% /if %]                            
                            </td>
                        </tr>   
                        <tr>
                            <td>[% $user->gettext('Kalender') %]</td>
                            <td>
                                [% if $user->Security->Calendar %]
                                    <span class="fa fa-check"></span>
                                [% else %]
                                    <span class="fa fa-times"></span>
                                [% /if %]                            
                            </td>
                        </tr>                   
                        <tr>
                            <td>[% $user->gettext('Workflow') %]</td>
                            <td>
                                [% if $user->Security->Workflow %]
                                    <span class="fa fa-check"></span>
                                [% else %]
                                    <span class="fa fa-times"></span>
                                [% /if %]                            
                            </td>
                        </tr>
                        <tr>
                            <td>[% $user->gettext('Workflow Online Shop') %]</td>
                            <td>
                                [% if $user->Security->WorkflowBK %]
                                    <span class="fa fa-check"></span>
                                [% else %]
                                    <span class="fa fa-times"></span>
                                [% /if %]                            
                            </td>
                        </tr>                         
                        <tr>
                            <td>[% $user->gettext('Assetverwaltung') %]</td>
                            <td>
                                [% if $user->Security->Assets %]
                                    <span class="fa fa-check"></span>
                                [% else %]
                                    <span class="fa fa-times"></span>
                                [% /if %]                            
                            </td>
                        </tr>
                        <tr>
                            <td>[% $user->gettext('SCRUM') %]</td>
                            <td>
                                [% if $user->Security->Backlog %]
                                    <span class="fa fa-check"></span>
                                [% else %]
                                    <span class="fa fa-times"></span>
                                [% /if %]                            
                            </td>
                        </tr>       
                    </table>
                </div>
            </div>
        </div>
    </div>        
</div>

<script>
    function ShowUpdateLog()
    {
        window.open('index.php?module=installation&event=PopUpChangelog', 'Changelog', 'width=800,height=600,dependent=yes,location=no,menubar=no,scrollbars=no,status=no,toolbar=no,resizable=no');
    }
</script>
