<link rel="stylesheet" type="text/css" href="includes/js/select2/css/select2.min.css"/>
<script type="text/javascript" src="includes/js/select2/js/select2.full.min.js"></script>
<script type="text/javascript" src="includes/js/select2/js/i18n/de.js"></script>

<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <h2 class="card-title-fcs">[% $user->gettext('Emailtemplate anpassen') %]</h3>
    </div>
    <div class="card-body">
        <form id="TemplateForm">

            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <h3 class="card-title">[% $user->gettext('Template wählen') %]</h3>
                </div>
                <div class="card-body">

                    <input type="hidden" name="MailType" value="ReplayMail_New"/>
                    <div class="form-group row mb-3">
                        <label class="control-label">[% $user->gettext('Title') %]</label>
                        <div>
                            <select name="TemplateID" id="TemplateID" class='form-control' data-tags="true" data-placeholder="[% $user->gettext('Template wählen') %]">
                                [% html_options options=$TemplateTitles selected=$Template['templateid'] %]
                            </select>
                        </div>
                    </div>

                    <div class="form-group row mb-3">
                        <div>
                            <button class="btn btn-outline-secondary" id="SaveTemplate">[% $user->gettext('Speichern') %]</button>

                            <button class="btn btn-outline-secondary" id="DeleteTemplate">[% $user->gettext('Löschen') %]</button>

                        </div>
                    </div>

                    <div class="input-group">
                        <div class="input-group-text">@</div>
                        <input type="text" class="form-control" id="MailToAdress" name="MailToAdress" value="[% $user->Email %]">
                        <span class="input-group-text">
                            <button class="btn btn-outline-secondary" type="button" id="TestTemplate">[% $user->gettext('Testen') %]</button>
                        </span>
                    </div>                            

                </div>
            </div>

            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <h3 class="card-title">[% $user->gettext('Template bearbeiten') %]</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-6">
                            <div class="form-group row mb-3">
                                <label class="col-lg-4 control-label">[% $user->gettext('Titel') %]</label>
                                <div class="col-lg-8">
                                    <input type="text" name="TemplateTitle" id="TemplateTitle" class="form-control" value="[% $Template.templatettile %]" required="required"/>
                                </div>
                            </div>                        
                        </div>
                        <div class="col-6">
                            <div class="checkbox">
                                <label>
                                    <input type="checkbox" name="Active" value="1" id="Active"[% if $Template.active == 1 %]checked[% /if %]>[% $user->gettext('Aktiv') %]
                                </label>
                            </div>         
                            <span class="help-block">[% $user->gettext('Template zur Verwendung freigegeben') %]</span>
                        </div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-lg-4 control-label">[% $user->gettext('Betreff') %]</label>
                        <div class="col-lg-8">
                            <input type='text' class='form-control' name='Subject' id="Subject" value='[% $Template['subject'] %]'>
                        </div>
                    </div>
                    <div class="form-group row mb-3">
                        <div class="col-lg-12">
                            <textarea name='Content' style='width:100%;height: 15em;' id="Content">[% $Template['content'] %]</textarea>
                        </div>
                    </div>
                    <button class="btn btn-outline-primary" type="button" data-bs-toggle="collapse" data-bs-target="#collapsePlaceholders" aria-expanded="false" aria-controls="collapsePlaceholders">
                        [% $user->gettext('Platzhalter anzeigen') %]
                    </button>

                    <div class="collapse" id="collapsePlaceholders">
                        <div class="well">
                            <h3>[% $user->gettext('Betreff') %]</h3>
                            <p>[% $user->gettext('Im Betreff der Benachrichtigung können Sie folgende Platzhalter verwenden') %]:</p>
                            <ul>
                                <li>[% $smarty.ldelim %]TicketID[% $smarty.rdelim %] => TicketID</li>
                                <li>[% $smarty.ldelim %]Title[% $smarty.rdelim %] => Ticket Kurzbeschreibung</li>
                                <li>[% $smarty.ldelim %]Priority[% $smarty.rdelim %] => Ticketpriorität</li>
                                <li>[% $smarty.ldelim %]Status[% $smarty.rdelim %] =>  Ticketstatus</li>
                                <li>[% $smarty.ldelim %]TicketTypeName[% $smarty.rdelim %] =>  Tickettyp</li>
                            </ul>
                            <h3>[% $user->gettext('Body') %]</h3>
                            <p>[% $user->gettext('Im Inhalt der Benachrichtigung können Sie folgende Platzhalter verwenden') %]:</p>
                            <ul>
                                <li>[% $smarty.ldelim %]TicketID[% $smarty.rdelim %] => TicketID</li>
                                <li>[% $smarty.ldelim %]Title[% $smarty.rdelim %] => Tickettitel (Kurzbeschreibung)</li>
                                <li>[% $smarty.ldelim %]Description[% $smarty.rdelim %] => Ticketbeschreibung (erste Bearbeitung)</li>
                                <li>[% $smarty.ldelim %]TicketURL[% $smarty.rdelim %] => Link zum Ticket</li>
                                <li>[% $smarty.ldelim %]Status[% $smarty.rdelim %] => Ticketstatus</li>                                                                

                                <li>[% $smarty.ldelim %]Priority[% $smarty.rdelim %] => Priorität</li>
                                <li>[% $smarty.ldelim %]Category1[% $smarty.rdelim %] => Kategorie 1</li>
                                <li>[% $smarty.ldelim %]Category2[% $smarty.rdelim %] => Kategorie 2</li>
                                <li>[% $smarty.ldelim %]CreateDate[% $smarty.rdelim %] => Erstellungsdatum des Tickets</li>
                                <li>[% $smarty.ldelim %]DesireDate[% $smarty.rdelim %] => Fälligkeitsdatum</li>

                                <li>[% $smarty.ldelim %]SupporterName[% $smarty.rdelim %] => Name des Supporters</li>
                                <li>[% $smarty.ldelim %]SupporterEMail[% $smarty.rdelim %] => Mailadresse des Supporters</li>

                                <li> [% $smarty.ldelim %]TicketTypeName[% $smarty.rdelim %] => [% $user->gettext('Name des Tickettyps') %]</li>
                                <li> [% $smarty.ldelim %]TicketTypeDescr[% $smarty.rdelim %] => [% $user->gettext('Beschreibung des Tickettyps') %]</li>
                                <li> [% $smarty.ldelim %]MandantEMail[% $smarty.rdelim %] => [% $user->gettext('Mailadresse des zugewiesenen Mandanten') %]</li>
                            </ul>
                            <h4>[% $user->gettext('Kontaktdaten') %]</h4>
                            <ul>
                                <li>[% $smarty.ldelim %]ContactName[% $smarty.rdelim %] => Kontakt</li>
                                <li>[% $smarty.ldelim %]ContactMail[% $smarty.rdelim %] => Mailadresse des Kontakts</li>
                                <li>[% $smarty.ldelim %]ContactSalutation[% $smarty.rdelim %] => Anrede des Kontakts</li>
                                <li>[% $smarty.ldelim %]ContactSurname[% $smarty.rdelim %] => Vorname des Kontakts</li>
                                <li>[% $smarty.ldelim %]ContactPrename[% $smarty.rdelim %] => Nachname des Kontakts</li>                                                                                                
                                <li>[% $smarty.ldelim %]ContactCompany[% $smarty.rdelim %] => Firmenname des Kontakts</li>
                                <li>[% $smarty.ldelim %]ContactStreet[% $smarty.rdelim %] => Straße</li>
                                <li>[% $smarty.ldelim %]ContactZip[% $smarty.rdelim %] => PLZ</li>
                                <li>[% $smarty.ldelim %]ContactCity[% $smarty.rdelim %] => Stadt</li>
                                <li>[% $smarty.ldelim %]ContactPhone[% $smarty.rdelim %] => Telefonnummer des Kontakts</li>                                
                            </ul>

                        </div>
                    </div>                        
                </div>
            </div>

        </form>
    </div>
</div>


<script>

    $("#TemplateID").select2({theme: 'bootstrap-5',
        //tags: true
    }).on('select2:select', function (e) {

        $.ajax({
            url: 'index.php?module=settings&event=getMailtemplateData&id=' + $("#TemplateID").val(), // url where to submit the request
            type: "POST", // type of action POST || GET
            dataType: 'json', // data type
            success: function (result) {
                //console.log(result);

                $('#Content').val(result.content);
                $('#Subject').val(result.subject);
                $('#Active').prop("checked", result.active);
                $('#TemplateTitle').val(result.templatetitle);

            },
            error: function (xhr, resp, text) {
                console.log(xhr, resp, text);
            }
        })

    })

    $("#SaveTemplate").on('click', function (e) {
        e.preventDefault();
        // send ajax
        
        if($("#TemplateTitle").val() == ''){
            $("#TemplateTitle").closest(".form-group row mb-3").addClass('has-error').focus();
            $("#TemplateTitle").focus();
                    noty({
                        text: '[% $user->gettext("Bitte geben Sie ein Titel für das Template ein") %]',                        
                        type: 'error',
                        layout: 'top',
                        //theme: 'bootstrapTheme',
                        closeWith: ['click', 'hover']
                    });            
            return false;
        }
        $.ajax({
            url: 'index.php?module=settings&event=addMailTemplate&save=1', // url where to submit the request
            type: "POST", // type of action POST || GET
            dataType: 'json', // data type
            data: $("#TemplateForm").serialize(), // post data || get data
            success: function (result) {
                if (result == 1) {
                    //noty:
                    noty({
                        text: '[% $user->gettext("Template wurde gespeichert") %]',
                        type: 'success',
                        layout: 'top',
                        //theme: 'bootstrapTheme',
                        timeout: notifyTimeout,
                        closeWith: ['click', 'hover']
                    });
                } else {
                    //noty:
                    noty({
                        text: '[% $user->gettext("Fehler: Template konnte nicht gespeichert werden") %]',
                        type: 'error',
                        layout: 'top',
                        //theme: 'bootstrapTheme',
                        timeout: notifyTimeout,
                        closeWith: ['click', 'hover']
                    });
                }
            },
            error: function (xhr, resp, text) {
                console.log(xhr, resp, text);
            }
        })
    })

    $("#TestTemplate").on('click', function (e) {
        e.preventDefault();
        // send ajax
        $.ajax({
            url: 'index.php?module=settings&event=testTemplate', // url where to submit the request
            type: "POST", // type of action POST || GET
            dataType: 'json', // data type
            data: $("#TemplateForm").serialize(), // post data || get data
            success: function (result) {
                console.log(result);
                if (result.error) {

                    noty({
                        text: result.message,
                        type: 'error',
                        layout: 'top',
                        //theme: 'bootstrapTheme',
                        timeout: notifyTimeout,
                        closeWith: ['click', 'hover']
                    });
                } else {
                    noty({
                        text: result.message,
                        type: 'success',
                        layout: 'top',
                        //theme: 'bootstrapTheme',
                        timeout: notifyTimeout,
                        closeWith: ['click', 'hover']
                    });
                }


            },
            error: function (xhr, resp, text) {
                console.log(xhr, resp, text);
            }
        })
    })

    $('#DeleteTemplate').on('click', function (e) {
        e.preventDefault();
        bootbox.confirm('[% $user->gettext('M&ouml;chten Sie das Mailtemplate l&ouml;schen?') %]', function (result) {
            if (result) {
                // send ajax
                TemplateID = $("#TemplateID").val();
                $.ajax({
                    url: 'index.php?module=settings&event=deleteTemplate&delete=1&id=' + TemplateID, // url where to submit the request
                    type: "POST", // type of action POST || GET
                    dataType: 'json', // data type
                    success: function (result) {
                        if (result == 1) {

                            $('#TemplateID').val(null).trigger('change');
                            $('#TemplateID option[value="' + TemplateID + '"]').detach();

                            //noty:
                            noty({
                                text: '[% $user->gettext("Template wurde gelöscht") %]',
                                type: 'success',
                                layout: 'top',
                                //theme: 'bootstrapTheme',
                                timeout: notifyTimeout,
                                closeWith: ['click', 'hover']
                            });
                        } else {
                            //noty:
                            noty({
                                text: '[% $user->gettext("Fehler: Template konnte nicht gelöscht werden") %]',
                                type: 'error',
                                layout: 'top',
                                //theme: 'bootstrapTheme',
                                timeout: notifyTimeout,
                                closeWith: ['click', 'hover']
                            });
                        }

                    },
                    error: function (xhr, resp, text) {
                        console.log(xhr, resp, text);
                    }
                })

            }
        })
    })



    $(document).ready(function () {
        $(".dialog").fancybox({
            maxWidth: 800,
            maxHeight: 700,
            closeClick: false
        });
    });

</script>
