<style>
    .dropArea{
  float: right;
  height: 200px;
  width: 200px;
  line-height: 200px;
  padding: 10px;
  margin: 20px;
  border-radius: 20px;
  background-color: Yellow;
  font-family: tahoma, arial;
  text-align: center;
}

.folder{
  padding-left: 30px;
  white-space: nowrap;
}
</style>

<div id="dropArea" class="dropArea">
  DATEI HIER DRAGGEN
</div>

<div id="output" class="output">
</div>

<script>
    var dropArea = document.querySelector("#dropArea");

dropArea.addEventListener(
  "dragover",
  function(e) {
    e = e || event;
    e.preventDefault();
  },
  false
);

dropArea.addEventListener(
  "drop",
  function(event) {
    var items = event.dataTransfer.items;
    console.log(event.dataTransfer.files);
    event.preventDefault();

    getFilesDataTransferItems(items).then(files => {
        console.log("OUTPUT FILES:", files);
      var rawOutput = JSON.stringify(files),
        output = rawOutput
          .substring(1, rawOutput.length - 1)
          .replace(/},/g, "}<br/>")
          .replace(/\[/g, "[<div class='folder'>")
          .replace(/\]/g, "]</div>");
  console.log(rawOutput);
      document.querySelector("#output").innerHTML = output;
    });
  },
  false
);

/**
 * Die Datei in index.php?module=upload hochladen
 */
function uploadFile(file, filePath) {
    var url = 'index.php?module=upload';
    var xhr = new XMLHttpRequest()
    var formData = new FormData()
    xhr.open('POST', url, true)

    xhr.addEventListener('readystatechange', function(e) {
      if (xhr.readyState == 4 && xhr.status == 200) {
        // Done. Inform the user
      }
      else if (xhr.readyState == 4 && xhr.status != 200) {
        // Error. Inform the user
      }
    })

    formData.append('UploadFile', file);
    formData.append('FilePathFolder', filePath);
    formData.append('ShortDescr', 'Drag und Drop');
    xhr.send(formData);
}


function getFilesDataTransferItems(dataTransferItems) {
  function traverseFileTreePromise(item, path = "", folder) {
    return new Promise(resolve => {
        console.log(item);
      if (item.isFile) {
           // console.log("Is File");
        item.file(file => {
          file.filepath = path || "" + file.name; //save full path
          console.log("Here is a file: ", file);
          console.log("Here is the full path : ", item.fullPath);
          folder.push(file.name);
          console.log("Folder of file: ", folder);
          uploadFile(file, item.fullPath);
          resolve(file);
        });
      } else if (item.isDirectory) {
          //console.log("Is Directory");
          console.log(item.file);
        let dirReader = item.createReader();
        dirReader.readEntries(entries => {
          let entriesPromises = [];
          subfolder = [];
          folder.push({ name: item.name, subfolder: subfolder });
          for (let entr of entries)
            entriesPromises.push(
              traverseFileTreePromise(entr, path || ""  + item.name + "/", subfolder)
            );
          resolve(Promise.all(entriesPromises));
        });
      }
    });
  }

  let files = [];
  return new Promise((resolve, reject) => {
    let entriesPromises = [];
    for (let it of dataTransferItems)
      entriesPromises.push(
        traverseFileTreePromise(it.webkitGetAsEntry(), null, files)
      );
    Promise.all(entriesPromises).then(entries => {
      resolve(files);
    });
  });
}


  function addFiles(e){
        e.stopPropagation();
        e.preventDefault();

        // if directory support is available
        if(e.dataTransfer && e.dataTransfer.items)
        {
            var items = e.dataTransfer.items;
            for (var i=0; i<items.length; i++) {
                var item = items[i].webkitGetAsEntry();

                if (item) {
                  addDirectory(item);
                }
            }
            return;
        }

        // Fallback
        var files = e.target.files || e.dataTransfer.files;
        if (!files.length)
        {
            alert('File type not accepted');
            return;
        }

        processFile(files);
    }

    function addDirectory(item) {
        var _this = this;
        if (item.isDirectory) {
            var directoryReader = item.createReader();
            directoryReader.readEntries(function(entries) {
            entries.forEach(function(entry) {
                    _this.addDirectory(entry);
                });
            });
        } else {
            item.file(function(file){
                processFile([file],0);
            });
        }
    }

</script>

