
<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>
<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <div class="row">
            <div class="col-sm-8">
                <span class="fcs-card-title h2">[% $user->gettext('Textbausteine') %]</span>
            </div>
            <div class="col-sm-4 text-end">
                 [% if $user->hasRight(225) || $user->hasRight(224) || $user->hasRight(227) %]
                <button role='button' class='btn btn-outline-primary lightContrast' onclick="window.location = 'index.php?module=ticket&class=snippets&event=addNew'">[% $user->gettext('Textbaustein erstellen') %]</button>
                [% /if %]
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>                   
                    <tr>

                        <th>
                            [% $user->gettext('Titel') %]
                        </th>
                        <th>
                            [% $user->gettext('Inhalt') %]
                        </th>
                        <th>
                            [% $user->gettext('Rubrik') %]
                        </th>
                         <th>
                            [% $user->gettext('Veröffentlicht') %]
                        </th>
                        <th>
                            [% $user->gettext('Erstellt von') %]
                        </th>

                        <th>
                            [% $user->gettext('Aktion') %]

                        </th>
                    </tr>
                </thead>
                <tbody>
                    [% foreach from=$Snippets item=Snippet %]
                        <tr id="Snippet_[% $Snippet.ID %]">

                            <td style="word-wrap: break-word;">[% $Snippet.Title %]</td>
                            <td style="word-wrap: break-word;">[% $Snippet.Snippet %]</td>
                            <td style="word-wrap: break-word;">[% $Snippet.Rubric %]</td>
                            <td style="word-wrap: break-word;">[% if $Snippet.ispublic %]<span class='fa fa-check'></span>[% /if %]</td>
                            <td>
                                [% $Snippet.CreateUserName %]
                            </td>
                            <td>
                                [%  if $Snippet.CreateUserID == $user->UserID || $user->hasRight(225) %]
                                    <input type="button" class="btn btn-outline-secondary btn-sm" value="[% $user->gettext('Bearbeiten') %]" onclick='window.location = "index.php?module=ticket&class=snippets&event=editSnippet&id=[% $Snippet.ID %]"' />
                                    <input type="button" class="btn btn-outline-secondary btn-sm" value="[% $user->gettext('Löschen') %]" onclick="deleteSnippet([% $Snippet.ID %])" />
                                [% /if %]
                            </td>
                        </tr>
                    [% /foreach %]
                </tbody>
            </table>                    
        </div>
    </div>
</div> 
<script>
    /*
     function deleteSnippet(id) {
     var conf = confirm("Textbaustein wirklich löschen?");
     if (conf) {
     $.post("index.php?module=ticket&class=snippets&event=delete&id=" + id, function (data) {
     if (data == 1) {
     $("#Snippet_" + id).hide();
     }
     });
     }
     }
     */
    function deleteSnippet(id) {
        bootbox.confirm("[% $user->gettext('Textbaustein wirklich löschen?') %]", function (result) {
            if (result) {
                $.post("index.php?module=ticket&class=snippets&event=delete&id=" + id, function (data) {
                    if (data == 1) {
                        $("#Snippet_" + id).hide();
                    }
                });
            }
        })
    }
$(document).ready(function () {
        $('.table').DataTable({
            dom: 'Bfrtip',
            buttons: [
//                'colvis',
                'excel',
                'print',
                'pdfHtml5'
            ],
            stateSave: true,
            ordering: false,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            },
            initComplete: function () {
                this.api().columns().every(function () {
                    var column = this;
                    var select = $('<select><option value=""></option></select>')
                            .appendTo($(column.footer()).empty())
                            .on('change', function () {
                                var val = $.fn.dataTable.util.escapeRegex(
                                        $(this).val()
                                        );

                                column
                                        .search(val ? '^' + val : '', true, true)
                                        .draw();
                            });
                    column.data().unique().sort().each(function (d, j) {
                        select.append('<option value="' + d + '">' + d + '</option>')
                    });
                });
            }
        });
    });
</script>

