<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h2">[% $user->gettext('Dokumente importieren') %]</span>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-lg-2"></div>
            <div class="col-lg-8 ">
                <div class="card panel-info shadow-sm rounded">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-sm-6">
                                <span class="fcs-card-title h4">Dokumente importieren</span>
                            </div>
                            <div class="col-sm-6 text-end">
                                <div class="btn-group">
                                    <input type="button" class="btn btn-outline-primary" onclick="importDocs(1);" value="[% $user->gettext('Start') %]" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">

                        <h3>Knowledgebase</h3>
                        <div class="progress">
                            <div class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" style="width: 100%">
                                <span class="sr-only">40% Complete (success)</span>
                            </div>
                        </div>
                        <h3>Tickets</h3>
                        <div class="progress">
                            <div id="ProgressBarTickets" class="progress-bar" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width: 0%;">
                                <span class="sr-only">60% Complete</span>
                            </div>
                        </div>
                        <h3>Ticketevents</h3>
                        <div class="progress">
                            <div  id="ProgressBarTicketEvents" class="progress-bar" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width: 0%;">
                                <span class="sr-only">60% Complete</span>
                            </div>
                        </div>                        
                    </div>
                </div>                    
            </div>
        </div>

    </div>
</div>




<script>


    $(document).ready(function () {


    });

    /**
     * Comment
     */
    function importDocs(restart) {
        $.post('index.php?module=upload&event=importM42Docs', {restart: restart}, function (data) {

            $('#ProgressBarTickets').css('width', data.cntTicketDocsPercent + '%').html(data.cntProcessedTickets + ' / ' + data.cntAllTicketDocsStart);
            if (data.cntTicketDocsPercent == 100) {
                $('#ProgressBarTickets').addClass('progress-bar-success');
            }
            $('#ProgressBarTicketEvents').css('width', data.cntTicketEventDocsPercent + '%').html(data.cntProcessedTicketEvents + ' / ' + data.cntAllTicketEventDocsStart);
            if (data.cntTicketEventDocsPercent == 100) {
                $('#ProgressBarTicketEvents').addClass('progress-bar-success');
            }

            if (data.cntTicketDocsPercent != 100 || data.cntTicketEventDocsPercent != 100) {
                importDocs(0);
            }
        });
    }


</script>