<div id="WFFieldList">
    [% foreach from=$Elements key=FieldID item=field name=fieldlist%]
        <div  [% if $field.SubFormForField|trim !== '' %][% else %]class="connectedRow"[% /if %] id="div_[% $FieldID %]">
            <div class="card panel-info shadow-sm rounded"  id="field_[% $FieldID %]">
                <div class="card-header sortableHandle">
                    <div class="row">
                        <div class="col-sm-6">
                            <span class="fcs-card-title h4">
                                [% $user->gettext('Feld:') %] [% $field.name %]
                                <select name="[% $field.name %]_Container" class="form-control">
                                    <option [% if $field.container == 0 %] selected="selected" [% /if %] value="0">Kein Container</option>
                                    [% html_options options=$fieldcontainer selected=$field.container %]
                                </select>
                            </span>
                            [% if $field.SubFormForField|trim !== '' %]
                                [% assign var="isSubField" value=true %]
                                <span class="fcs-card-title">
                                    [% $user->gettext('Übergabefeld:') %]
                                </span>
                                <input type="hidden" name="field[[% $FieldID %]][SubFormForField]" value="[% $field.SubFormForField %]" />
                                <input type="hidden" name="field[[% $FieldID %]][SubFormForElement]" value="[% $field.SubFormForElement %]" />
                                <input type="hidden" name="field[[% $FieldID  %]][max]" value="[% if $field.max > 0 %][% $field.max %][% /if %]" />
                            [% /if %]
                        </div>
                        <div class="col-sm-6 text-end">
                            <div class="btn-group">
                                [% if $Tools->FCS_Count($field.usedElements) == 0 %]
                                    <span class="btn btn-outline-secondary" onclick="removeField($(this));"> <span class="fa fa-trash"  title="[% $user->gettext('Feld l&ouml;schen') %]"></span></span>
                                    <input type="hidden" name="field[[% $FieldID %]][remove]" value="" id="removeField[% $FieldID %]" />
                                [% else %]
                                    <span class="btn btn-outline-secondary disabled" title="[% $user->gettext('Feld kann nicht gel&ouml;scht werden da es in anderen Aktivit&auml;ten verwendet wird.') %]">  <span class="fa fa-trash"></span> </span>
                                [% /if %]
                                [% if $smarty.foreach.fieldlist.iteration > 1 %]
                                    <a href="index.php?module=workflow&event=activityform&id=[% $form.formid %]&action=up&fid=[% $FieldID  %][% if $ActivityDef %]&ad=1[% /if %]" class="btn btn-outline-secondary" title="[% $user->gettext('Feld nach oben verschieben') %]"><span class="fa fa-chevron-up"></span></a>
                                    [% /if %]
                                    [% if $smarty.foreach.fieldlist.iteration < $Tools->FCS_Count($form.fields) %]
                                    <a href="index.php?module=workflow&event=activityform&id=[% $form.formid %]&action=down&fid=[% $FieldID  %][% if $ActivityDef %]&ad=1[% /if %]" class="btn btn-outline-secondary" title="[% $user->gettext('Feld nach unten verschieben') %]"><span class="fa fa-chevron-down"></span></a>
                                    [% /if %]
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group row mb-3">
                                <label title="[% $user->gettext('Der Feldtitel wird als Beschreibung des Eingabefeldes angezeigt') %]" class="control-label col-sm-8">
                                    [% $user->gettext('Feldtitel:') %]
                                </label>
                                <div class="col-sm-4">
                                    <input type="hidden" name="field[[% $FieldID  %]][name]" value="[% $field.name %]" />
                                    <input name="field[[% $FieldID  %]][title]" pattern="[ ()a-zA-Z0-9\x7f-\xff]+" value="[% $field.title %]" title="[% $user->gettext('Titel darf nur Buchstaben und Zahlen enthalten.')%]" type="text" class="form-control" [% if $Tools->FCS_Count($field.usedElements) %]readonly="readonly"[% /if %]/>
                                </div>
                            </div>

                            <div class="form-group row mb-3">
                                <label title="[% $user->gettext('Der Feldtitel wird als Beschreibung des Eingabefeldes angezeigt') %]" class="control-label col-sm-8">
                                    [% $user->gettext('Feldtyp:') %]
                                </label>
                                <div class="col-sm-4">
                                    <select name="field[[% $FieldID  %]][type]" class="form-control">
                                        [% if $Tools->FCS_Count($field.usedElements) == 0 %]
                                            <option value="" disabled>[% $user->gettext('Feldtyp wählen') %]</option>
                                            <option value="text"[% if $field.type == "text" %] selected="selected"[% /if %] title="[% $user->gettext('Einzeiliges Eingabefeld') %]">[% $user->gettext('Textfeld') %]</option>
                                            <option value="textarea"[% if $field.type == "textarea" %] selected="selected"[% /if %] title="[% $user->gettext('Mehrzeiliges Eingabefeld') %]">[% $user->gettext('Textbereich') %]</option>
                                        [% /if %]

                                        <option value="checkbox"[% if $field.type == "checkbox" %] selected="selected"[% /if %] title="[% $user->gettext('Zeigt die definierten Werte zum abhaken an') %]">[% $user->gettext('Checkbox') %]</option>
                                        <option value="radio"[% if $field.type == "radio" %] selected="selected"[% /if %] title="[% $user->gettext('Zeigt die definierten Werte zur Auswahl an. Es kann nur einer der Werte gewählt werden.') %]">[% $user->gettext('Radio Button') %]</option>
                                        <option value="select"[% if $field.type == "select" %] selected="selected"[% /if %] title="[% $user->gettext('Ein Wert aus einer vordefinierten Liste kann gewählt werden') %]">[% $user->gettext('Auswahlliste') %]</option>
                                        <option value="value"[% if $field.type == "value" %] selected="selected"[% /if %] title="[% $user->gettext('Es können mehrere Werte von ... bis ... definiert werden. Im Formular ist dann einer dieser Wertebereiche wählbar.') %]">[% $user->gettext('Wertebereich') %]</option>
                                        <option value="assets"[% if $field.type == "assets" %] selected="selected"[% /if %] title="[% $user->gettext('Asset wird gespeichert.') %]">[% $user->gettext('Asset') %]</option>
                                        [% if $Tools->FCS_Count($field.usedElements) == 0 %]
                                            <option value="date"[% if $field.type == "date" %] selected="selected"[% /if %] title="[% $user->gettext('Eingabefeld mit Datumsauswahl') %]">[% $user->gettext('Datum') %]</option>
                                            <option value="datetime"[% if $field.type == "datetime" %] selected="selected"[% /if %] title="[% $user->gettext('Eingabefeld mit Datum- und Zeitauswahl') %]">[% $user->gettext('Datum und Zeit') %]</option>
                                            <option value="integer"[% if $field.type == "integer" %] selected="selected"[% /if %] title="[% $user->gettext('Eingabefeld für ganzen Zahlen von 0 bis 10000') %]">[% $user->gettext('Integer 0 - 10000') %]</option>
                                            <option value="notice"[% if $field.type == "notice" %] selected="selected"[% /if %] title="[% $user->gettext('Der definierte Text wird im Formular angezeigt. Es ist keine Eingabe möglich.') %]">[% $user->gettext('Notiz') %]</option>
                                            <option value="seperator"[% if $field.type == "seperator" %] selected="selected"[% /if %] title="[% $user->gettext('Fügt dem Formular eine Trennlinie zu') %]">[% $user->gettext('Trenner') %]</option>

                                            <option value="userdata"[% if $field.type == "userdata" %] selected="selected"[% /if %] title="[% $user->gettext('Benutzerdaten des Bearbeiters werden gespeichert und angezeigt') %]">[% $user->gettext('Benutzerdaten') %]</option>
                                            <option value="selecteduserdata"[% if $field.type == "selecteduserdata" %] selected="selected"[% /if %] title="[% $user->gettext('Benutzerdaten eines ausgewählten Benutzer werden gespeichert und angezeigt') %]">[% $user->gettext('Benutzerdaten (mit Auswahlliste)') %]</option>
                                            <option value="selectedcontactdata"[% if $field.type == "selectedcontactdata" %] selected="selected"[% /if %] title="[% $user->gettext('Kontaktdaten eines ausgewählten Kontaktes werden gespeichert und angezeigt') %]">[% $user->gettext('Kontaktdaten (mit Auswahlliste)') %]</option>


                                        [% /if %]
                                        <option value="optionsWithAddress"[% if $field.type == "optionsWithAddress" %] selected="selected"[% /if %] title="[% $user->gettext('Durch dieses Formularelement können Sie die Adressaten von nachfolgenden Aktivitäten abhängig von der gewählten Option definieren') %]">[% $user->gettext('Auswahl mit Adressierung') %]</option>
                                        <option value="AdressSelection" [% if $field.type == "AdressSelection" %] selected="selected"[% /if %] title="[% $user->gettext('Durch dieses Formularelement können Sie die Adressaten von nachfolgenden Aktivitäten aus der Heinzelmann-Benutzerliste wählen') %]">[% $user->gettext('Adressat zuweisen') %]</option>

                                        <option value="AdressSelectionFiltered" [% if $field.type == "AdressSelectionFiltered" %] selected="selected"[% /if %] title="[% $user->gettext('Durch dieses Formularelement können Sie die Adressaten von nachfolgenden Aktivitäten aus der Heinzelmann-Benutzerliste wählen') %]">[% $user->gettext('Adressat zuweisen (gefiltert)') %]</option>

                                        [% if $withDataStructure %]
                                            <option value="DataStructure" [% if $field.type == "DataStructure" %] selected="selected"[% /if %] title="[% $user->gettext('Durch dieses Formularelement können Sie die Adressaten von nachfolgenden Aktivitäten aus Ihrer Datenstruktur wählen') %]">[% $user->gettext('Auswahl aus Datenstruktur') %]</option>
                                        [% /if %]


                                        [% if $withBestellkatalog  %]
                                            <option value="Bestellkatalog" [% if $field.type == "Bestellkatalog" %] selected="selected"[% /if %] [% if $BestellKatalogExisted && $field.type != "Bestellkatalog"%]disabled[% /if %] title="[% $user->gettext('Durch dieses Formularfeld können Bestellungen mit importierten Artikeln durchgeführt werden') %]">[% $user->gettext('Bestellkatalog') %]</option>
                                        [% /if %]
                                        [% if $withAssetDeskOrderCatalog %]
                                            <option value="AssetDeskOrderCatalog" [% if $field.type == "AssetDeskOrderCatalog" %] selected="selected"[% /if %] [% if $AssetDeskOrderCatalogExisted && $field.type != "AssetDeskOrderCatalog"%]disabled[% /if %] title="[% $user->gettext('Durch dieses Formularfeld können Bestellungen mit Artikeln aus AssetDesk durchgeführt werden') %]">[% $user->gettext('Bestellkatalog') %] (Asset.Desk)</option>
                                        [% /if %]
                                        <option value="checklist" [% if $field.type == "checklist" %] selected="selected"[% /if %] title="[% $user->gettext('Ist diese Pflichtfeld müssen alle Checkboxen angehakt sein.') %]">[% $user->gettext('Checkliste') %]</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row mb-3">
                                <label title="[% $user->gettext('Ist diese Option gesetzt, wird der Feldinhalt unter dem Titel angezeigt.') %]" class="control-label col-sm-8">
                                    [% $user->gettext('Feldinhalt unter dem Titel anzeigen') %]
                                </label>
                                <div class="col-sm-4">
                                    <input type="checkbox" value="Y" name="field[[% $FieldID  %]][showundertitle]" [% if $field.showundertitle == "Y" %]checked="checked"[% /if %] />
                                </div>
                            </div>           
                            <div class="form-group row mb-3">
                                <label title="[% $user->gettext('Ist diese Option gesetzt, werden die Daten dieses Formularfeldes in Workflow-Berichte nicht anzeigen.') %]" class="control-label col-sm-8">
                                    [% $user->gettext('Daten im Workflow-Bericht nicht anzeigen') %]
                                </label>
                                <div class="col-sm-4">
                                    <input type="checkbox" value="Y" name="field[[% $FieldID  %]][hideonreport]" [% if $field.hideonreport == "Y" %]checked="checked"[% /if %] />
                                </div>
                            </div>
                            <div class="form-group row mb-3">
                                <label class="control-label col-sm-8">
                                    [% $user->gettext('Breite des Feldes') %]
                                </label>
                                <div class="col-sm-4">
                                    <input type="radio" [% if !$field.columnwidth || $field.columnwidth == '12' %]checked="checked"[% /if %] value="12" name="field[[% $FieldID  %]][columnwidth]">[% $user->gettext('Ganz') %]
                                    <input type="radio" [% if $field.columnwidth == '6' %]checked="checked"[% /if %] value="6" name="field[[% $FieldID  %]][columnwidth]">[% $user->gettext('Halb') %]
                                    <input type="radio" [% if $field.columnwidth == '3' %]checked="checked"[% /if %] value="3" name="field[[% $FieldID  %]][columnwidth]">[% $user->gettext('Drittel') %]
                                </div>
                            </div>
                            [% if $field.type != "seperator" %]
                                <div class="form-group row mb-3">
                                    <label title="[% $user->gettext('Ist diese Option gesetzt, werden die Daten dieses Formularfeldes in nachfolgenden Aktivitäten angezeigt, sofern das dort definiert ist (Daten aus vorherigen Aktivitäten anzeigen).') %]" class="control-label col-sm-8">
                                        [% $user->gettext('Daten in anderen Aktivitäten anzeigen') %]
                                    </label>
                                    <div class="col-sm-4">
                                        <input type="checkbox" value="Y" name="field[[% $FieldID  %]][show]" [% if $field.show == "Y" %]checked="checked"[% /if %] />
                                    </div>
                                </div>
                            [% /if %]
                            [% if $field.type == "select" %]
                                <div class="form-group row mb-3">
                                    <label title="[% $user->gettext('Ist diese Option gesetzt, kann die Auswahlliste mehrere Werte enthalten.') %]" class="control-label col-sm-8">
                                        [% $user->gettext('Mehrfachauswahl') %]
                                    </label>
                                    <div class="col-sm-4">
                                        <input type="checkbox" value="Y" name="field[[% $FieldID  %]][multiselect]" [% if $field.multiselect == "Y" %]checked="checked"[% /if %] />
                                    </div>
                                </div>
                            [% /if %]
                            [% if $field.type != "seperator" && $field.type != "notice" && $field.type != "userdata" && $field.type != "Bestellkatalog" && $field.type  != "AssetDeskOrderCatalog" %]
                                <div class="form-group row mb-3">
                                    <label class="control-label col-sm-8">
                                        [% $user->gettext('Pflichtfeld') %]
                                    </label>
                                    <div class="col-sm-4">
                                        <input type="checkbox" value="Y" name="field[[% $FieldID  %]][required]" [% if $field.required == "Y" %]checked="checked"[% /if %] />
                                    </div>
                                </div>
                            [% /if %]
                            [% if !$isSubField && ($field.type == "checkbox" || $field.type == "checklist" || $field.type == "radio" || $field.type == "select" || $field.type == "optionsWithAddress" || $field.type == "value" || $field.type == "Bestellkatalog" || $field.type  == "AssetDeskOrderCatalog") %]
                                <div class="form-group row mb-3">
                                    <label class="control-label col-sm-8" title="[% $user->gettext('Wenn Sie Aktivitäten abhängig von den gewählten Formulardaten starten möchten, müssen Sie das Formularfeld durch diese Option für dafür aktivieren') %]">
                                        [% $user->gettext('Zugriff auf Verzweigung durch Nachfolgeaktivitäten') %]
                                    </label>
                                    <div class="col-sm-4">
                                        [% if $Tools->FCS_Count($field.usedElements) && $field.branch == "Y" %]
                                            <input type="hidden" name="field[[% $FieldID  %]][branch]" value="Y" />
                                            <input type="checkbox"  [% if $field.branch == "Y" %]checked="checked" disabled="disabled"[% /if %] />
                                        [% else %]

                                            <input type="checkbox" value="Y" name="field[[% $FieldID  %]][branch]" [% if $field.branch == "Y" %]checked="checked"[% /if %] [% if $isLoopPossible.LoopAllowedIsChecked && $isLoopPossible.cntBranches > 0 %]disabled="disabled"[% /if %]/>
                                            [% if $isLoopPossible.LoopAllowedIsChecked && $isLoopPossible.cntBranches > 0 %]
                                                <details>
                                                    <summary>[% $user->gettext('Weitere Verzweigungen sind nicht möglich') %]</summary>
                                                        [% $user->gettext('Die Aktivität ist als Schleife definiert.<br/>Eine weitere Verzweigung ist in einer Schleifenaktivität nicht erlaubt.') %]
                                                </details>
                                            [% /if %]
                                        [% /if %]
                                    </div>
                                </div>
                            [% /if %]
                        </div>


                        <div class="col-sm-6">
                            [% if $field.type == "notice" %]
                                <div class="form-group row mb-3">
                                    <div class="col-sm-12">
                                        <div id="toolbar-container-[% $FieldID  %]">
                                            <span class="ql-formats">
                                                <select class="ql-size" title="[% $user->gettext('Schriftgröße') %]">
                                                    <option value="small"></option>
                                                    <option selected=""></option>
                                                    <option value="large"></option>
                                                    <option value="huge"></option>
                                                </select>
                                            </span>
                                            <span class="ql-formats">
                                                <button class="ql-bold" title="[% $user->gettext('Fett') %]"></button>
                                                <button class="ql-italic" title="[% $user->gettext('Kursiv') %]"></button>
                                                <button class="ql-underline" title="[% $user->gettext('Unterstrichen') %]"></button>
                                                <button class="ql-strike" title="[% $user->gettext('Durchgestrichen') %]"></button>
                                                <button class="ql-link" title="[% $user->gettext('Link') %]"></button>

                                            </span>
                                            <span class="ql-formats">
                                                <select class="ql-color" title="[% $user->gettext('Textfarbe') %]"></select>
                                                <select class="ql-background" title="[% $user->gettext('Text-Hintergrundfarbe') %]"></select>
                                            </span>
                                            <span class="ql-formats">
                                                <button class="ql-list" value="ordered" title="[% $user->gettext('Geordnete Liste') %]"></button>
                                                <button class="ql-list" value="bullet" title="[% $user->gettext('Aufzählungsliste') %]"></button>
                                            </span>
                                            <span class="ql-formats">
                                                <a href="index.php?module=ticket&class=snippets&event=listSnippets&fieldid=[% $FieldID  %]" title="[% $user->gettext('Textbaustein wählen') %]" class="openInBigIFrameModal" id="insertSnippet"><img src="images/project.png"></a>
                                                <a href="index.php?module=ticket&class=snippets" id="showSnippetlist" class="dialog_ticketlist" title="[% $user->gettext('Alle Textbausteine') %]"><img src="images/content.png"></a>
                                                <a href="#addSnippet" id="showAddSnippet" class="dialog_medium" style="" title="[% $user->gettext('Textbaustein hinzufügen') %]"><img src="images/project_add.png"></a>
                                            </span>
                                            <span class="ql-formats">
                                                <button type="button" id="editHTMLBtn_[% $FieldID  %]" title="Reiner Text"><span class="fa fa-code"></span></button>
                                            </span>
                                        </div>
                                        <div id="quill_[% $FieldID  %]" style="min-height: 200px;">
                                        </div>
                                        <textarea class="form-control wf_textarea" style="height: 0px; visibility:hidden;" id="textarea_[% $FieldID  %]" rows="8" name="field[[% $FieldID  %]][descr]">[% $field.descr %]</textarea>
                                       <!-- <textarea class="form-control wf_textarea" style="height: 200px;" id="textarea_[% $FieldID  %]" rows="8" name="field[[% $FieldID  %]][descr]">[% $field.descr %]</textarea>-->
                                    </div>
                                </div>
                            [% /if %]
                            [% if $field.type == "text" || $field.type == "textarea" %]
                                <div class="form-group row mb-3">
                                    <label class="control-label col-sm-8">
                                        [% $user->gettext('Feldl&auml;nge (1-48, Standard 30)') %]
                                    </label>
                                    <div class="col-sm-4">
                                        <input type="text" class="form-control"  name="field[[% $FieldID  %]][size]" value="[% if $field.size > 0 && $field.size != 30 %][% $field.size %][% /if %]" />
                                    </div>
                                </div>
                            [% /if %]
                            [% if $field.type == "text" %]
                                <div class="form-group row mb-3">
                                    <label class="control-label col-sm-8">
                                        [% $user->gettext('Min. Zeichenanzahl') %]
                                    </label>
                                    <div class="col-sm-4">
                                        <input type="text" class="form-control" name="field[[% $FieldID  %]][min]" value="[% if $field.min > 0 && $field.min != 1 %][% $field.min %][% /if %]  " />
                                    </div>
                                </div>
                            [% /if %]
                            [% if $field.type == "text" %]
                                <div class="form-group row mb-3">
                                    <label class="control-label col-sm-8">
                                        [% $user->gettext('Max. Zeichenanzahl 255 (Standard 50)') %]
                                    </label>
                                    <div class="col-sm-4">
                                        <input type="text" class="form-control" name="field[[% $FieldID  %]][max]" value="[% if $field.max > 0 && $field.max != 50 %][% $field.max %][% /if %]  " />
                                    </div>
                                </div>
                            [% /if %]
                            [% if $field.type == "text" %]
                                <div class="form-group row mb-3">
                                    <label class="control-label col-sm-8">
                                        [% $user->gettext('Wert pr&uuml;fen auf:') %]
                                    </label>
                                    <div class="col-sm-4">
                                        <select name="field[[% $FieldID  %]][eval]" class="form-control">
                                            <option value=""></option>
                                            <option value="dmY" [% if $field.eval == "dmY" %]selected="selected"[% /if %]>[% $user->gettext('Datum (d.m.Y)') %]</option>
                                            <option value="hm" [% if $field.eval == "hm" %]selected="selected"[% /if %]>[% $user->gettext('Zeit (h:m)') %]</option>
                                            <option value="dmYhm" [% if $field.eval == "dmYhm" %]selected="selected"[% /if %]>[% $user->gettext('Datum + Zeit') %]</option>
                                            <option value="Y" [% if $field.eval == "Y" %]selected="selected"[% /if %]>[% $user->gettext('Jahr') %]</option>
                                            <option value="int" [% if $field.eval == "int" %]selected="selected"[% /if %]>[% $user->gettext('Ganze Zahl') %]</option>
                                            <option value="float" [% if $field.eval == "float" %]selected="selected"[% /if %]>[% $user->gettext('Zahl') %]</option>
                                            <option value="alpha" [% if $field.eval == "alpha" %]selected="selected"[% /if %]>[% $user->gettext('Alphanumerisch') %]</option>
                                            <option value="upper" [% if $field.eval == "upper" %]selected="selected"[% /if %]>[% $user->gettext('GRO&szlig;SCHREIBUNG') %]</option>
                                            <option value="lower" [% if $field.eval == "lower" %]selected="selected"[% /if %]>[% $user->gettext('kleinschreibung') %]</option>
                                            <option value="url" [% if $field.eval == "url" %]selected="selected"[% /if %]>[% $user->gettext('Link') %]</option>
                                            <option value="mail" [% if $field.eval == "mail" %]selected="selected"[% /if %]>[% $user->gettext('e-Mail') %]</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label class="control-label col-sm-8">
                                        [% $user->gettext('Leerzeichen entfernen') %]
                                    </label>
                                    <div class="col-sm-4">
                                        <input type="checkbox" value="Y" name="field[[% $FieldID  %]][strip]" [% if $field.strip == "Y" %]checked="checked"[% /if %] />
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label class="control-label col-sm-8">
                                        [% $user->gettext('Passwortfeld') %]
                                    </label>
                                    <div class="col-sm-4">
                                        <input type="checkbox" value="Y" name="field[[% $FieldID  %]][password]" [% if $field.password == "Y" %]checked="checked"[% /if %] />
                                    </div>
                                </div>
                            [%/if%]
                            [% if $field.type == "textarea" %]
                                <div class="form-group row mb-3">
                                    <label class="control-label col-sm-8">
                                        [% $user->gettext('Anzahl der Reihen (H&ouml;he, Standard 6, max. 20)') %]
                                    </label>
                                    <div class="col-sm-4">
                                        <input type="text" class="form-control" name="field[[% $FieldID  %]][max]" value="[% if $field.max > 0 %][% $field.max %][% /if %]" />
                                    </div>
                                </div>
                            [% /if %]
                            [% if $field.type == "assets" %]
                                <div class="form-group row mb-3">
                                    <label class="control-label col-sm-8">
                                        [% $user->gettext('Assetauswahl') %]
                                    </label>
                                    <div class="col-sm-4">
                                        <label>Hier ist die Auswahl</label>
                                    </div>
                                </div>
                            [% /if %]
                            [% if $field.type == "userdata" || $field.type == "selecteduserdata" %]
                                <div class="form-group row mb-3">
                                    <label class="control-label col-sm-12">
                                        [% $user->gettext('Daten des Bearbeiters erfassen:') %]
                                    </label>
                                    <input type="hidden" name="field[[% $FieldID  %]][userid]" value="" />
                                    <div class="col-sm-4">
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][userdata][Name]" [% if $field.userdata.Name %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Name') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][userdata][username]" [% if $field.userdata.username %]checked="checked"[% /if %] value="1" /> [% $user->gettext('username') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][userdata][email]"    [% if $field.userdata.email %]checked="checked"[% /if %] value="1" /> [% $user->gettext('email') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][userdata][phone]"    [% if $field.userdata.phone %]checked="checked"[% /if %] value="1" /> [% $user->gettext('phone') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][userdata][Fax]" [% if $field.userdata.Fax %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Fax') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][userdata][Mobile]" [% if $field.userdata.Mobile %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Mobil') %]</label></div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][userdata][Street]" [% if $field.userdata.Street %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Straße') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][userdata][PLZCity]" [% if $field.userdata.PLZCity %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('PLZ / Ort') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][userdata][State]" [% if $field.userdata.State %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Bundesland') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][userdata][Country]" [% if $field.userdata.Country %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Land') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][userdata][Mandant]" [% if $field.userdata.Mandant %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Mandant') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][userdata][CostCenter]" [% if $field.userdata.CostCenter %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Kostenstelle') %]</label></div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][userdata][company]"  [% if $field.userdata.company %]checked="checked"[% /if %] value="1" /> [% $user->gettext('company') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][userdata][department]" [% if $field.userdata.department %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('department') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][userdata][Position]" [% if $field.userdata.Position %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Position') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][userdata][PersonalNumber]" [% if $field.userdata.PersonalNumber %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Personalnummer') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][userdata][Building]" [% if $field.userdata.Building %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Gebäude') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][userdata][FloorRoom]" [% if $field.userdata.FloorRoom %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Stockwerk / Raum') %]</label></div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][userdata][AdditionalInformation]" [% if $field.userdata.AdditionalInformation %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Zusätzliche Informationen') %]</label></div>
                                    </div>
                                </div>
                            [% /if %]

                            [% if $field.type == "selectedcontactdata" %]
                                <div class="form-group row mb-3">
                                    <label class="control-label col-sm-12">
                                        [% $user->gettext('Daten des Kontaktes erfassen:') %]
                                    </label>
                                    <input type="hidden" name="field[[% $FieldID  %]][contactid]" value="" />
                                    <div class="col-sm-4">
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][contactdata][Name]" [% if $field.contactdata.Name %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Name') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][contactdata][email]"    [% if $field.contactdata.email %]checked="checked"[% /if %] value="1" /> [% $user->gettext('email') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][contactdata][phone]"    [% if $field.contactdata.phone %]checked="checked"[% /if %] value="1" /> [% $user->gettext('phone') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][contactdata][Fax]" [% if $field.contactdata.Fax %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Fax') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][contactdata][Mobile]" [% if $field.contactdata.Mobile %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Mobil') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][contactdata][Mandant]" [% if $field.contactdata.Mandant %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Mandant') %]</label></div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][contactdata][Street]" [% if $field.contactdata.Street %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Straße') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][contactdata][PLZCity]" [% if $field.contactdata.PLZCity %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('PLZ / Ort') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][contactdata][State]" [% if $field.contactdata.State %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Bundesland') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][contactdata][Country]" [% if $field.contactdata.Country %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Land') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][contactdata][CostCenter]" [% if $field.contactdata.CostCenter %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Kostenstelle') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][contactdata][company]"  [% if $field.contactdata.company %]checked="checked"[% /if %] value="1" /> [% $user->gettext('company') %]</label></div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][contactdata][department]" [% if $field.contactdata.department %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('department') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][contactdata][Position]" [% if $field.contactdata.Position %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Position') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][contactdata][PersonalNumber]" [% if $field.contactdata.PersonalNumber %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Personalnummer') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][contactdata][Building]" [% if $field.contactdata.Building %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Gebäude') %]</label></div>
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][contactdata][FloorRoom]" [% if $field.contactdata.FloorRoom %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Stockwerk / Raum') %]</label></div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="row"><label><input type="checkbox" name="field[[% $FieldID  %]][contactdata][AdditionalInformation]" [% if $field.contactdata.AdditionalInformation %]checked="checked"[% /if %]  value="1" /> [% $user->gettext('Zusätzliche Informationen') %]</label></div>
                                    </div>
                                </div>
                            [% /if %]

                            [% if $field.type == "AdressSelection" || $field.type == "AdressSelectionFiltered" %]
                                <div class="form-group row mb-3 field_[% $FieldID %]">
                                    <label class="col-sm-12 control-label">[% $user->gettext('Auswahl aus HEINZELMANN-Benutzerliste ') %]</label>
                                    <div class="col-sm-12">
                                        [% if $field.type == "AdressSelectionFiltered" %]
                                            [% $user->gettext('Aus Gruppen') %]
                                            <select name="field[[% $FieldID  %]][groups][]" multiple class="form-control multiple" >

                                                [% html_options options=$groups selected=$field.groups %]
                                            </select>
                                        [% /if %]
                                    </div>
                                </div>

                            [% /if %]

                            [% if $field.type == "DataStructure" %]
                                <div class="form-group row mb-3 field_[% $FieldID %]">
                                    <label class="col-sm-12 control-label">[% $user->gettext('Auswahl aus Datenstruktur ') %]</label>
                                    <div class="col-sm-12">

                                    </div>
                                </div>

                            [% /if %]

                            [% if $field.type == "Bestellkatalog"  || $field.type  == "AssetDeskOrderCatalog" %]
                                <div class="form-group row mb-3 field_[% $FieldID %]">
                                    <label class="col-sm-12 control-label">[% $user->gettext('Bestellkatalog') %]</label>
                                    <div class="col-sm-12">

                                    </div>
                                </div>
                            [% /if %]


                            [% if $field.type == "checkbox" || $field.type == "radio" || $field.type == "select" || $field.type == "optionsWithAddress" || $field.type == "value" || $field.type == "Bestellkatalog"  || $field.type  == "AssetDeskOrderCatalog" ||  $field.type == "checklist" %]
                                <div class="form-group row mb-3">
                                    <label class="control-label col-sm-8">
                                        [% if $field.type == "checkbox" ||  $field.type == "checklist" %]
                                            [% $user->gettext('Anzahl der Checkboxen (max. 25)') %]
                                        [% /if %]
                                        [% if $field.type == "radio" %]
                                            [% $user->gettext('Anzahl der Radio Buttons (max. 25)') %]
                                        [% /if %]
                                        [% if $field.type == "select" || $field.type == "optionsWithAddress" %]
                                            [% $user->gettext('Anzahl der Werte (max.25)') %]
                                        [% /if %]
                                        [% if $field.type == "value" || $field.type == "Bestellkatalog"  || $field.type == "AssetDeskOrderCatalog" %]
                                            [% $user->gettext('Anzahl der Bereiche (max.25)') %]
                                        [% /if %]
                                    </label>
                                    <div class="col-sm-4">
                                        <input type="text" class="form-control" name="field[[% $FieldID  %]][size]" value="[% if $field.size > 0 %][% $field.size %][% /if %]" />
                                    </div>
                                </div>
                            [% /if %]
                        </div>

                        [% if $field.type == "checkbox" || $field.type == "radio" || $field.type == "select" || $field.type == "optionsWithAddress" || $field.type == "value" || $field.type == "Bestellkatalog" || $field.type  == "AssetDeskOrderCatalog" ||  $field.type == "checklist" %]
                            <div class="col-sm-12">

                                <div class="form-group row mb-3">
                                    <label class="control-label col-sm-12">
                                        [% $user->gettext('Definierte Werte') %]
                                    </label>
                                    <div class="col-sm-12">

                                        [% assign var=val value=1 %]
                                        [% foreach from=$field.ele item=ele name=elements key=FieldIndex %]
                                            <div id="Field_[% $FieldID %]Element_[% $FieldIndex %]" class="OptionField [% if $field.type == "optionsWithAddress" %]optionsWithAddress[% /if %]">

                                                <label class="control-label">[% $val %]. Option: </label>
                                                <br/>

                                                <div class="offset-xs-col-1 input-group">

                                                    [% if $field.type == "value" || $field.type == "Bestellkatalog"  || $field.type  == "AssetDeskOrderCatalog" %]
                                                        <input name="field[[% $FieldID  %]][ele][[% $FieldIndex %]][from]" value="[% if isset($ele.from) %][% $ele.from %][% /if %]" type="text" class="form-control"/>
                                                        <span class="input-group-text">[%$user->gettext('Bis')%]</span>
                                                        <input name="field[[% $FieldID  %]][ele][[% $FieldIndex %]][to]" value="[% if isset($ele.to) %][% $ele.to %][% /if %]" type="text" class="form-control" />
                                                    [% else %]
                                                        <input name="field[[% $FieldID  %]][ele][[% $FieldIndex %]]" value="[% $ele|default:"Option_$FieldIndex" %]" type="text" class="form-control" [% if $field.usedElements.$FieldIndex %]readonly="readonly"[% /if %]/>
                                                    [% /if %]
                                                    [% if $field.usedElements.$FieldIndex %]
                                                        [% foreach from=$field.usedElements.$FieldIndex item=usedInActivity %]

                                                            <a href="index.php?module=workflow&amp;event=editActivityDef&amp;aid=[% $usedInActivity.activityid %]" class="input-group-text btn btn-outline-secondary" target="_blank"><span class="fa fa-link" title="[% $user->gettext('Verwendet in') %] [% $usedInActivity.description %]"></span></a>

                                                        [% /foreach %]
                                                    [% else %]
                                                        <span class="input-group-text" role="button" onclick="removeElement('[% $FieldID %]', '[% $FieldIndex %]', '[% $SubForm|default:0 %]', '[% $SubformParent|default:"" %]', '[% $ParentElementIndex|default:"" %]');">
                                                            <span class="fa fa-trash"  title="[% $user->gettext('Element l&ouml;schen') %]"></span>
                                                        </span>
                                                    [% /if %]

                                                    [% if  !$isSubField %]
                                                        <span class="input-group-text addTranseferPanel" role="button" data-field="[% $FieldID %]" data-element="[% $FieldIndex %]" id="addBrunchFields_Field_[% $FieldID %]ele_[% $FieldIndex %]"><span class="fa fa-plus"  title="[% $user->gettext('&Uuml;bergabefeld zuf&uuml;gen') %]"></span></span>
                                                        [% /if %]
                                                </div>
                                            </div>
                                            [% if $field.type == "optionsWithAddress" %]
                                                <div class='offset-xs-col-1 AddressField optionsWithAddress'>
                                                    <label class="control-label">[% $user->gettext('Adressat(en) für diese Auswahl') %]</label>
                                                    <label class="control-label" for="field[[% $FieldID  %]][address][[% $smarty.foreach.elements.iteration-1 %]][users][]" >Benutzer</label>
                                                    <select name="field[[% $FieldID  %]][address][[% $smarty.foreach.elements.iteration-1 %]][users][]" multiple class="form-control userSelect"  style="width:70%;">

                    [%* Nur jene Benutzer in die Liste aufnehmen, die schon gewählt sind. Die Auswahl wird dynamisch durch .userSelect in view_ActivityForm.tpl und view_activityInstanceForm.tpl geladen *%]
                    [% foreach from=$users item=User key=UserID %]
                        [% if $Tools->FCS_InArray($UserID, $field.address.$FieldIndex.users ) %]
                            <option value="[% $UserID %]" selected>[% $User %]</option>
                        [% /if %]
                    [% /foreach %]
                                                        

                                                        [%* html_options options=$users selected=$field.address.$FieldIndex.users *%]
                                                    </select>
                                                    <label class="control-label" for="field[[% $FieldID  %]][address][[% $smarty.foreach.elements.iteration-1 %]][groups][]">Gruppe(n)</label>
                                                    <select name="field[[% $FieldID  %]][address][[% $smarty.foreach.elements.iteration-1 %]][groups][]" multiple="multiple" class="form-control multiple">
                                                        [% html_options options=$groups selected=$field.address.$FieldIndex.groups %]
                                                    </select>
                                                </div>
                                            [% /if %]

                                            <div id="BrunchFields_Field_[% $FieldID %]ele_[% $FieldIndex %]">
                                                [% if $SubForm != 1 && $Tools->FCS_Count($field.Subform.$FieldIndex) %]
                                                    [% include file=$modulePath|cat:"/new_workflowfield.tpl" Elements=$field.Subform.$FieldIndex SubForm="1" SubformParent=$FieldID ParentElementIndex=$FieldIndex %]
                                                [% /if %]
                                            </div>
                                            [% assign var=val value=$val+1 %]
                                        [% /foreach %]
                                    </div>
                                </div>
                            </div>
                        [% /if %]
                    </div>
                    <div class="form-group row mb-3">
                        <ul>
                            [% if $field.type == "checkbox" && $field.branch == "Y" %]
                                <li>
                                    [% $user->gettext('Bitte beachten sie, dass es keine Verzweigungsmöglichkeit für nicht geklickte Checkboxen gibt. Wenn das benötigt wird, verwenden sie bitte Radio-Buttons.') %]

                                </li>
                            [% /if %]
                            [% if ($field.type == "checkbox" || $field.type == "radio") && $Tools->FCS_Count($field.ele) < 2 &&  $field.required == "Y" %]
                                <li>
                                    [% $user->gettext('Ist ein Formularelement als Pflichtfeld definiert und enthält nur eine Checkbox, muss diese im Workflow-Verlauf immer gesetzt werden, da sich das Formular sonst nicht speichern lässt.') %]

                                </li>
                            [% /if %]

                        </ul>
                    </div>
                </div>
            </div>
        </div>
    [% /foreach %]
</div>
[% if $SubForm != 1 %]
    <div class="card panel-info shadow-sm rounded" id="NewField">
        <div class="card-header">
            <span class="fcs-card-title h4">
                [% $user->gettext('Neues Feld')%]
            </span>
        </div>
        <div class="card-body">
            <div class="form-group row mb-3">
                <label class="control-label col-sm-2">[%$user->gettext('Feldtitel')%]</label>
                <div class="col-sm-10">
                    <input pattern="[ ()a-zA-Z0-9\x7f-\xff]+" id="txtFieldName" name="field[[% $form.cntFields %]_NewField][title]" value="" type="text" class="form-control" title="[% $user->gettext('Titel darf nur Buchstaben und Zahlen enthalten.')%]" />
                    <input type="hidden" name="field[[% $form.cntFields %]_NewField][SubFormForField]" id="SubFormField" value="" />
                    <input type="hidden" name="field[[% $form.cntFields %]_NewField][SubFormForElement]" id="SubFormElement" value="" />
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="control-label col-sm-2">[% $user->gettext('Feldtyp:') %]*</label>
                <div class="col-sm-10">
                    <select name="field[[% $form.cntFields %]_NewField][type]" id="slcFieldType" class="form-control">
                        <option value="" disabled>[% $user->gettext('Feldtyp wählen') %]</option>
                        <option value="text"  title="[% $user->gettext('Einzeiliges Eingabefeld') %]">[% $user->gettext('Textfeld') %]</option>
                        <option value="textarea"  title="[% $user->gettext('Mehrzeiliges Eingabefeld') %]">[% $user->gettext('Textbereich') %]</option>
                        <option value="checkbox" title="[% $user->gettext('Zeigt die definierten Werte zum abhaken an') %]">[% $user->gettext('Checkbox') %]</option>
                        <option value="radio" title="[% $user->gettext('Zeigt die definierten Werte zur Auswahl an. Es kann nur einer der Werte gewählt werden.') %]">[% $user->gettext('Radio Button') %]</option>
                        <option value="select" title="[% $user->gettext('Ein Wert aus einer vordefinierten Liste kann gewählt werden') %]">[% $user->gettext('Auswahlliste') %]</option>
                        <option value="value" title="[% $user->gettext('Es können mehrere Werte von ... bis ... definiert werden. Im Formular ist dann einer dieser Wertebereiche wählbar.') %]">[% $user->gettext('Wertebereich') %]</option>
                        <option value="date" title="[% $user->gettext('Eingabefeld mit Datumsauswahl') %]">[% $user->gettext('Datum') %]</option>
                        <option value="assets" title="[% $user->gettext('Assetfeld') %]">[% $user->gettext('Asset') %]</option>
                        <option value="datetime" title="[% $user->gettext('Eingabefeld mit Datum- und Zeitauswahl') %]">[% $user->gettext('Datum und Zeit') %]</option>
                        <option value="integer" title="[% $user->gettext('Eingabefeld für ganzen Zahlen von 0 bis 10000') %]">[% $user->gettext('Integer 0 - 10000') %]</option>
                        <option value="notice" title="[% $user->gettext('Der definierte Text wird im Formular angezeigt. Es ist keine Eingabe möglich.') %]">[% $user->gettext('Notiz') %]</option>
                        <option value="seperator" title="[% $user->gettext('Fügt dem Formular eine Trennlinie zu') %]">[% $user->gettext('Trenner') %]</option>
                        <option value="userdata" title="[% $user->gettext('Benutzerdaten des Bearbeiters werden gespeichert und angezeigt') %]">[% $user->gettext('Benutzerdaten') %]</option>
                        <option value="selecteduserdata" title="[% $user->gettext('Benutzerdaten eines ausgewählten Benutzer werden gespeichert und angezeigt') %]">[% $user->gettext('Benutzerdaten (mit Auswahlliste)') %]</option>
                        <option value="selectedcontactdata" title="[% $user->gettext('Kontaktdaten eines ausgewählten Kontaktes werden gespeichert und angezeigt') %]">[% $user->gettext('Kontaktdaten (mit Auswahlliste)') %]</option>
                        <option value="optionsWithAddress" title="[% $user->gettext('Durch dieses Formularelement können Sie die Adressaten von nachfolgenden Aktivitäten abhängig von der gewählten Option definieren') %]">[% $user->gettext('Auswahl mit Adressierung') %]</option>
                        <option value="AdressSelection" title="[% $user->gettext('Durch dieses Formularelement können Sie die Adressaten von nachfolgenden Aktivitäten aus der Heinzelmann-Benutzerliste wählen') %]">[% $user->gettext('Adressat zuweisen') %]</option>

                        <option value="AdressSelectionFiltered" title="[% $user->gettext('Analog zu Adressat zuweisen, jedoch können Gruppen zur Filterung der Benutzer definiert werden') %]">[% $user->gettext('Adressat zuweisen') %] [% $user->gettext('(gefiltert)') %]</option>

                        [% if $withDataStructure %]
                            <option value="DataStructure" title="[% $user->gettext('Durch dieses Formularelement können Sie die Adressaten von nachfolgenden Aktivitäten aus Ihrer Datenstruktur wählen') %]">[% $user->gettext('Auswahl aus Datenstruktur') %]</option>
                        [% /if %]
                        [% if $withBestellkatalog && $withOrderCatalogLicence %]
                            <option value="Bestellkatalog" title="[% $user->gettext('Durch dieses Formularfeld können Bestellungen mit importierten Artikeln durchgeführt werden') %]">[% $user->gettext('Bestellkatalog') %]</option>
                        [% /if %]
                        [% if $withAssetDeskOrderCatalog  && $withOrderCatalogLicence %]
                            <option value="AssetDeskOrderCatalog" title="[% $user->gettext('Durch dieses Formularfeld können Bestellungen mit Artikeln aus AssetDesk durchgeführt werden') %]">[% $user->gettext('Bestellkatalog') %] (Asset.Desk)</option>
                        [% /if %]
                        <option value="checklist" title="[% $user->gettext('Ist dies ein Pflichtfeld, müssen alle Checkboxen angehakt sein.') %]">[% $user->gettext('Checkliste') %]</option>
                    </select>
                    <input type="hidden" name="field[[% $form.cntFields %]_NewField][new]" value="Y" />
                </div>
            </div>

        </div>
    </div>

    <div class="card panel-info shadow-sm rounded" id="NewContainer">
        <div class="card-header">
            <span class="fcs-card-title h4">
                [% $user->gettext('Neuer Container')%]
            </span>
        </div>
        <div class="card-body">
            <div class="form-group row mb-3">
                <label class="control-label col-sm-2">[%$user->gettext('Containername')%]</label>
                <div class="col-sm-10">
                    <input id="txtContainerName" name="container[[% $form.cntContainer %]_NewContainer][title]" value="" type="text" class="form-control" title="[% $user->gettext('Anzeigename des Containers')%]" />
                </div>
            </div>
        </div>
    </div>
[% /if %]
<script>
    var order = [];



    $("#WFFieldList").sortable(
            {
                connectWith: ".connectedRow",
                handle: ".sortableHandle",
                update: function ()
                {
                    $("#WFFieldList").sortable('refreshPositions').children().each(function ()
                    {
                        var currentElement = $(this);
                        // Show element
                        var ElementID = currentElement.attr('id');
                        var id = ElementID.split('_')[1];
                        order.push(id);
                    });
                    $.post('index.php?module=workflow&event=resortJSON', {order: JSON.stringify(order), id: "[% $form.formid %]"}, function (response)
                    {
                        order = [];
                    });
                }
            });

</script>




