
<script src="includes/js/dropzone.js"></script>
<link href="includes/js/dropzone.css" rel="stylesheet" type="text/css" />

<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

<style>
    .diffCol {
        color:  green;
    }    
    .importError {
        color:red;
    }
    .importSuccess{
        color:green;
    }
</style>
<div class="panel panel-fcs-border">
    <div class="panel-heading">
        <span class="fcs-card-title h2">[% $user->gettext('Kostenartikel') %]</span>
    </div>
    <div class="panel-body">

        <div class="panel panel-fcs-content">
            <div class="panel-heading">
                <span class="fcs-card-title h3">[% $user->gettext('CSV Import') %]

                    <div class="pull-right">
                        <a href="index.php?module=wprequest&class=wage" class='btn btn-outline-secondary'>[% $user->gettext('Liste') %]</a>

                        <a href="index.php?module=wprequest&class=wage&event=clearCSVImport" class="btn btn-outline-primary">[% $user->gettext('Liste leeren') %]</a>                        

                        <a href="index.php?module=wprequest&class=wage&event=getCSVHeaders" class="btn btn-outline-primary">[% $user->gettext('CSV-Vorlage herunterladen') %]</a>
                    </div>
            </div>
            <div class="panel-body">

                <div class="panel panel-fcs-content">
                    <div class="panel-body">
                        <form action="index.php?module=wprequest&class=wage&event=CSVImport" method="post" id="CSVImportForm" class="form form-horizontal center-block">

                            <span class="pull-right">
                                <label><input type="number" class="form-control" id="StepWide" value="10" width="2"> [% $user->gettext('Artikel auf einmal importieren') %]</label>
                            </span>


                            [% if $cntEntries %]


                                <p>[% $user->gettext('Es wurden') %] [% $cntEntries %] [% $user->gettext('Einträge zum importieren gefunden. Sollen diese Artikel angelegt / aktualisiert werden?') %]</p>
                                <input type="hidden" name="importData" value="1">
                                <span id="startImport" class="btn btn-outline-secondary">[% $user->gettext('Ja') %]</span>

                                <table id="ResultTable"  class="table table-bordered table-striped table-sm hidden">
                                    <thead>
                                        <tr>
                                            <th>
                                                [% $user->gettext('Artikel') %]
                                            </th>
                                            <th>
                                                [% $user->gettext('Messages') %]
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>



                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped table-sm">
                                        <thead>
                                            <tr>
                                                <th>
                                                    <input type="checkbox" id="SelectAll" />
                                                </th>
                                                [% foreach from=$Headers item=Col %]                                                    
                                                    <th>
                                                        [% $Col %]
                                                    </th>
                                                [% /foreach %]
                                            </tr>
                                        </thead>
                                        <tbody>

                                            [% foreach from=$CSVData item=Object key=csvKey %]
                                                <tr id="CSVColNo_[% $csvKey %]" class="[% if $Compare.$csvKey.exist %]exist [% if $Compare.$csvKey.update %]hasUpdate[% else %]noChanges hidden [% /if %][% else %] notExist[% /if %]">
                                                    <td>
                                                        [% if !$Compare.$csvKey.exist || $Compare.$csvKey.update  %]
                                                            <input type="checkbox" class="AssetSelection" id="AssetSelection_[% $csvKey %]" name="selectedAssets[[% $csvKey %]]" value="[% $csvKey %]" class="form-control" />
                                                        [% /if %]
                                                    </td>

                                                    [% foreach from=$Object item=val key=ColName %]
                                                        <td>
                                                            [% $val %]
                                                        </td>
                                                    [% /foreach %]
                                                </tr>
                                            [% /foreach %]
                                        </tbody>
                                    </table>
                                </div>

                            [% else %]
                                <p>
                                    <strong>[% $user->gettext('CSV-Datei per Drag and Drop reinziehen') %]</strong>
                                </p>
                            [% /if %]
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<script>

    $(document).ready(function () {

        $('#SelectAll').on("click", function () {
            if ($('#SelectAll').prop('checked')) {
                $('.AssetSelection:visible').prop('checked', true);
            } else {
                $('.AssetSelection:visible').prop('checked', false);
            }
        })
        $("#hasUpdate").on("click", function () {
            $('.hasUpdate').toggleClass('hidden');
        })

        $("#notExist").on("click", function () {
            $('.notExist').toggleClass('hidden');
        })

        $("#noChanges").on("click", function () {
            $('.noChanges').toggleClass('hidden');
        })


        $('#startImport').on("click", function (e) {
            importFirstSelectedDevice();
        })

        /**
         * Comment
         */
        function importFirstSelectedDevice() {

            CSVColNo = $(".AssetSelection:checkbox:checked:first").val();
            if (typeof CSVColNo === "undefined") {
                return;
            }

//            console.log("Nächste: ");
//            console.log("ColNo: " + CSVColNo);

            var selected = [];
            ii = 0;
            $('.AssetSelection:checkbox:checked').each(function () {
                selected.push($(this).val());
                ii++;
                if (ii == $('#StepWide').val()) {
                    return false;
                }

            });
//             console.log("selected: " + selected);


            $.post("index.php?module=wprequest&class=wage&event=startCSVImport&CSVColNo=" + CSVColNo, {selected: selected}, function (data) {
//                 console.log(data);

            }).done(function (data) {


                $.each(data, function (key, val) {
                    $('#ResultTable').removeClass('hidden');

                    markup = "<tr id='Result_" + key + "' class=' " + (val.error ? 'importError' : 'importSuccess') + "' ><td>" + val.DeviceData.DealerID + " / " + val.DeviceData.Description + "</td><td>";
                    $.each(val.messages, function (i, item) {
                        markup += item + "<br/>";
                    })
                    markup += "</td></tr>";
                    $('#ResultTable > tbody').append(markup);

                    if (val.error) {
                        $("#CSVColNo_" + key).addClass('importError');
                        //Wenn es einen Fehler gab, die Markierung entfernen.
                        $('#AssetSelection_' + key).prop('checked', false);
                    } else {
                        $("#CSVColNo_" + key).remove();
                    }

                    $("#Result_" + key).show();
                });

                importFirstSelectedDevice();
            });

        }

        Dropzone.options.myDropzone = {

            init: function () {

                this.on("queuecomplete", function (file) {
                    //this.removeAllFiles();
                });
            }
        };

    $(".panel-fcs-content").dropzone({
            url: "index.php?module=wprequest&class=wage&event=getCSVFile",
            init: function () {
                this.on("queuecomplete", function (file) {
                    //this.removeAllFiles();
                    location.reload();
                });
            }
        });
    })
</script>
