<style>

    .table tr th{
        cursor: pointer;
    }
</style>

<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

<div class="panel panel-fcs-border">
    <div class="panel-heading">
        <span class="fcs-panel-title h2">[% $user->gettext('RMA Liste') %]</span>
    </div>
    <div class="panel-body">

        <div class="panel panel-fcs-content">
            <div class="panel-heading">
                <span class="fcs-panel-title h3">[% $user->gettext('RMA Positionen') %]</span>

                <div class="pull-right">
                    <a href="index.php?module=wprequest&class=rmalist&event=reloadeRmasFromProalpha" class="btn btn-default"><span class="fa fa-plus"></span> [% $user->gettext('RMA-Daten von proAlpha abrufen') %]</a>
                    <button id="getRueLi" class="btn btn-default disabled"><span class="fa fa-list"></span> [% $user->gettext('Rücklieferliste') %]</button>
                    
                </div>

            </div>
            <div class="panel-body">


                <div class="panel panel-fcs-content">
                    <div class="panel-body">
                            <label for="HaendlerID" class="col-lg-1 control-label">[% $user->gettext('HändlerID') %]</label>
                            <div class="col-lg-5">
                                [% if $user->getPaKDNRs() > 1 %]                                            
                                    <select id="HaendlerID" name="HaendlerID" class="form-control" data-width="100%">
                                        [% foreach from=$user->getPaKDNRs() item=group key=kdnr %]
                                            <option value="[% $kdnr %]" >[% $group %]</option>
                                        [% /foreach %]
                                    </select>
                                [% else %]
                                    <input type="number" class="form-control"  id="HaendlerID" name="HaendlerID"  value="" />
                                [% /if %]                                                                
                            </div>
                        </div>
                    </div>

                

                        <div class="table-responsive">
                            <form action="index.php?module=wprequest&class=rmalist&event=rueli" method="post" id="RueLiForm">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>&nbsp;</th>
                                        <th>[% $user->gettext('Antragsnummer / CallID') %]</th>
                                        <th>[% $user->gettext('RMA-Beleg-Nummer') %]</th>
                                        <th>[% $user->gettext('Händler') %]</th>
                                        <th>[% $user->gettext('Niederlassung') %]</th>
                                        <th>[% $user->gettext('Teilenummer') %]</th>
                                        <th>[% $user->gettext('Teilebezeichnung') %]</th>
                                        <th>[% $user->gettext('Rückliefercode') %]</th>
                                        <th>[% $user->gettext('Rücklieferstatus') %]</th>
                                        <th>[% $user->gettext('geforderte Menge') %]</th>
                                        <th>[% $user->gettext('zurückgelieferte Menge') %]</th>
                                        <th>[% $user->gettext('Kommentar') %]</th>
                                        <th>[% $user->gettext('Aktionen') %]</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    [% foreach from=$Positions item=Position %]
                                        <tr>
                                            <td><input type="checkbox" name="RMAPositionIDs[]" value="[% $Position.RMAPositionID %]" id="selectedPosition_[% $Position.RMAPositionID %]" class="selectedPositions"/></td>
                                            <td>[% $Position.paCallID %]</td>
                                            <td>[% $Position.RMABelegNr %]_[% $Position.RMABelegPos %]</td>
                                            <td>[% $Position.HaendlerID %]</td>
                                            <td>[% $Position.EndKundeID %]</td>
                                            <td>[% $Position.ETNummer %]</td>
                                            <td>[% $Position.ETBezeichnungDE %]</td>
                                            <td>[% $Position.Rueckliefercode %]</td>
                                            <td>[% $Position.Ruecklieferstatus %]</td>
                                            <td>[% $Position.RMABelegMenge %]</td>
                                            <td id="amountRow_[% $Position.RMAPositionID %]" data-oldamount="[% $Position.zurueckgelMenge %]">[% $Position.zurueckgelMenge %]</td>
                                            <td id="commentRow_[% $Position.RMAPositionID %]" data-oldcomment="[% $Position.Kommentar %]" >[% $Position.Kommentar %]</td>

                                            
                                            <td>
                                                <span id="listMode_[% $Position.RMAPositionID %]">
                                                    [% if $Position.Ruecklieferstatus == 300 %]
                                                    <span id="setDelivered_[% $Position.RMAPositionID %]" data-rmapositionid="[% $Position.RMAPositionID %]" class="setDelivered btn btn-sm btn-default" ><span class="fa fa-calendar" aria-hidden="true" title="[% $user->gettext('Als geliefert markieren') %]"></span></span>
                                                    [% /if %]
                                                    <span id="editPosition_[% $Position.RMAPositionID %]" data-rmapositionid="[% $Position.RMAPositionID %]" class="editPosition btn btn-sm btn-default" ><span class="fa fa-pencil" aria-hidden="true" title="[% $user->gettext('Eingang der Waren bestätigt') %]"></span></span>
                                                </span>
                                                <span id="editMode_[% $Position.RMAPositionID %]" style="display:none">
                                                    <span class="saveEdit btn btn-sm btn-default" data-rmapositionid="[% $Position.RMAPositionID %]"><span class="fa fa-check" aria-hidden="true" title="[% $user->gettext('Daten speichern') %]"></span></span>
                                                    <span class="cancelEdit btn btn-sm btn-default" data-rmapositionid="[% $Position.RMAPositionID %]"><span class="fa fa-remove" aria-hidden="true" title="[% $user->gettext('Abbrechen') %]"></span></span>
                                                </span>
                                            </td>
                                        </tr>
                                    [% /foreach %]
                                </tbody>
                                
                            </table>
                            </form>
                </div>
            </div>
        </div>
    </div>
</div>



<script>




    $('.editPosition').on('click', function (e) {
        RMAPositionID = $(this).data('rmapositionid');

        amountForm = '<input type="number" name="Position[zurueckgelMenge]" id="PositionAmount_' + RMAPositionID + '" value="' + $('#amountRow_' + RMAPositionID).html() + '"/>';
        CommentForm = '<input type="text" name="Position[Kommentar]" id="PositionComment_' + RMAPositionID + '" value="' + $('#commentRow_' + RMAPositionID).html() + '"/>';
        $('#amountRow_'+RMAPositionID).html(amountForm);
        $('#commentRow_'+RMAPositionID).html(CommentForm);
        $('#editMode_'+RMAPositionID).show();
        $('#listMode_'+RMAPositionID).hide();
    })

    $('.saveEdit').on('click', function (e){
        RMAPositionID = $(this).data('rmapositionid');
        zurueckgelMenge = $('#PositionAmount_' + RMAPositionID).val();
        Kommentar = $('#PositionComment_' + RMAPositionID).val();

        $.post( "index.php?module=wprequest&class=rmalist&event=editPosition", { RMAPositionID: RMAPositionID, save: 1, zurueckgelMenge:zurueckgelMenge, Kommentar:Kommentar , ajax:1 })
        .done(function (data) {
            noty({
                text: data.messages,
                type: data.error ? 'error' : 'success',
                timeout: notifyTimeout
            });
            if(data.error){

            } else {
                $('#amountRow_'+RMAPositionID).html(data.Data.zurueckgelMenge);
                $('#commentRow_'+RMAPositionID).html(data.Data.Kommentar);
                $('#editMode_'+RMAPositionID).hide();
                $('#listMode_'+RMAPositionID).show();
            }
          });
    })

    
    $('.setDelivered').on('click', function (e){
        RMAPositionID = $(this).data('rmapositionid');

        $.post( "index.php?module=wprequest&class=rmalist&event=setDelivered", { RMAPositionID: RMAPositionID })
        .done(function (data) {
            noty({
                text: data.messages,
                type: data.error ? 'error' : 'success',
                timeout: notifyTimeout
            });
          });
    })

    $('.cancelEdit').on('click', function (e){
        RMAPositionID = $(this).data('rmapositionid');
        $('#amountRow_'+RMAPositionID).html($('#amountRow_'+RMAPositionID).data('oldamount'));
        $('#commentRow_'+RMAPositionID).html($('#commentRow_'+RMAPositionID).data('oldcomment'));
        $('#editMode_'+RMAPositionID).hide();
        $('#listMode_'+RMAPositionID).show();
    })

    $('#getRueLi').on('click', function (e) {
        // $.get( "index.php?module=wprequest&class=rmalist&event=rueli", { RMAPositionIDs: $('.selectedPositions:checked').map(function(){return this.value}).get() } );
    $('#RueLiForm').submit();

    })

    $('.selectedPositions').on('click', function (e) {
        if($('.selectedPositions:checked').length ){
            $('#getRueLi').removeClass('disabled');
        } else {
            $('#getRueLi').addClass('disabled');
        }
    })


    $(document).ready(function () {
        $('.table').DataTable({
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "aaSorting": [[1, "asc"]],
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                }                
            }
        });
    })

</script>
