<script>
    function switchPage(page) {
        document.getElementById('pos').value = page;
        submitForm();
    }
</script>

<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <div class="row">
            <div class="col-sm-6">
                <span class="fcs-card-title h2">[% $user->gettext('Garantieabwicklungsarten') %]</span>
            </div>
            <div class="col-sm-6 text-end">
                <div class="btn-group">
                    <input type="button" onclick="window.location.href = 'index.php?module=wprequest&event=ShowAddWPType';" value="[% $user->gettext('Neue Garantieabwicklungsart') %]" class="btn btn-outline-primary" />
                </div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <form action="" method="post" name="hm" onsubmit="return false;" id="hm" class="form-horizontal form-label-left">

            <input type="hidden" name="pos" id="pos" value="[% $pos %]" />
            <input type="hidden" name="sort" id="sort" value="[% $sort %]" />
            <input type="hidden" name="sortorder" id="sortorder" value="[% $sortorder %]" />


            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <h3 class="card-title">[% $entries %] [% $user->gettext('Einträge') %]</h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover" id="WarrantyProcessingTypeTable" >
                            <thead>
                                <tr>
                                    <th>
                                        [% $user->gettext('Name') %]
                                    </th>
                                    <th>
                                        [% $user->gettext('Status') %]
                                    </th>
                                    <th>
                                        [% $user->gettext('Erstellt am') %]
                                    </th>
                                    <th>[% $user->gettext('Aktion') %]</th>
                                </tr>
                            </thead>
                            <tbody>
                                [% foreach from=$WarrantyProcessingTypeList item=WarrantyProcessingType %]
                                    <tr>
                                        <td>[% $WarrantyProcessingType.name %]&nbsp;</td>
                                        <td>[% if $WarrantyProcessingType.isactive == 1 %] [% $user->gettext('Aktiv') %] [% else %] [% $user->gettext('Deaktiviert') %] [% /if %]</td>
                                        <td>[% $WarrantyProcessingType.createdate|date_format:"%d.%m.%Y %H:%M" %]&nbsp;</td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="index.php?module=wprequest&event=ShowEditWPType&warrantyprocessingrequesttypeid=[% $WarrantyProcessingType.warrantyprocessingrequesttypeid %]" title="[% $user->gettext('Bearbeiten') %]" class="btn btn-outline-secondary"><span class="fa fa-pencil"></span></a>
                                                [% if $WarrantyProcessingType.candelete == 1 %]
                                                <a href="javascript:check('[% $WarrantyProcessingType.name %]', 'index.php?module=wprequest&event=DeleteWPType&warrantyprocessingrequesttypeid=[% $WarrantyProcessingType.warrantyprocessingrequesttypeid %]')" title="[% $user->gettext('Löschen') %]" class="btn btn-outline-secondary"><span class="fa fa-times"></span></a>
                                                [% /if %]
                                            </div>
                                        </td>
                                    </tr>
                                [% foreachelse %]
                                    <tr class="even">
                                        <td colspan="8">[% $user->gettext('Es wurden keine Garantieabwicklungsarten gefunden') %]</td>
                                    </tr>
                                [% /foreach %]

                            </tbody>

                            <tfoot>
                                <tr>
                                    <td colspan="4">
                                        [% $Paging %]
                                    </td>
                                </tr>
                            </tfoot>

                        </table>
                    </div>
                </div>
            </div>
    </div>
</div>

</form>
<script>
    function check(Name, url) {
        bootbox.confirm('[% $user->gettext('Garantieabwicklungsart') %] <strong>' + Name + '</strong> [% $user->gettext('wirklich löschen?') %]', function (result) {
            if (result) {
                window.location.href = url;
            }
        })
    }
</script>
