<!DOCTYPE html>
<html lang="de">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <!-- Meta, title, CSS, favicons, etc. -->
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <!-- Bootstrap -->
        <link href="styles/bootstrap/css/bootstrap.min.css" rel="stylesheet">
        <link href="styles/bootstrap/heinzelmann.css" rel="stylesheet">


        <!-- jQuery -->
        <script src="includes/vendors/jquery/dist/jquery.min.js"></script>
        <script src="styles/bootstrap/popper.js"></script>
        <script src="styles/bootstrap/js/bootstrap.min.js"></script>
        <script src="styles/bootstrap/heinzelmann.js"></script>
        
        <script src="includes/js/ajax.js"></script>
        <script type="text/javascript" src="includes/js/jquery-ui.min.js"></script>
        <!-- iCheck -->
        
        <!-- Datatables -->
        <link href="includes/vendors/datatables.net-bs/css/dataTables.bootstrap.min.css" rel="stylesheet">
        <link href="includes/vendors/datatables.net-buttons-bs/css/buttons.bootstrap.min.css" rel="stylesheet">
        <link href="includes/vendors/datatables.net-fixedheader-bs/css/fixedHeader.bootstrap.min.css" rel="stylesheet">
        <link href="includes/vendors/datatables.net-responsive-bs/css/responsive.bootstrap.min.css" rel="stylesheet">
        <link href="includes/vendors/datatables.net-scroller-bs/css/scroller.bootstrap.min.css" rel="stylesheet">

        <!-- Custom Theme Style -->
        <link href="build/css/___custom.css" rel="stylesheet">

            [% foreach from=$originPathStyles item=style %]<link rel="stylesheet" type="text/css" href="[% $style %]" media="screen" />[% /foreach %]
            [% foreach from=$styles item=style %]<link rel="stylesheet" type="text/css" href="[% $style %]" media="screen" />[% /foreach %]
            [% foreach from=$printstyles item=style %]<link rel="stylesheet" type="text/css" href="[% $style %]" media="print" />[% /foreach %]        

        <title>[% if $smarty.const.TITLETEXT != '' %][% $smarty.const.TITLETEXT %][% else %]Helpdesk[% /if %] [% $PageTitle %]</title>
        <link rel="SHORTCUT ICON" href="[% if $smarty.const.TITLEICON != '' %][% $smarty.const.TITLEICON %][% else %]images/favicon.ico[% /if %]" />

        <script type="text/javascript">
            var ts_lang = '[% $user->language_type %]';
        </script>
        [% foreach from=$javascript item=js %]<script type="text/javascript" src="[% $js %]"></script>[% /foreach %]

    </head>

    [% if 'login' == $module || $pwdrecover %]  

        [% $content %]

    [% else %]

        <body class="nav-md">
            <div class="nav_menu">
                <nav class="navbar navbar-default">
                    <div class="container-fluid">



                        <div class="navbar-header">
                            <a href="index.php" class="navbar-brand">
                                [% if $smarty.const.LOGO != '' && $smarty.const.LOGO != 'LOGO' %]
                                    <img src="[% $smarty.const.LOGO %]" title="[% $user->Security->Company %]" alt="[% $user->Security->Company %]" />
                                [% else %]
                                    <img src="styles/[% $CSSTEMPLATE %]/images/logo.gif" title="[% $user->Security->Company %]" alt="[% $user->Security->Company %]" />
                                [% /if %]
                            </a>   
                        </div>
                        <ul class="nav navbar-nav">       

                            [% $user->getMenu() %]

                        </ul>

                        [% if $user->Username %]                                                                  
                            <ul class="nav navbar-nav navbar-right">
                                <li class="">
                                    <form action="index.php?module=ticket&amp;event=search"  method="get" class="navbar-form navbar-right">
                                        <input type="hidden" name="module" value="ticket" />
                                        <input type="hidden" name="event" value="search" />

                                        <input type="text" name="id" class="form-control" maxlength="100" autocomplete="off" title="[% $user->gettext('Suche nach TicketID �ffnet das Ticket, wenn dieses sichtbar ist.') %]" placeholder="[% $user->gettext('Suche') %]" />
                                    </form>                                        
                                </li>   

                                <li class="">
                                    <a href="javascript:;" class="user-profile dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                                        <img src="images/img.jpg" alt=""> [% $user->Username %] ([% $user->FullName %])
                                        <span class=" fa fa-angle-down"></span>
                                    </a>
                                    <ul class="dropdown-menu dropdown-usermenu pull-right">
                                        <li><a href="javascript:;"> Profile</a></li>
                                        <li>
                                            <a href="javascript:;">
                                                <span class="badge bg-red pull-right">50%</span>
                                                <span>Settings</span>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="index.php?module=login&amp;event=logout"><i class="fa fa-sign-out pull-right"></i>[% $user->gettext('Abmelden') %]</a>
                                        </li>
                                    </ul>
                                </li>

                                <li role="presentation" class="dropdown">
                                    <a href="javascript:;" class="dropdown-toggle info-number" data-toggle="dropdown" aria-expanded="false">
                                        <i class="fa fa-envelope-o"></i>
                                        <span class="badge bg-green">[% if $Tools->FCS_Count($messages) %][% $Tools->FCS_Count($messages) %][% /if %]</span>
                                    </a>
                                    <ul id="menu1" class="dropdown-menu list-unstyled msg_list" role="menu">
                                        [% foreach from=$messages item=message %]
                                            <li>
                                                <a>
                                                    <span class="image"><img src="images/img.jpg" alt="Profile Image"></span>
                                                    <span>
                                                        <span>John Smith</span>
                                                        <span class="time">3 mins ago</span>
                                                    </span>
                                                    <span class="message">
                                                        [% $message.text %]
                                                    </span>
                                                </a>
                                            </li>            
                                        [% /foreach %]                                                               
                                    </ul>



                                [% /if %] 
                            <li>
                                [% if 'login' == $module || $pwdrecover %]        

                                    [% if $VisibleNewsArticle || $VisibleKBArticle || $Tools->FCS_Count($LinkList) || $pwdrecover %]
                                        <form class="navbar-form navbar-left" role="search">
                                            <div class="form-group">
                                                <input type="text" id="lx_small_username" value="[% $Username %]" name="lx_username" class="textbox [% if $errorno == 1 %]error[% /if %]" placeholder="[% $user->gettext('Benutzername') %]" size="25" maxlength="255" autocomplete="off" />

                                                <input type="password" name="lx_password" value="[% $Password %]" class="textbox [% if $errorno == 2 %]error[% /if %]" placeholder="[% $user->gettext('Passwort') %]" size="25" maxlength="50" autocomplete="off" />                                                            
                                                [% if $showDomains && $Tools->FCS_Count($domains) %]

                                                    <select size="1" name="lx_domain" class="textbox">
                                                        [% html_options options=$domains %]
                                                        <option value="">[% $user->gettext('&gt;&gt; ohne Domain &lt;&lt;') %]</option>
                                                    </select>
                                                [% /if %]

                                                <input type="submit" class="button button-green small" style="height: 1.8em;padding: 1px;" value="Login" />
                                                [% if $errorno == 2 || $errorno == 1 %]
                                                    <span class="error"> [% $error %] </span>
                                                [% /if %]    
                                            </div>
                                            <div class="form-group">
                                                [% if $remember_me == 1 %]

                                                    <label>[% $user->gettext('Anmeldung merken') %]:

                                                        <input type="checkbox" name="lx_rememberme" class="checkbox" value="1" /></label>
                                                    [% /if %]

                                                [% if $MailActive && $PwdRecover %]

                                                    &nbsp;&nbsp;&nbsp;<input type="button" class="button button-green small" style="height: 1.8em;padding: 1px;" onclick="window.location.href = 'index.php?module=login&event=pwdrecover';" value="[% $user->gettext('Passwort vergessen ?') %]" />
                                                [% /if %]
                                                [% if $UserCreate && $MailActive %]

                                                    &nbsp;&nbsp;&nbsp;<input type="button" class="button button-green small" style="height: 1.8em;padding: 1px;" onclick="window.location.href = 'index.php?module=login&event=createuser';" value="[% $user->gettext('Registrieren') %]" />
                                                [% /if %]      
                                            </div>
                                            <button type="submit" class="btn btn-outline-secondary">Submit</button>
                                        </form>     
                                    [% else %]
                                        <a href="index.php">[% $user->gettext('Anmelden') %]</a>                                    
                                    [% /if %]

                                [% else %]


                                </li>

                                [% if $ShowMessages %]
                                    &nbsp;&#124;&nbsp;
                                    <a href="#" class="MessageDialog" id="Messages">[% $user->gettext('Nachrichten') %] (<span id="MessageCount"></span>) <span id="NewMessages"></span></a>
                                    <span id="MessageBox" ></span>
                                [% /if %]

                            [% /if %]
                            </li>        
                        </ul>
                        </li>
                        </ul>
                    </div>
                </nav>
            </div>


            [% if $user->UserID %]
                <!-- small header -->

            [% /if %]                        
        </div>
        <!-- ###MENU### end -->

        [% if ($user->LicenceExpired || $user->LicenceExceed) && $user->inGroup(1) %]
            <div class="expired">
                [% if $user->LicenceExpired %]

                    [% if $user->NoVersionLicence %]
                        [% $user->gettext('Ihre Lizenz ist nicht f�r die HEINZELMANN Version g�ltig. Bitte wenden Sie sich an den Vertrieb...') %]
                    [% else %]
                        [% $user->gettext('Ihre Lizenz ist abgelaufen. Bitte wenden Sie sich an den Vertrieb...') %]
                    [% /if %]

                [% else %]

                    [% $user->gettext('Es k&ouml;nnen maximal ') %]
                    [% $user->licavai %]
                    [% $user->gettext(' Benutzer Tickets bearbeiten.<br />Sie haben das Recht aber ') %]
                    [% $user->licused %]
                    [% $user->gettext(' Benutzern gegeben.') %]

                [% /if %]
            </div>
        [% /if %]

        <div class="container body">
            <div class="main_container">
                <div class="col-md-12 ">
                    <div class="left_col scroll-view">
                        [% $content %]

                    </div>
                </div>

                <div class="clearfix"></div>
                <!-- footer content -->
                <footer class="footer_fixed">
                    <div class="pull-left">                
                        &copy; [% $smarty.now|date_format:"%Y" %] FCS Fair Computer Systems GmbH              
                    </div>                    
                    <div class="pull-right">
                        Version: [% $user->Version->RELEASE %] &#124; [% if $user->Security->Company %][% 'Lizenziert f&uuml;r:' %] [% $user->Security->Company %][% /if %]
                    </div>

                    <div class="clearfix"></div>
                </footer>
                <!-- /footer content -->
            </div>  
        </div>         

        <!-- Bootstrap -->
        <script src="includes/vendors/bootstrap/dist/js/bootstrap.min.js"></script>

        <script type="text/javascript" src="includes/js/jquery.multiselect.js"></script>
        <!-- Custom Theme Scripts -->
        <script src="build/js/custom.js"></script>     

        [% foreach from=$postBodyJS item=js %]<script type="text/javascript" src="[% $js %]"></script>[% /foreach %]         
    </body>

[% /if %]   
</html>                        
