
var fields = new Array();
var valid_form = true;

function field(type, name, required, evaluate)
{
    this.obj = document.getElementById("field_" + name);
    this.err = document.getElementById("field_error_" + name);
    this.type = type
    this.name = name;
    this.required = (required == "Y") ? true : false;
    this.evaluate = evaluate;

    this.errormessage = "";
    this.errorcode = 0
    this.hasError = hasError;
}

function hasError()
{
    return (this.errorcode > 0) ? true : false;
}

function trim(str)
{
    str = str.replace(/^\s+/, '');
    for (var i = str.length - 1; i >= 0; i--) {
        if (/\S/.test(str.charAt(i))) {
            str = str.substring(0, i + 1);
            break;
        }
    }
    return str;
}

function validateForm()
{	
    console.log("WF-validateForm public ");
//# sourceURL=validation_forms.js;        
    var error = false;
    for (i = 0; i < fields.length; i++) {


        //Prüfen, ob es das Feld gibt:
        if (fields[i] == undefined) {
            //console.log('JETZT!!');              
            continue;
        }

        if (fields[i].type == 'checklist' && $('.checklist_required_' + fields[i].name).is(':visible')) {
            //checklisten nicht überspringen
        } else {        
            //es werden auch übergabefelder geprüft. Diese sollen nur geprüft werden, wenn sie sichtbar sind:
            if(!$("[name^='"+fields[i].name+"']").is(':visible')){
            //if (!$("#field_" + fields[i].name +"/" ).is(':visible')) {
                console.log("Das Feld "+fields[i].name+" wird nicht angezeigt und nicht geprüft")
                continue;
            }
        }

        var field = fields[i];

        //Prüfen, ob ein Feldtyp definiert ist:
        if (typeof (field.type) === "undefined" || field.type === null || field.type == '') {
            //Das Feld ist offenbar nicht korrekt definiert.
            continue;
        }

        var type = field.type;
        var hasObjectValue = (field.obj !== null) ? true : false;
        if (hasObjectValue) {
            hasObjectValue = (typeof (field.obj.value) != "undefined") ? true : false;
        }
        if (type !== 'textarea') {
            var value = (type != "DataStructure" && type != "Bestellkatalog" && type != "AssetDeskOrderCatalog" && type != "radio" && type != "checkbox" && type != "userdata" && hasObjectValue)
                    ? trim(field.obj.value) : "";
        } else {
            var value = $("#textarea_" + field.name).val();
        }
        fields[i].errorcode = 0;
        fields[i].errormessage = "";
        fields[i].err.style.display = "none";
        fields[i].err.innerHTML = " ";
        if (field.required && (type == "DataStructure" || type == "Bestellkatalog" || type == "select" || type == "userdata")) {
            if(value == null){
                fields[i].errorcode = 404;
                fields[i].errormessage = "field empty";
                error = true;
            }            
            else if (value == noneSelectedText) {
                fields[i].errorcode = 404;
                fields[i].errormessage = "field empty";
                error = true;
            }
        } else if (field.required && type != "DataStructure" && type != "Bestellkatalog" && type != "select" && type != "radio" && type != "checkbox" && type != "userdata" && type != "checklist") {
            if(value == null){
                fields[i].errorcode = 404;
                fields[i].errormessage = "field empty";
                error = true;
            }
            else if (value == noneSelectedText) {
                fields[i].errorcode = 404;
                fields[i].errormessage = "field empty";
                error = true;
            }          
            else if (value.length == 0) {
                fields[i].errorcode = 404;
                fields[i].errormessage = "field empty";
                error = true;
            }
        } else if (field.required && (type == "radio" || type == "checkbox")) {
            console.log("Field checklist 2");
            var elements = (type == "checkbox")
                    ? document.getElementsByName(field.name + "[]")
                    : document.getElementsByName(field.name);
            var checked = false;

            for (j = 0; j < elements.length; j++) {
                if (elements[j].checked)
                    checked = true;
            }

            if (!checked) {
                fields[i].errorcode = 101;
                fields[i].errormessage = "nothing selected";
                error = true;
            }

        } else if (field.required && (type === "checklist")) {
            console.log("Prüfe Field checklist 2");
            var checked = true;
            var elements = document.getElementsByName(field.name + "[]");
            for (j = 0; j < elements.length; j++) {
                if (!elements[j].checked) {
                    checked = false;
                    break;
                }

            }
            if (!checked) {
                fields[i].errorcode = 102;
                fields[i].errormessage = "not all selected";
                error = true;
            }

        } else if (field.required && type == "DataStructure") {
            //> 1 da "Filiale wählen" immer angezeigt wird...
            if ($("#field_" + fields[i].name + "Filiale option").size() > 1 && $("#field_" + fields[i].name + "Filiale").val() < 1) {
                fields[i].errorcode = 101;
                fields[i].errormessage = "nothing selected";
                error = true;
            }
            if ($("#field_" + fields[i].name + "Job option").size() > 0 && !$("#field_" + fields[i].name + "Job").val() > 0) {
                fields[i].errorcode = 101;
                fields[i].errormessage = "nothing selected";
                error = true;
            }
            if ($("#field_" + fields[i].name + "MA option").size() > 0 && !$("#field_" + fields[i].name + "MA").val() > 0) {
                fields[i].errorcode = 101;
                fields[i].errormessage = "nothing selected";
                error = true;
            }

        } else if (field.required) {
            var tmp = fields[i].obj.options.selectedIndex;
            if (tmp < 0) {
                fields[i].errorcode = 101;
                fields[i].errormessage = "nothing selected";
                error = true;
            }
        }

        if (!fields[i].hasError() && value.length != "") {

            if (type == "integer" && !valid_int(value)) {
                fields[i].errorcode = 201;
                fields[i].errormessage = "invalid number";
                error = true;
            }

            if (type == "date" && !valid_date(value)) {
                fields[i].errorcode = 301;
                fields[i].errormessage = "invalid date";
                error = true;
            }

            if (type == "datetime" && !valid_datetime(value)) {
                fields[i].errorcode = 302;
                fields[i].errormessage = "invalid datetime";
                error = true;
            }

            if (type == "value") {
                if (!valid_int(value)) {
                    fields[i].errorcode = 201;
                    fields[i].errormessage = "invalid integer";
                    error = true;
                }
            }

            if (type == "text") {

                switch (field.evaluate) {

                    case "dmY":
                        if (!valid_date(value)) {
                            fields[i].errorcode = 301;
                            fields[i].errormessage = "invalid date";
                            error = true;
                        }
                        break;

                    case "hm":
                        if (!valid_time(value)) {
                            fields[i].errorcode = 303;
                            fields[i].errormessage = "invalid time";
                            error = true;
                        }
                        break;

                    case "dmYhm":
                        if (!valid_datetime(value)) {
                            fields[i].errorcode = 302;
                            fields[i].errormessage = "invalid datetime";
                            error = true;
                        }
                        break;

                    case "Y":
                        if (!valid_year(value)) {
                            fields[i].errorcode = 304;
                            fields[i].errormessage = "invalid year";
                            error = true;
                        }
                        break;

                    case "int":
                        if (!valid_int(value)) {
                            fields[i].errorcode = 201;
                            fields[i].errormessage = "invalid integer";
                            error = true;
                        }
                        break;

                    case "float":
                        if (!valid_float(value)) {
                            fields[i].errorcode = 202;
                            fields[i].errormessage = "invalid float";
                            error = true;
                        }
                        break;

                    case "alpha":
                        if (!valid_alphanumeric(value)) {
                            fields[i].errorcode = 405;
                            fields[i].errormessage = "not alphanumeric";
                            error = true;
                        }
                        break;

                    case "upper":
                        if (!valid_upper(value)) {
                            fields[i].errorcode = 406;
                            fields[i].errormessage = "not uppercase";
                            error = true;
                        }
                        break;

                    case "lower":
                        if (!valid_lower(value)) {
                            fields[i].errorcode = 407;
                            fields[i].errormessage = "not lowercase";
                            error = true;
                        }
                        break;

                    case "url":
                        if (!valid_url(value)) {
                            fields[i].errorcode = 408;
                            fields[i].errormessage = "invalid url";
                            error = true;
                        }
                        break;

                    case "mail":
                        if (!valid_mail(value)) {
                            fields[i].errorcode = 409;
                            fields[i].errormessage = "invalid mail";
                            error = true;
                        }
                        break;

                    default:
                        break;
                }
            }
        }
        if (fields[i].hasError()) {
            fields[i].err.innerHTML = ErrorMessages[fields[i].errorcode];
            fields[i].err.style.display = "block";
        }
    }
    return !error;
}

function valid_datetime(Datum)
{
    if (Datum.length == 16 && Datum.substring(10, 11) == " ") {

        var Zeit = Datum.substring(11, 16);
        var Datum = Datum.substring(0, 10);

        return (valid_date(Datum) && valid_time(Zeit))
                ? true : false;
    }
    return false;
}

function valid_date(Datum)
{
    if (Datum.length == 10 && Datum.substring(2, 3) == "." &&
            Datum.substring(5, 6) == ".") {

        var Day = parseInt(Datum.substring(0, 2), 10);
        var Month = parseInt(Datum.substring(3, 5), 10);
        var Year = parseInt(Datum.substring(6, 10), 10);
        var myDate = new Date(Year, Month - 1, Day);
        var Day2 = myDate.getDate();
        var Year2 = myDate.getFullYear();
        var Month2 = myDate.getMonth() + 1;

        return (Day2 == Day && Month2 == Month && Year2 == Year)
                ? true : false;
    }
    return false;
}

function valid_time(Zeit)
{
    if (Zeit.length == 5 && Zeit.substring(2, 3) == ":") {

        var Hour = parseInt(Zeit.substring(0, 2), 10);
        var Minute = parseInt(Zeit.substring(3, 5), 10);

        return (!isNaN(Hour) && !isNaN(Minute) && Hour >= 0 && Hour < 24 &&
                Minute >= 0 && Minute < 60) ? true : false;
    }
    return false;
}

function valid_int(Nummer)
{
    var regex = /^[+-]{0,1}[0-9]+$/
    return (Nummer.match(regex)) ? true : false;
}

function valid_float(Nummer)
{
    var regex = /^[+-]{0,1}[0-9]+[,.]{0,1}[0-9]+$/;
    return (Nummer.match(regex)) ? true : false;
}

function valid_upper(Str)
{
    return (Str == Str.toUpperCase()) ? true : false;
}

function valid_lower(Str)
{
    return (Str == Str.toLowerCase()) ? true : false;
}

function valid_mail(Mail)
{
    var regex = /^((([a-z]|[A-Z]|[0-9]|!|#|$|%|&|'|\*|\+|\-|\/|=|\?|\^|_|`|\{|\||\}|~)+(\.([A-Z]|[a-z]|[0-9]|!|#|$|%|&|'|\*|\+|\-|\/|=|\?|\^|_|`|\{|\||\}|~)+)*)@((((([a-z]|[0-9])([a-z]|[0-9]|\-){0,61}([a-z]|[0-9])\.))*([a-z]|[0-9])([a-z]|[0-9]|\-){0,61}([a-z]|[0-9])\.)[\w]{2,4}|(((([0-9]){1,3}\.){3}([0-9]){1,3}))|(\[((([0-9]){1,3}\.){3}([0-9]){1,3})\])))$/
    return (regex.test(Mail)) ? true : false;
}

function valid_url(Url)
{
    var regex = /^(([\w]+:)?\/\/)?(([\d\w]|%[a-fA-f\d]{2,2})+(:([\d\w]|%[a-fA-f\d]{2,2})+)?@)?([\d\w][-\d\w]{0,253}[\d\w]\.)+[\w]{2,4}(:[\d]+)?(\/([-+_~.\d\w]|%[a-fA-f\d]{2,2})*)*(\?(&?([-+_~.\d\w]|%[a-fA-f\d]{2,2})=?)*)?(#([-+_~.\d\w]|%[a-fA-f\d]{2,2})*)?$/;
    return (regex.test(Url)) ? true : false;
}

function valid_alphanumeric(Alpha)
{
    var regex = /^[a-zA-Z0-9_-]*$/;
    return (Alpha.match(regex)) ? true : false;
}

function valid_year(Year)
{
    var regex = /^[0-9]{4}$/;
    return (Year.match(regex)) ? true : false;
}

