<div class="panel panel-fcs-border">
    <input type="hidden" name="ScheduledWorkflowDfinitionID" value="{{ $ScheduledWorkflowDfinitionID }}" />
    <div class="panel-body">
        <div class="row">
            <div class="col-sm-12">
                <div class="form-group">
                    <label class="control-label col-lg-2">
                        Workflow-Definition*
                    </label>
                    <div class="col-lg-10">
                        <select id="WorkflowDefinitionID" name="WorkflowDefinitionID" required class="form-control multiple" onchange="SetWorkflow()">
                            <option value="">-- Bitte wählen --</option>
                            @foreach ($Workflows as $workflow)
                                <option value="{{ $workflow->ID }}" {{ ($workflow->ID == $SelectedWorkflowID ? "selected" : "") }}>{{ $workflow->Description }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-lg-2">
                        Name*
                    </label>
                    <div class="col-lg-10">
                        <input type="text" size="15" required name="ScheduledWorkflowName" class="form-control" value="{{ $Name }}" />
                    </div>
                </div>

                @if ($HideInitiator == false)
                    <div class="form-group">
                        <label class="control-label col-lg-2"  title="Person, die den Workflow startet.">
                            Initiator
                        </label>
                        <div class="col-lg-10">
                            <select name="InitiatorID" id="InitiatorID" class="form-control">
                                <option value="0" selected="selected">-- Bitte wählen --</option>
                                @foreach ($Initiators as $initiator)
                                    <option value="{{ $initiator->user_id }}" {{ ($initiator->user_id == $SelectedInitiatorID ? "selected" : "") }}>{{ $initiator->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                @endif

                @if ($ShowSubstituder == true)
                    <div class="form-group">
                        <label class="control-label col-lg-2"  title="Vertreter der Person, die den Workflow startet.">
                            Vertreter
                        </label>
                        <div class="col-lg-10">
                            <select name="SubstituderID" id="SubstituderID" class="form-control">
                                <option value="0" selected="selected">-- Bitte wählen --</option>
                                @foreach ($Substituders as $substituder)
                                    <option value="{{ $substituder->user_id }}" {{ ($substituder->user_id == $SelectedSubstituderID ? "selected" : "") }}>{{ $substituder->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                @endif
                    
                @if ($HideContact == true)
                    <input type="hidden" value="[% $user->ContactID %]" name="ContactID">
                @else
                    <div class="form-group">
                        <label class="control-label col-lg-2">
                            Kontakt
                        </label>
                        <div class="col-lg-10">
                            <select size="1" name="ContactID" id="ContactID" class="form-control">
                                <option value="0" selected="selected">-- Bitte wählen --</option>
                                @foreach ($Contacts as $contact)
                                    <option value="{{ $contact->contact_id }}" {{ ($contact->contact_id == $SelectedContactID ? "selected" : "") }}>{{ $contact->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                @endif

                @if ($ShowProject == true)
                    <div class="form-group">
                        <label class="control-label col-lg-2">
                            Projekt
                        </label>
                        <div class="col-lg-10">
                            <select name="ProjectID" id="ProjectID" class="form-control multiple">
                                <option value="0" selected="selected">-- Bitte wählen --</option>
                                @foreach ($Projects as $project)
                                    <option value="{{ $project->ProjectID }}" {{ ($project->ProjectID == $SelectedProjectID ? "selected" : "") }}>{{ $project->ProjectName }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                @endif

                <div class="form-group">
                    <label class="control-label col-lg-2">
                        Wiederholungsmodus
                    </label>
                    <div class="col-lg-10">
                        <select size="1" name="RepeatType" id="RepeatType" class="form-control">
                            <option value="1" {{ ($SelectedRepeatType == 1 ? "selected" : "") }}>Täglich</option> 
                            <option value="2" {{ ($SelectedRepeatType == 2 ? "selected" : "") }}>Wöchentlich</option>
                            <option value="3" {{ ($SelectedRepeatType == 3 ? "selected" : "") }}>Monatlich</option>
                            <option value="4" {{ ($SelectedRepeatType == 4 ? "selected" : "") }}>Jährlich</option>
                            <option value="5" {{ ($SelectedRepeatType == 5 ? "selected" : "") }}>Alle X-Tage</option>
                        </select>
                    </div>
                </div>

                <div class="form-group"  id="pnlMonthlyDay" style="display:none;">
                    <label class="control-label col-lg-2">
                        Tag des Monats
                    </label>
                    <div class="col-lg-1">
                        <input type="number" min="1" max="31" name="MonthlyDay" id ="MonthlyDay" class="form-control" value="{{ $MonthlyDay }}" />
                    </div>
                </div>

                <div class="form-group"  id="pnlYearlyDate" style="display:none;">
                    <label class="control-label col-lg-2">
                        Jährlich am
                    </label>
                    <div class="col-lg-2">
                        <input type="date" name="YearlyDate" id ="YearlyDate" class="form-control datetimepicker" value="{{ $YearlyDate }}" />
                    </div>
                </div>

                <div class="form-group" id="pnlDelayDays" style="display:none">
                    <label class="control-label col-lg-2">
                        Wiederholung alle
                    </label>
                    <div class="col-lg-1">
                        <input type="number" min="1" value="{{ $DelayDays }}" name="DelayDays" class="form-control" />
                    </div>
                    <label class="control-label col-lg-9">
                        Tage
                    </label>
                </div>

                <div class="form-group">
                    <label class="control-label col-lg-2">
                        Startzeit um*
                    </label>
                    <div class="col-lg-1">
                        <input type="time" required value="{{ $StartTime }}" name="StartTime" class="form-control" />
                    </div>
                </div>

                <div class="form-group" id="pnlWeekdays">
                    <label class="control-label col-lg-2">
                        Wiederholen am
                    </label>
                    <div class="col-lg-10">
                        <input type="checkbox" value="1" name="weekday[1]" @if(in_array(1, $Weekdays)) checked @endif />Mo
                        <input type="checkbox" value="2" name="weekday[2]" @if(in_array(2, $Weekdays)) checked @endif />Di
                        <input type="checkbox" value="3" name="weekday[3]" @if(in_array(3, $Weekdays)) checked @endif />Mi
                        <input type="checkbox" value="4" name="weekday[4]" @if(in_array(4, $Weekdays)) checked @endif />Do
                        <input type="checkbox" value="5" name="weekday[5]" @if(in_array(5, $Weekdays)) checked @endif />Fr
                        <input type="checkbox" value="6" name="weekday[6]" @if(in_array(6, $Weekdays)) checked @endif />Sa
                        <input type="checkbox" value="0" name="weekday[0]" @if(in_array(0, $Weekdays)) checked @endif />So
                    </div>
                </div>

                <div class="form-group" id="WorkflowActive">
                    <label class="control-label col-lg-2">
                        Aktiv
                    </label>
                    <div class="col-lg-10">
                        <input type="checkbox" value="1" name="Active" @if($Active == true)) checked @endif/>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function ()
    {
        var repeatMode = document.getElementById("RepeatType").value;
        ToggleRepeatPanels(parseInt(repeatMode));
    });

    $('#RepeatType').on('change', function(e)
    {
        ToggleRepeatPanels(parseInt(this.value));
    });

    function ToggleRepeatPanels(repeatType)
    {
        switch(repeatType)
        {
            case 1: //Täglich
                document.getElementById("pnlWeekdays").style.display = "none";
                document.getElementById("pnlMonthlyDay").style.display = "none";
                document.getElementById("pnlYearlyDate").style.display = "none";
                document.getElementById("pnlDelayDays").style.display = "none";
                break;
            case 2: //Wöchentlich
                document.getElementById("pnlWeekdays").style.display = "block";
                document.getElementById("pnlMonthlyDay").style.display = "none";
                document.getElementById("pnlYearlyDate").style.display = "none";
                document.getElementById("pnlDelayDays").style.display = "none";
                break;
            case 3: //Monatlich
                document.getElementById("pnlWeekdays").style.display = "none";
                document.getElementById("pnlMonthlyDay").style.display = "block";
                document.getElementById("pnlYearlyDate").style.display = "none";
                document.getElementById("pnlDelayDays").style.display = "none";
                break;
            case 4: //Jährlich
                document.getElementById("pnlWeekdays").style.display = "none";
                document.getElementById("pnlMonthlyDay").style.display = "none";
                document.getElementById("pnlYearlyDate").style.display = "block";
                document.getElementById("pnlDelayDays").style.display = "none";
                break;
            case 5: //Nach X-Tagen
                document.getElementById("pnlWeekdays").style.display = "none";
                document.getElementById("pnlMonthlyDay").style.display = "none";
                document.getElementById("pnlYearlyDate").style.display = "none";
                document.getElementById("pnlDelayDays").style.display = "block";
                break;
        }
    }
</script>
