<?php

/**
 * FR_Object_Web
 *
 * @author Dirk Herbes <d.herbes@fair-computer.de>
 * @copyright Dirk Herbes <d.herbes@fair-computer.de>
 * @package Framework
 * @filesource
 */

/**
 * FR_Object_Web
 *
 * This is the base class for web applications extended from FR_Module, which
 * includes all module classes. Sets up a current user and session.
 *
 * @author Dirk Herbes <d.herbes@fair-computer.de>
 * @package Framework
 */
abstract class FR_Object_Web extends FR_Object_DB {

    // {{{ properties
    /**
     * $user
     *
     * This is the current user. If the user is not logged in then the
     * information defaults to the special anonymous user (userID = 0).
     *
     * @author Dirk Herbes <d.herbes@fair-computer.de>
     * @var mixed $user Instnace of FR_User of current user
     */
    protected $user;

    /**
     * $session
     *
     * A simple wrapper class around PHP's $_SESSION variable.
     *
     * @author Dirk Herbes <d.herbes@fair-computer.de>
     * @var mixed $session Instance of FR_Session
     */
    protected $session;

    // }}}

    public function __construct(FR_Module $module = null) {


        parent::__construct();
        $this->session = FR_Session::singleton();
        //Wird das Web-Objekt mit einem Modul aufgerufen, wird das user-Objekt dieses Moduls verwendet,
        //ansonsten wird ein neues user-Objekt erstellt.
        if (isset($module->user)) {
            $this->user = $module->user;
            $this->baseurl = $this->user->baseurl;
        } else {
            $this->user = new FR_User();
            $this->baseurl = $this->user->baseurl;
        }

        $this->tools = FR_Tools::singleton();
        $this->tools->setUser($this->user);

//JsonObjecte aus Requests in POST & REQUEST-Array schreiben:
        $this->tools->putJsonInPost();
    }

    public function __destruct() {
        parent::__destruct();
    }

}
