<?php

/**
 * Description of Event
 *
 * @author jkoepke
 */
class FR_Ticket_Event extends FR_Object_Web {

    private $TicketID = 0;

    public function __construct($TicketID) {
        parent::__construct();

        $this->TicketID = $TicketID;
    }

    /**
     * Erstellt ein TicketEvent in der Tabelle hm_TicketEvent fr ein Ticket.
     *
     * @param int $TicketStatusID
     * @param string $Text
     * @return boolean TRUE => Event wurde erstellt.
     */
    public function createTicketEvent($TicketStatusID = 5, $Text = '', $NotPublic = 0) {

        $NoError = true;
//jk, 10.04.2013: Wegman automotive: Alle Bearbeitungen als Interne Notiz, sofern nicht anders angegeben:
        if (defined('HMCOMPANY') && HMCOMPANY == 'WEGMANN AUTOMOTIVE GMBH & CO. KG') {
            $NotPublic = 1;
        } else {
            $NotPublic = 0;
        }
        $sql = sprintf('INSERT INTO hm_TicketEvent (
                TicketID, UserID, TicketStatusID, EventDescr,
                CreateDate, CreateUserID, UpdateDate,
                UpdateUserID, EventDate, Invoiced,
                CostGroupID, CostRatePerMinute, Cat1IDForCostGroup, NotPublic)
                VALUES ( %u, %u, %u, %s,
                %s, %u, %s,
                %u, %s, 0,
                0, NULL, NULL, %u)', $this->TicketID, $this->user->UserID, $TicketStatusID, $this->db->quoteSmart($Text), $this->DB_DATE('now()'), $this->user->UserID, $this->DB_DATE('now()'), $this->user->UserID, $this->DB_DATE('now()'), $NotPublic);

        $res = $this->db->query($sql);

        if (DB::isError($res)) {
            $this->log->log('TicketEvent could not create. Message: ' . $res->getMessage(), PEAR_LOG_ERR);
            $this->tools->debugLog($sql);
            $NoError = false;
            throw new Exception("TicketEvent could not create. Message: " . $res->getMessage());
        }
        return $NoError;
    }

}
