<?php
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------+
// | PHP Version 5                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2003 The PHP Group                                |
// +----------------------------------------------------------------------+
// | This source file is subject to version 2.02 of the PHP license,      |
// | that is bundled with this package in the file LICENSE, and is        |
// | available at through the world-wide-web at                           |
// | http://www.php.net/license/2_02.txt.                                 |
// | If you did not receive a copy of the PHP license and are unable to   |
// | obtain it through the world-wide-web, please send a note to          |
// | license@php.net so we can mail you a copy immediately.               |
// +----------------------------------------------------------------------+
// | Author: Stijn de Reede <sjr@gmx.co.uk>                               |
// +----------------------------------------------------------------------+
//
// $Id$
//


/**
* @package  HTML_BBCodeParser2
* @author   Stijn de Reede  <sjr@gmx.co.uk>
*/

require_once 'HTML/BBCodeParser2/Filter.php';

/**
 * 
 */
class HTML_BBCodeParser2_Filter_Table extends HTML_BBCodeParser2_Filter
{

    /**
    * An array of tags parsed by the engine
    *
    * @access   private
    * @var      array
    */
    var $_definedTags = array(  'table'  => array(   'htmlopen'  => 'table',
                                                    'htmlclose' => 'table',
                                                    'allowed'   => 'all'
                                                    ),
                                'tr' => array(   'htmlopen'  => 'tr',
                                                    'htmlclose' => 'tr',
                                                    'allowed'   => 'all'
                                                    ),
                                'th'    => array(   'htmlopen'  => 'th',
                                                    'htmlclose' => 'th',
                                                    'allowed'   => 'all'
                                                    ),
                                'td' => array(   'htmlopen'  => 'td',
                                                    'htmlclose' => 'td',
                                                    'allowed'   => 'all'
                                                    ),
                                'center' => array(   'htmlopen'  => 'span style="text-align: center;"',
                                                'htmlclose' => 'span',
                                                'allowed'   => 'all',
                                                'attributes'=> array()),        
                                );
}
