
<script src="includes/js/dropzone.js"></script>
<link href="includes/js/dropzone.css" rel="stylesheet" type="text/css" />

<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

<style>
    .diffCol {
        color:  green;
    }    
    .importError {
        color:red;
    }
    .importSuccess{
        color:green;
    }
</style>
<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h2">[% $user->gettext('Assetverwaltung') %]</span>
    </div>
    <div class="card-body">

        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <span class="fcs-card-title h3">[% $user->gettext('CSV Import') %]

                    <div class="pull-right">
                        <a href="index.php?module=assets" class='btn btn-outline-secondary'>[% $user->gettext('Liste') %]</a>

                        <a href="index.php?module=assets&event=clearCSVImport" class="btn btn-outline-primary">[% $user->gettext('Liste leeren') %]</a>                        

                        <a href="index.php?module=assets&event=getCSVHeaders" class="btn btn-outline-primary">[% $user->gettext('CSV-Vorlage herunterladen') %]</a>
                    </div>
            </div>
            <div class="card-body">

                <div class="card panel-info shadow-sm rounded">
                    <div class="card-body">
                        <form action="index.php?module=assets&event=CSVImport" method="post" id="CSVImportForm" class="form form-horizontal center-block">

                            <label><input type="checkbox" name="notExist" id="notExist" value="1" checked> [% $user->gettext('Neue Assets') %]</label>

                            <label><input type="checkbox" name="hasUpdate" id="hasUpdate" value="1" checked> [% $user->gettext('Geänderte Assets') %]</label>

                            <label><input type="checkbox" name="noChanges" id="noChanges" value="1" > [% $user->gettext('Assets ohne Änderungen') %]</label>

                            <span class="pull-right">
                                <label><input type="number" class="form-control" id="StepWide" value="10" width="2"> [% $user->gettext('Assets auf einmal importieren') %]</label>
                            </span>


                            [% if $cntEntries %]


                                <p>[% $user->gettext('Es wurden') %] [% $cntEntries %] [% $user->gettext('Einträge zum importieren gefunden. Sollen diese Assets angelegt / aktualisiert werden?') %]</p>
                                <input type="hidden" name="importData" value="1">
                                <span id="startImport" class="btn btn-outline-secondary">[% $user->gettext('Ja') %]</span>

                                <table id="ResultTable"  class="table table-bordered table-striped table-sm hidden">
                                    <thead>
                                        <tr>
                                            <th>
                                                [% $user->gettext('Asset') %]
                                            </th>
                                            <th>
                                                [% $user->gettext('Messages') %]
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>



                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped table-sm">
                                        <thead>
                                            <tr>
                                                <th>
                                                    <input type="checkbox" id="SelectAll" />
                                                </th>
                                                <th>
                                                    [% $user->gettext('Aktion') %]
                                                </th>
                                                [% foreach from=$Headers item=Col %]                                                    
                                                    <th>
                                                        [% $Col %]
                                                    </th>
                                                [% /foreach %]
                                            </tr>
                                        </thead>
                                        <tbody>

                                            [% foreach from=$CSVData item=Object key=csvKey %]
                                                <tr id="CSVColNo_[% $csvKey %]" class="[% if $Compare.$csvKey.exist %]exist [% if $Compare.$csvKey.update %]hasUpdate[% else %]noChanges hidden [% /if %][% else %] notExist[% /if %]">
                                                    <td>
                                                        [% if !$Compare.$csvKey.exist || $Compare.$csvKey.update  %]
                                                            <input type="checkbox" class="AssetSelection" id="AssetSelection_[% $csvKey %]" name="selectedAssets[[% $csvKey %]]" value="[% $csvKey %]" class="form-control" />
                                                        [% /if %]
                                                    </td>
                                                    <td>
                                                        [% if $Compare.$csvKey.exist %]                                                         
                                                            [% if $Compare.$csvKey.update %]
                                                                [% $user->gettext('Update') %] 
                                                            [% else %]
                                                                [% $user->gettext('Keine Änderungen') %] 
                                                            [% /if %]

                                                        [% else %]
                                                            [% $user->gettext('Anlegen') %]
                                                        [% /if %]
                                                    </td>
                                                    [% foreach from=$Object item=val key=ColName %]
                                                        <td [% if $Compare.$csvKey.values.$ColName %] class="diffCol"[% /if %]>
                                                            [% $val %]
                                                            [% if $Compare.$csvKey.values.$ColName %]
                                                                <hr/><span class="diffValue" title="[% $user->gettext('Vorheriger Wert') %]">
                                                                    [% $Compare.$csvKey.values.$ColName %]                                                                
                                                                </span>
                                                            [% /if %]
                                                        </td>
                                                    [% /foreach %]
                                                </tr>
                                            [% /foreach %]
                                        </tbody>
                                    </table>
                                </div>

                            [% else %]
                                <div class="well" id="dropCSV">
                                <p >
                                    <strong style="font-size: 2em;">[% $user->gettext('CSV-Datei per Drag and Drop reinziehen') %]</strong>
                                </p>
                                </div>
                            [% /if %]
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<script>

    $(document).ready(function () {

        $('#SelectAll').on("click", function () {
            if ($('#SelectAll').prop('checked')) {
                $('.AssetSelection:visible').prop('checked', true);
            } else {
                $('.AssetSelection:visible').prop('checked', false);
            }
        })
        $("#hasUpdate").on("click", function () {
            $('.hasUpdate').toggleClass('hidden');
        })

        $("#notExist").on("click", function () {
            $('.notExist').toggleClass('hidden');
        })

        $("#noChanges").on("click", function () {
            $('.noChanges').toggleClass('hidden');
        })


        $('#startImport').on("click", function (e) {
            importFirstSelectedDevice();
        })

        /**
         * Comment
         */
        function importFirstSelectedDevice() {

            CSVColNo = $(".AssetSelection:checkbox:checked:first").val();
            if (typeof CSVColNo === "undefined") {
                return;
            }

//            console.log("Nächste: ");
//            console.log("ColNo: " + CSVColNo);

            var selected = [];
            ii = 0;
            $('.AssetSelection:checkbox:checked').each(function () {
                selected.push($(this).val());
                ii++;
                if (ii == $('#StepWide').val()) {
                    return false;
                }

            });
//             console.log("selected: " + selected);


            $.post("index.php?module=assets&event=startCSVImport&CSVColNo=" + CSVColNo, {selected: selected}, function (data) {
//                 console.log(data);

            }).done(function (data) {

// console.log(data);
                $.each(data, function (key, val) {
                    $('#ResultTable').removeClass('hidden');

                    markup = "<tr id='Result_" + key + "' class=' " + (val.error ? 'importError' : 'importSuccess') + "' ><td>" + val.DeviceData.hostname + " / " + val.DeviceData.devicename + "</td><td>";
                    $.each(val.messages, function (i, item) {
                        markup += item + "<br/>";
                    })
                    markup += "</td></tr>";
                    $('#ResultTable > tbody').append(markup);

                    if (val.error) {
                        $("#CSVColNo_" + key).addClass('importError');
                        //Wenn es einen Fehler gab, die Markierung entfernen.
                        $('#AssetSelection_' + key).prop('checked', false);
                    } else {
                    $("#CSVColNo_" + CSVColNo).fadeOut();
                        $("#CSVColNo_" + key).remove();
                    }


              $("#Result_" + CSVColNo).hide();
                $("#Result_" + CSVColNo).fadeIn();
                    $("#Result_" + key).show();
                });

                importFirstSelectedDevice();
            });

        }

        Dropzone.options.myDropzone = {

            init: function () {

                this.on("queuecomplete", function (file) {
                    //this.removeAllFiles();
                });
            }
        };

    $("#dropCSV").dropzone({
            url: "index.php?module=assets&event=getCSVFile",
            init: function () {
                this.on("queuecomplete", function (file) {
                    //this.removeAllFiles();
                    location.reload();
                });
            }
        });
    })
</script>
