<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h2">[% $user->gettext('Assetverwaltung') %]</span>
    </div>
    <div class="card-body">

        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <span class="fcs-card-title h3">[% $user->gettext('Assettypen') %]</span>[% if $Tools->FCS_Count($nav.entries) %]<span class="fcs-card-title"> - [% $nav.entries %] [% $user->gettext('Eintr&auml;ge gefunden') %]</span>[% /if %]
                
                <div class="btn-group pull-right">
                    <a  class="btn btn-outline-primary" type="button" href="index.php?module=assets">
                                [%$user->gettext('Assets')%]
                    </a>
                    <a class="btn btn-outline-primary" type="button" href="index.php?module=assets&class=assettypes&event=editDeviceType">
                        [% $user->gettext('Neuer Assettyp') %] 
                    </a>
                </div>     

            </div>
            <div class="card-body">

                <div class="card panel-info shadow-sm rounded">                  
                    <div class="card-body">

                        <div class="table-responsive">
                            <table class="table table-striped table-bordered  table-condensed">
                                <thead>
                                    <tr>
                                        <th>[% $user->gettext('ID') %]</th>
                                        <th>[% $user->gettext('Name') %]</th>
                                        <th>&nbsp;</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    [% foreach from=$DeviceTypes item=DeviceType key=DeviceTypeID %]
                                        <tr>
                                            <td>[% $DeviceTypeID %]</td>
                                            <td>[% $DeviceType.typename %]</td>
                                            <td>
                                                <a href="index.php?module=assets&class=assettypes&event=editDeviceType&devicetypeid=[% $DeviceTypeID %]"><span class="btn btn-sm btn-outline-secondary"><span class="fa fa-pencil"></span></span></a>
                                                <a href="index.php?module=assets&class=assettypes&event=CSVOutDeviceType&devicetypeid=[% $DeviceTypeID %]"><span class="btn btn-sm btn-outline-secondary" title="[% $user->gettext('CSV-Export') %]"><span class="fa fa-list-alt"></span></span></a>
                                                [% if !$DeviceType.numberofdevices %]<a href="javascript:deleteType([% $DeviceTypeID %]);"><span class="btn btn-sm btn-outline-secondary" title="[% $user->gettext('Löschen') %]"><span class="fa fa-trash"></span></span></a>[% /if %]
                                            </td>
                                        </tr>
                                    [% /foreach %]
                                </tbody>
                                <tfoot>
                                <th>[% $user->gettext('ID') %]</th>
                                <th>[% $user->gettext('Name') %]</th>
                                <th>&nbsp;</th>                            
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<script>
    $(document).ready(function () {
        $('.table').DataTable({
            dom: 'Bfrtip',
            buttons: [
//                'colvis',
                'excel',
                'print',
                'pdfHtml5'
            ],
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            },
            initComplete: function () {
                this.api().columns().every(function () {
                    var column = this;
                    var select = $('<select><option value=""></option></select>')
                            .appendTo($(column.footer()).empty())
                            .on('change', function () {
                                var val = $.fn.dataTable.util.escapeRegex(
                                        $(this).val()
                                        );

                                column
                                        .search(val ? '^' + val : '', true, true)
                                        .draw();
                            });
                    column.data().unique().sort().each(function (d, j) {
                        select.append('<option value="' + d + '">' + d + '</option>')
                    });
                });
            }
        });
    })

    /**
     * 
     */
    function deleteType(id) {
        bootbox.confirm("[% $user->gettext('Daten wirklich löschen?') %]", function (result) {
            if (result) {
                window.location = "index.php?module=assets&class=assettypes&event=deleteDeviceType&devicetypeid=" + id;
            }
        })

    }

    [% if $message.message %]
    noty({
        text: "[% $message.message %]",
        type: [% if $message.error %]'error'[% else %]'success'[% /if %],
        timeout: notifyTimeout
    });
    [% /if %]
</script>
