<script src="includes/js/dropzone.js"></script>
<link href="includes/js/dropzone.css" rel="stylesheet" type="text/css" />

<style>
    .diffCol {
        color:  green;
    }    
    .importError {
        color:red;
    }
    .importSuccess{
        color:green;
    }
</style>
<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h2">[% $user->gettext('Fehlercodes') %]</span>
    </div>
    <div class="card-body">

        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <span class="fcs-card-title h3">[% $user->gettext('CSV Import') %] [% $Title %]

                    <div class="pull-right">
                        <a href="index.php?module=errorpatterns&event=Patterns" class='btn btn-outline-secondary'>[% $user->gettext('Liste') %]</a>

                        <a href="index.php?module=errorpatterns&class=errorpatterns&event=clearCSVImport&part=[% $Part %]" class="btn btn-outline-primary">[% $user->gettext('Liste leeren') %]</a>                        

                        <a href="index.php?module=errorpatterns&class=errorpatterns&event=getCSVHeaders&part=[% $Part %]" class="btn btn-outline-primary">[% $user->gettext('CSV-Vorlage herunterladen') %]</a>
                    </div>
            </div>
            <div class="card-body">

                <div class="card panel-info shadow-sm rounded">
                    <div class="card-body">
                        <form action="index.php?module=errorpatterns&event=CSVImport" method="post" id="CSVImportForm" class="form form-horizontal center-block">
                            <input type="hidden" name="part" id="part" value="[% $Part %]" />
                            <label><input type="checkbox" name="notExist" id="notExist" value="1" checked> [% $user->gettext('Neue') %]</label>

                            <label><input type="checkbox" name="hasUpdate" id="hasUpdate" value="1" checked> [% $user->gettext('Geänderte') %]</label>

                            <label><input type="checkbox" name="noChanges" id="noChanges" value="1" checked> [% $user->gettext('Ohne Änderungen') %]</label>


                            [% if $cntEntries %]


                                <p>[% $user->gettext('Es wurden') %] [% $cntEntries %] [% $user->gettext('Einträge zum importieren gefunden. Sollen diese angelegt / aktualisiert werden?') %]</p>
                                <input type="hidden" name="importData" value="1">
                                <span id="startImport" class="btn btn-outline-secondary">[% $user->gettext('Ja') %]</span>

                                <table id="ResultTable"  class="table table-bordered table-striped table-sm hidden">
                                    <thead>
                                        <tr>
                                            <th>
                                                [% $user->gettext('Eintrag') %]
                                            </th>
                                            <th>
                                                [% $user->gettext('Messages') %]
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>

                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped table-sm">
                                        <thead>
                                            <tr>
                                                <th>
                                                    <input type="checkbox" id="SelectAll" />
                                                </th>
                                                <th>
                                                    [% $user->gettext('Aktion') %]
                                                </th>
                                                [% foreach from=$Headers item=Col %]                                                    
                                                    <th>
                                                        [% $Col %]
                                                    </th>
                                                [% /foreach %]
                                            </tr>
                                        </thead>
                                        <tbody>

                                            [% foreach from=$CSVData item=Object key=csvKey %]
                                                <tr id="CSVColNo_[% $csvKey %]" class="[% if $Compare.$csvKey.exist %]exist [% if $Compare.$csvKey.update %]hasUpdate[% else %]noChanges[% /if %][% else %] notExist[% /if %]">
                                                    <td>
                                                        [% if !$Compare.$csvKey.exist || $Compare.$csvKey.update  %]
                                                            <input type="checkbox" class="AssetSelection" id="AssetSelection_[% $csvKey %]" name="selectedAssets[[% $csvKey %]]" value="[% $csvKey %]" class="form-control" />
                                                        [% /if %]
                                                    </td>
                                                    <td>
                                                        [% if $Compare.$csvKey.exist %]                                                         
                                                            [% if $Compare.$csvKey.update %]
                                                                [% $user->gettext('Update') %] 
                                                            [% else %]
                                                                [% $user->gettext('Keine Änderungen') %] 
                                                            [% /if %]

                                                        [% else %]
                                                            [% $user->gettext('Anlegen') %]
                                                        [% /if %]
                                                    </td>
                                                    [% foreach from=$Object item=val key=ColName %]
                                                        <td [% if $Compare.$csvKey.values.$ColName %] class="diffCol"[% /if %]>
                                                            [% $val %]
                                                            [% if $Compare.$csvKey.values.$ColName %]
                                                                <hr/><span class="diffValue" title="[% $user->gettext('Vorheriger Wert') %]">
                                                                    [% $Compare.$csvKey.values.$ColName %]                                                                
                                                                </span>
                                                            [% /if %]
                                                        </td>
                                                    [% /foreach %]
                                                </tr>
                                            [% /foreach %]
                                        </tbody>
                                    </table>
                                </div>

                            [% else %]
                                <p>
                                    <strong>[% $user->gettext('CSV-Datei per Drag and Drop reinziehen') %]</strong>
                                </p>
                            [% /if %]
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<script>

    $(document).ready(function () {

        $('#SelectAll').on("click", function () {
            $('.AssetSelection:visible').prop('checked', true);
        })
        $("#hasUpdate").on("click", function () {
            $('.hasUpdate').toggleClass('hidden');
        })

        $("#notExist").on("click", function () {
            $('.notExist').toggleClass('hidden');
        })

        $("#noChanges").on("click", function () {
            $('.noChanges').toggleClass('hidden');
        })


        $('#startImport').on("click", function (e) {
            importFirstSelectedDevice();
        })

        /**
         * Comment
         */
        function importFirstSelectedDevice() {

            CSVColNo = $(".AssetSelection:checkbox:checked:first").val();
            if (typeof CSVColNo === "undefined") {
                return;
            }

            //console.log("Nächste: ");
            //console.log("ColNo: " + CSVColNo);


            $.post("index.php?module=errorpatterns&event=startCSVImport&CSVColNo=" + CSVColNo + "&part=[% $Part %]", function (data) {
                //console.log(data);
            }).done(function (data) {

                $('#ResultTable').removeClass('hidden');

                markup = "<tr id='Result_" + CSVColNo + "' class=' " + (data.error ? 'importError' : 'importSuccess') + "' ><td>"  + data.DeviceData.de +" / " + data.DeviceData.en + "</td><td>";

                markup += data.message + "<br/>";

                markup += "</td></tr>";
                $('#ResultTable > tbody').append(markup);

                if (data.error) {
                    $("#CSVColNo_" + CSVColNo).addClass('importError');
                    //Wenn es einen Fehler gab, die Markierung entfernen.
                    $('#AssetSelection_' + CSVColNo).prop('checked', false);
                } else {
                    $("#CSVColNo_" + CSVColNo).fadeOut();
                    $("#CSVColNo_" + CSVColNo).remove();
                }


                $("#Result_" + CSVColNo).hide();
                $("#Result_" + CSVColNo).fadeIn();


                importFirstSelectedDevice();
            });

        }

        Dropzone.options.myDropzone = {

            init: function () {

                this.on("queuecomplete", function (file) {
                    //this.removeAllFiles();
                });
            }
        };

        $(".panel-fcs-content").dropzone({
            url: "index.php?module=errorpatterns&event=getCSVFile&part=" + $('#part').val(),
            init: function () {
                this.on("queuecomplete", function (file) {
                    //this.removeAllFiles();
                    location.reload();
                });
            }
        });
    })
</script>
