<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

<style>
    .notEditable {
        text-decoration: none;
        color: inherit;
        cursor: default;
        pointer-events: none;

    }
</style>

<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <h2 class="card-title-fcs">[% $user->gettext('Report Fehlerbilder') %]</h2>
    </div>

    <div class="card-body">
        <div class="card panel-info shadow-sm rounded">
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-12">
                        <form action="" method="post" name="hm" id="EPReportForm" enctype="multipart/form-data" class="form-inline fcs-form-padding">

                            <input type="hidden" name="pos" id="pos" value="[% $pos %]" />
                            <input type="hidden" name="sort" id="sort" value="[% $sort %]" />
                            <input type="hidden" name="sortorder" id="sortorder" value="[% $sortorder %]" />

                            [% if $user->hasRight(1100) %]
                                <div class="form-group row mb-3">
                                    <div class="btn-group" data-toggle="buttons">
                                        <label class="btn btn-outline-secondary" >
                                            <input type="checkbox" id="activateEditing" autocomplete="off" > [% $user->gettext('Bearbeitung aktivieren') %]
                                        </label>
                                    </div>
                                </div>
                            [% /if %]

                            <div class="form-group row mb-3">
                                <label  for="search">[% $user->gettext('Fehlerbild') %]</label>
                                <select name="Filter[EP.ID][]" id="EP" class="form-control" multiple>
                                    <option vlaue="0">-- [% $user->gettext('Alle') %] --</option>
                                    [% html_options options=$FilterData['ErrorPattern'][$Lang] selected=$selectedFilters['EP.ID'] %]
                                </select>
                            </div>

                            <div class="form-group row mb-3">
                                <label  for="search">[% $user->gettext('Fehlerbeschreibung') %]</label>
                                <select name="Filter[EPDescr.ID][]" id="EPDescr" class="form-control" multiple>
                                    <option vlaue="0">-- [% $user->gettext('Alle') %] --</option>
                                    [% html_options options=$FilterData['EPDescr'][$Lang] selected=$selectedFilters['EPDescr.ID'] %]
                                </select>
                            </div>

                            <div class="form-group row mb-3">
                                <label  for="search">[% $user->gettext('Fehlerobjekt') %]</label>
                                <select name="Filter[EPObject.ID][]" id="EPDescr" class="form-control" multiple>
                                    <option vlaue="0">-- [% $user->gettext('Alle') %] --</option>
                                    [% html_options options=$FilterData['EPObject'][$Lang] selected=$selectedFilters['EPObject.ID'] %]
                                </select>
                            </div>

                            <input type='submit' class="btn btn-outline-secondary" value='[% $user->gettext('Filtern') %]'>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <div class="row">
                    <div class="col-lg-6 text-left" >
                        <h3 class="card-title text-left" style="font-size: 24px; display:inline">
                            [% $user->gettext('Fehlerbilder')%]
                        </h3>
                        </span>
                    </div>

                </div>
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table id="reportTable" class="table">
                        <thead>
                            <tr>
                                <th>[% $user->gettext('Fehlerbild') %] de</th>
                                <th>[% $user->gettext('Fehlerbild') %] en</th>                                
                                <th>[% $user->gettext('Tickets je Fehlerbild') %]</th>                               
                                <th width="50">[% $user->gettext('Aktion') %]</th>
                            </tr>
                        </thead>
                        <tbody>
                            [% foreach from=$reportData item=row %]
                                <tr  class="PatternRow_[% $row['errorpatternid'] %]">

                                    <td data-export="[% $row['epdescr_de'] %] [% $row['epprepo_de'] %] [% $row['epobject_de'] %]">

                                        <a href="#" class="notEditable" title="[% $user->gettext('Fehlerbeschreibung bearbeiten') %]" data-type="text" data-pk="[% $row['epdescrid'] %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=descr&lang=de&id=[% $row['epdescrid'] %]" data-title="[% $user->gettext('Fehlerbeschreibung bearbeiten') %]">
                                            [% $row['epdescr_de'] %]
                                        </a>
                                        <a href="#" class="notEditable" title="[% $user->gettext('Präposition bearbeiten') %]" data-type="text" data-pk="[% $row['epprepoid'] %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=prepo&lang=de&id=[% $row['epprepoid'] %]" data-title="[% $user->gettext('Präposition bearbeiten') %]">
                                            [% $row['epprepo_de'] %]
                                        </a>
                                        <a href="#" class="notEditable" title="[% $user->gettext('Fehlerobjekt bearbeiten') %]" data-type="text" data-pk="[% $row['epobjectid'] %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=object&lang=de&id=[% $row['epobjectid'] %]" data-title="[% $user->gettext('Fehlerobjekt bearbeiten') %]">
                                            [% $row['epobject_de'] %]
                                        </a>


                                    </td>
                                    <td data-export="[% $row['epdescr_en'] %] [% $row['epprepo_en'] %] [% $row['epobject_en'] %]">

                                        <a href="#" class="notEditable" title="[% $user->gettext('Fehlerbeschreibung bearbeiten') %]" data-type="text" data-pk="[% $row['epdescrid'] %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=descr&lang=en&id=[% $row['epdescrid'] %]" data-title="[% $user->gettext('Fehlerbeschreibung bearbeiten') %]">
                                            [% $row['epdescr_en'] %]
                                        </a>
                                        <a href="#" class="notEditable" title="[% $user->gettext('Präposition bearbeiten') %]" data-type="text" data-pk="[% $row['epprepoid'] %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=prepo&lang=en&id=[% $row['epprepoid'] %]" data-title="[% $user->gettext('Präposition bearbeiten') %]">
                                            [% $row['epprepo_en'] %]
                                        </a>
                                        <a href="#" class="notEditable" title="[% $user->gettext('Fehlerobjekt bearbeiten') %]" data-type="text" data-pk="[% $row['epobjectid'] %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=object&lang=en&id=[% $row['epobjectid'] %]" data-title="[% $user->gettext('Fehlerobjekt bearbeiten') %]">
                                            [% $row['epobject_en'] %]
                                        </a>

                                    </td>                                    

                                    <td>
                                        [% $Ticketcnt['EP'][$row['errorpatternid']]|default:0 %]
                                    </td>
                                    <td>
                                        [% if !$Tools->FCS_Count($Ticketcnt['EP'][$row['errorpatternid']]) %]
                                            <span class="btn btn-outline-secondary btn-xs deleteErrorPattern" data-id="[% $row['errorpatternid'] %]" title="[% $user->gettext('Fehlerbild löschen') %]" ><span class="fa fa-times"></span></span>
                                            [% /if %]
                                    </td>                                    

                                </tr>
                            [% /foreach %]
                        </tbody>
                        <tfoot>

                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<script>
    $(document).ready(function () {

        $('.table').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'colvis',
                'excel',
                'print',
                'pdfHtml5'
            ],
    columnDefs: [
      {targets: '_all', render: function(data, type, row, meta) {
        var api = $('#example').DataTable();
        return type === 'export'? $(api.cell(meta.row, meta.col).node()).attr('data-export') : data;
      }
      }
    ],            
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            }
        });

    });

    [% if $user->hasRight(1100) %]
    $('#activateEditing').on('change', function (e) {
        if ($('#activateEditing').is(':checked')) {
            $(".notEditable").addClass('editable').removeClass('notEditable');
            $.fn.editable.defaults.mode = 'inline';
            $(".editable").editable({
                emptytext: '___',
                success: function (response, newValue) {
                    if (!response.success)
                        return response.message;
                }
            });
        } else {
            $(".editable").addClass('notEditable');
            $(".editable").editable('destroy');
        }
    });

    $('.deleteErrorPattern').on('click', function (e) {
        PatternID = $(this).data('id');
        bootbox.confirm("[% $user->gettext('Möchten Sie das Fehlerbild wirklich gelöscht werden?') %]", function (result) {
            if (result) {

                $.ajax({
                    type: "POST",
                    url: "index.php?module=errorpatterns&event=deleteErrorPattern",
                    data: {PatternID: PatternID}
                }).done(function (response) {
                    if (response.error) {
                        noty({
                            text: response.message,
                            type: 'error',
                            timeout: notifyTimeout
                        });
                    } else {
                        noty({
                            text: response.message,
                            type: 'success',
                            timeout: notifyTimeout
                        });
                        $('.PatternRow_' + PatternID).remove();
                    }
                });
            }
        })
    })

    [% /if %]


    $('select').select2({theme: 'bootstrap-5'});

</script>
