<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <h2 class="card-title-fcs">[% $user->gettext('Fehlercodes') %]</h2>
    </div>

    <div class="card-body">
        <div class="card panel-info shadow-sm rounded">
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-12">
                        <form action="" method="post" name="hm" id="EPErrorCodesForm" enctype="multipart/form-data" class="form-inline fcs-form-padding">

                            <input type="hidden" name="pos" id="pos" value="[% $pos %]" />
                            <input type="hidden" name="sort" id="sort" value="[% $sort %]" />
                            <input type="hidden" name="sortorder" id="sortorder" value="[% $sortorder %]" />
                            <input type="hidden" name="export" id="export" value="0" />

                            <div class="form-group row mb-3">
                                <label class="control-label">[% $user->gettext('Aktive Fehlercodes') %]</label>
                                <input type="checkbox" name="Filter[Active]" id="FilterActive" value="1" autocomplete="off" [% if $Filter['Active'] %]checked[% /if %]>
                            </div>

                            <div class="form-group row mb-3">
                                <label class="col-lg-4 control-label">[% $user->gettext('Artikelnummer') %]</label>
                                <div class="col-lg-8">
                                    <input type="string" class="form-control" name="Filter[ArticleNo]" value='[% $Filter['ArticleNo'] %]' />
                                </div>
                            </div>

                            <div class="form-group row mb-3">
                                <label class="col-lg-4 control-label">[% $user->gettext('Beschreibung') %]</label>
                                <div class="col-lg-8">
                                    <input type="string" class="form-control" name="Filter[Descr]" value='[% $Filter['Descr'] %]' />
                                </div>
                            </div>

                            <div class="form-group row mb-3">
                                <input type='submit' class="btn btn-outline-secondary" value='[% $user->gettext('Filtern') %]'>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <div class="row">
                    <div class="col-lg-6 text-left" >
                        <h3 class="card-title text-left" style="font-size: 24px; display:inline">
                            [% $user->gettext('Fehlercodes')%]
                        </h3>
                    </div>
                    <div class="col-lg-6 text-end" >
                        <a href="index.php?module=errorpatterns&class=errorcodes&event=add" class="btn btn-outline-secondary">[% $user->gettext('Fehlercode zufügen') %]</a>
                        <a href="index.php?module=errorpatterns&class=errorcodes&event=CSVImport" class="btn btn-outline-secondary">[% $user->gettext('Import') %] (csv)</a>
                        <a href="index.php?module=errorpatterns&class=errorcodes&event=CSVexport" class="btn btn-outline-secondary">[% $user->gettext('Export') %] (csv)</a>
                    </div>
                </div>
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table id="reportTable" class="table">
                        <thead>
                            <tr>
                                <th>[% $user->gettext('Errorcode') %]</th>
                                <th>[% $user->gettext('Artikelnummer') %]</th>
                                <th>[% $user->gettext('Beschreibung') %]</th>
                                <th>[% $user->gettext('Erstelldatum') %]</th>
                                <th>[% $user->gettext('Aktiv') %]</th>
                                <th>[% $user->gettext('Aktionen') %]</th>
                            </tr>
                        </thead>
                        <tbody>
                            [% foreach from=$ErrorCodes item=row %]
                                <tr>
                                    <td>[% $row['errorcode'] %]</td>
                                    <td>[% $row['articleno'] %]</td>
                                    <td>
                                        [% if $user->language_type == 'de' %]
                                            [% $row['descr_de'] %]
                                        [% else %]
                                            [% $row['descr_en'] %]
                                        [% /if %]
                                    </td>
                                    <td data-sort="[% $row['createdate'] %]">[% $row['createdate']|date_format:"%d.%m.%Y" %]</td>
                                    <td data-sort="[% $row['active'] %]">
                                        [% if $row['active'] %]
                                            <span class="fa fa-check"></span>
                                        [% else %]
                                            <span class="fa fa-times"></span>
                                        [% /if %]
                                    </td>
                                    <td>
                                        <a href="index.php?module=errorpatterns&class=errorcodes&event=edit&ec=[% $row['errorcode'] %]" class="btn btn-sm btn-outline-secondary" title="[% $user->gettext('Fehlercode bearbeiten') %]"><span class="fa fa-pencil"></span></a>
                                    </td>
                                </tr>
                            [% /foreach %]
                        </tbody>
                        <tfoot>

                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<script>
    $(document).ready(function () {

        table = $('#reportTable').DataTable({
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            }
        });
        var data = table.buttons.exportData({
            columns: ':visible'
        });

    });

    [% if $user->hasRight(1100) %]
    $('#activateEditing').on('change', function (e) {
        if ($('#activateEditing').is(':checked')) {
            $(".notEditable").addClass('editable').removeClass('notEditable');
            $.fn.editable.defaults.mode = 'inline';
            $(".editable").editable({
                emptytext: '___',
                success: function (response, newValue) {
                    if (!response.success)
                        return response.message;
                }
            });
        } else {
            $(".editable").addClass('notEditable');
            $(".editable").editable('destroy');
        }
    });

    $('.deleteErrorPattern').on('click', function (e) {
        PatternID = $(this).data('id');
        bootbox.confirm("[% $user->gettext('Möchten Sie das Fehlerbild wirklich gelöscht werden?') %]", function (result) {
            if (result) {

                $.ajax({
                    type: "POST",
                    url: "index.php?module=errorpatterns&event=deleteErrorPattern",
                    data: {PatternID: PatternID}
                }).done(function (response) {
                    if (response.error) {
                        noty({
                            text: response.message,
                            type: 'error',
                            timeout: notifyTimeout
                        });
                    } else {
                        noty({
                            text: response.message,
                            type: 'success',
                            timeout: notifyTimeout
                        });
                        $('.PatternRow_' + PatternID).remove();
                    }
                });
            }
        })
    })

    [% /if %]


    $('#showEN').on('change', function (e) {
        $('.en').toggle();
    })
    $('#showDE').on('change', function (e) {
        $('.de').toggle();
    })

    $('select').select2({theme: 'bootstrap-5'});
    $(".datepicker").datepicker();

    $('#CSVExport').on('click', function (e) {
        $('#export').val(1);
        $('#EPErrorCodesForm').submit();
    })

    $('#FilterActive').on('change', function (e) {
        $('#EPErrorCodesForm').submit();
    })

</script>
