<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

<style>
    .en, .de {
        display: block;
    }
    [% if $user->language_type == 'de' %]
        .en {
            display:none;
        }
    [% else %]
        .de {
            display:none;
        }
    [% /if %]

    .notEditable {
        text-decoration: none;
        color: inherit;
        cursor: default;
        pointer-events: none;

    }
</style>




<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <h2 class="card-title-fcs">[% $user->gettext('Fehlerbilder / Kriterien') %]</h2>
    </div>

    <div class="card-body">
        <div class="card panel-info shadow-sm rounded">
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-12">
                        <form action="" method="post" name="hm" id="EPReportForm" enctype="multipart/form-data" class="form-inline fcs-form-padding">

                            <input type="hidden" name="pos" id="pos" value="[% $pos %]" />
                            <input type="hidden" name="sort" id="sort" value="[% $sort %]" />
                            <input type="hidden" name="sortorder" id="sortorder" value="[% $sortorder %]" />
                            <input type="hidden" name="export" id="export" value="0" />

                            [% if $user->hasRight(1100) %]
                                <div class="form-group row mb-3">
                                    <div class="btn-group" data-toggle="buttons">
                                        <label class="btn btn-outline-secondary" >
                                            <input type="checkbox" id="activateEditing" autocomplete="off" > [% $user->gettext('Bearbeitung aktivieren') %]
                                        </label>
                                    </div>
                                </div>
                                <hr/>
                            [% /if %]

                            <div class="form-group row mb-3">
                                <label class="control-label">[% $user->gettext('Einträge mit Tickets') %]</label>
                                <input type="checkbox" id="FilterHasTicket" name="hasTicket" value="1" autocomplete="off" [% if $selectedFilters['hasTicket'] %]checked[% /if %]>
                            </div>

                            <div class="input-group">
                                <span class="input-group-text">
                                    [% $user->gettext('Tickets erstellt von')%]
                                </span>
                                <input type="text" class="form-control datepicker" id="startdate" name="startdate" value="[% $selectedFilters['startdate'] %]" onkeyup="keyEvent(event)" />
                                <span class="input-group-text">
                                    [% $user->gettext('bis')%]
                                </span>
                                <input type="text" class="form-control datepicker" id="enddate" name="enddate" value="[% $selectedFilters['enddate'] %]" onkeyup="keyEvent(event)" />
                            </div>

                            <hr/>
                     
                                <div class="form-group">
                                    <label  for="search">[% $user->gettext('Fehlerbild') %]</label>
                                    <select name="Filter[EP.ID][]" id="EP" class="form-control" multiple>
                                        <option vlaue="0">-- [% $user->gettext('Alle') %] --</option>
                                        [% html_options options=$FilterData['ErrorPattern'][$Lang] selected=$selectedFilters['EP.ID'] %]
                                    </select>
                                </div>
                 
                                <div class="form-group">
                                    <label  for="search">[% $user->gettext('Fehlerbeschreibung') %]</label>
                                    <select name="Filter[EPDescr.ID][]" id="EPDescr" class="form-control" multiple>
                                        <option vlaue="0">-- [% $user->gettext('Alle') %] --</option>
                                        [% html_options options=$FilterData['EPDescr'][$Lang] selected=$selectedFilters['EPDescr.ID'] %]
                                    </select>
                                </div>
                 
                                <div class="form-group">
                                    <label  for="search">[% $user->gettext('Fehlerobjekt') %]</label>
                                    <select name="Filter[EPObject.ID][]" id="EPObject" class="form-control" multiple>
                                        <option vlaue="0">-- [% $user->gettext('Alle') %] --</option>
                                        [% html_options options=$FilterData['EPObject'][$Lang] selected=$selectedFilters['EPObject.ID'] %]
                                    </select>
                                </div>
                         
                         
                                <div class="form-group">
                                    <label  for="search">[% $user->gettext('Hauptgruppe') %]</label>
                                    <select name="Filter[MainGroupClass.ID][]" id="MainGroupClass" class="form-control" multiple>
                                        <option vlaue="0">-- [% $user->gettext('Alle') %] --</option>
                                        [% html_options options=$FilterData['MainGroup'].$Lang selected=$selectedFilters['MainGroupClass.ID'] %]
                                    </select>
                                </div>
                            

                       
                                <div class="form-group">
                                    <label  for="search">[% $user->gettext('Untergruppe') %]</label>
                                    <select name="Filter[SubGroupClass.ID][]" id="SubGroupClass" class="form-control" multiple>
                                        <option vlaue="0">-- [% $user->gettext('Alle') %] --</option>
                                        [% html_options options=$FilterData['SubGroup'][$Lang] selected=$selectedFilters['SubGroupClass.ID'] %]
                                    </select>
                                </div>
                        
                                                         
                                    <input type='submit' class="btn btn-outline-secondary" value='[% $user->gettext('Filtern') %]'>                                
                         
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <div class="row">
                    <div class="col-lg-6 text-left" >
                        <h3 class="card-title text-left" style="font-size: 24px; display:inline">
                            [% $user->gettext('Auswertung')%]
                        </h3>
                        </span>
                    </div>
                    <div class="col-lg-6 text-end">

                        <div class="form-group row mb-3">
                            <span class="btn btn-outline-secondary" id="CSVExport"><span class="fa fa-download"></span> [% $user->gettext('CSV Export') %]</span>
                        </div>

                    </div>

                </div>
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table id="reportTable" class="table">
                        <thead>
                            <tr>
                                <th  data-export=" ">
                                    <div class="btn-group" data-toggle="buttons">
                                        <label class="btn btn-outline-secondary btn-sm [% if $user->language_type == 'de' %]active[% /if %]">
                                            <input type="checkbox" id="showDE" autocomplete="off" [% if $user->language_type == 'de' %]checked[% /if %] > DE
                                        </label>
                                        <label class="btn btn-outline-secondary btn-sm [% if $user->language_type == 'en' %]active[% /if %]">
                                            <input type="checkbox" id="showEN" autocomplete="off" [% if $user->language_type == 'en' %]checked[% /if %]> EN
                                        </label>
                                    </div>
                                </th>
                                <th>[% $user->gettext('Fehlerbild') %]</th>
                                <th width="20" data-export=" ">&nbsp;</th>
                                <th>[% $user->gettext('Tickets je Fehlerbild') %]</th>
                                <th>[% $user->gettext('Klassifikation Hauptgruppe') %]</th>
                                <th>[% $user->gettext('Tickets je Hauptgruppe') %]</th>
                                <th>[% $user->gettext('Klassifikation Untergruppe') %]</th>
                                <th>[% $user->gettext('Tickets je Untergruppe') %]</th>
                                <th>[% $user->gettext('Tickets je Klassifikation') %]</th>
                            </tr>
                        </thead>
                        <tbody>
                            [% foreach from=$reportData item=row %]
                                <tr  data-export=" " class="PatternRow_[% $row['errorpatternid'] %]">
                                    <td>
                                        <span class='de'>de</span>
                                        <span class='en'>en</span>
                                    </td>
                                    <td data-export="[% $row['epdescr_de'] %] [% $row['epprepo_de'] %] [% $row['epobject_de'] %]">
                                        <span class='de'>
                                            <a href="#" class="notEditable" title="[% $user->gettext('Fehlerbeschreibung bearbeiten') %]" data-type="text" data-pk="[% $row['epdescrid'] %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=descr&lang=de&id=[% $row['epdescrid'] %]" data-title="[% $user->gettext('Fehlerbeschreibung bearbeiten') %]">
                                                [% $row['epdescr_de'] %]
                                            </a>
                                            <a href="#" class="notEditable" title="[% $user->gettext('Präposition bearbeiten') %]" data-type="text" data-pk="[% $row['epprepoid'] %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=prepo&lang=de&id=[% $row['epprepoid'] %]" data-title="[% $user->gettext('Präposition bearbeiten') %]">
                                                [% $row['epprepo_de'] %]
                                            </a>
                                            <a href="#" class="notEditable" title="[% $user->gettext('Fehlerobjekt bearbeiten') %]" data-type="text" data-pk="[% $row['epobjectid'] %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=object&lang=de&id=[% $row['epobjectid'] %]" data-title="[% $user->gettext('Fehlerobjekt bearbeiten') %]">
                                                [% $row['epobject_de'] %]
                                            </a>
                                        </span>
                                        <span class='en'>
                                            <a href="#" class="notEditable" title="[% $user->gettext('Fehlerbeschreibung bearbeiten') %]" data-type="text" data-pk="[% $row['epdescrid'] %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=descr&lang=en&id=[% $row['epdescrid'] %]" data-title="[% $user->gettext('Fehlerbeschreibung bearbeiten') %]">
                                                [% $row['epdescr_en'] %]
                                            </a>
                                            <a href="#" class="notEditable" title="[% $user->gettext('Präposition bearbeiten') %]" data-type="text" data-pk="[% $row['epprepoid'] %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=prepo&lang=en&id=[% $row['epprepoid'] %]" data-title="[% $user->gettext('Präposition bearbeiten') %]">
                                                [% $row['epprepo_en'] %]
                                            </a>
                                            <a href="#" class="notEditable" title="[% $user->gettext('Fehlerobjekt bearbeiten') %]" data-type="text" data-pk="[% $row['epobjectid'] %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=object&lang=en&id=[% $row['epobjectid'] %]" data-title="[% $user->gettext('Fehlerobjekt bearbeiten') %]">
                                                [% $row['epobject_en'] %]
                                            </a>
                                        </span>
                                    </td>
                                    <td data-export=" ">
                                        [% if !$Tools->FCS_Count($Ticketcnt['EP'][$row['errorpatternid']]) %]
                                            <span class="btn btn-outline-secondary btn-xs deleteErrorPattern" data-id="[% $row['errorpatternid'] %]" title="[% $user->gettext('Fehlerbild löschen') %]" ><span class="fa fa-times"></span></span>
                                            [% /if %]
                                    </td>
                                    <td data-export="[% $Ticketcnt['EP'][$row['errorpatternid']] %]">
                                        <a href="index.php?module=ticketlist&ErrorPatternID[]=[% $row['errorpatternid'] %]" target="_blank">[% $Ticketcnt['EP'][$row['errorpatternid']] %]</a>
                                    </td>
                                    <td data-export="[% $row['maingroupdescr_de'] %]">
                                        [% if  $row['maingroupid'] %]
                                            <span class='de'>
                                                <a href="#" class="notEditable" title="[% $user->gettext('Klassifikation bearbeiten') %]" data-type="text" data-pk="[% $row['maingroupid'] %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=classi&lang=de&id=[% $row['maingroupid'] %]" data-title="[% $user->gettext('Klassifikation bearbeiten') %]">
                                                    [% $row['maingroupdescr_de'] %]</a>
                                            </span>
                                            <span class='en'>
                                                <a href="#" class="notEditable" title="[% $user->gettext('Klassifikation bearbeiten') %]" data-type="text" data-pk="[% $row['maingroupid'] %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=classi&lang=en&id=[% $row['maingroupid'] %]" data-title="[% $user->gettext('Klassifikation bearbeiten') %]">
                                                    [% $row['maingroupdescr_en'] %]
                                                </a>
                                            </span>
                                        [% /if %]
                                    </td>
                                    <td>
                                        <a href="index.php?module=ticketlist&ClassificationMGID[]=[% $row['maingroupid'] %]" target="_blank">[% $Ticketcnt['MainGroupClass'][$row['maingroupid']] %]</a>

                                    </td>
                                    <td  data-export="[% $row['subgroupdescr_de'] %]">
                                        [% if  $row['subgroupid'] %]
                                            <span class='de'>
                                                <a href="#" class="notEditable" title="[% $user->gettext('Klassifikation bearbeiten') %]" data-type="text" data-pk="[% $row['subgroupid'] %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=classi&lang=de&id=[% $row['subgroupid'] %]" data-title="[% $user->gettext('Klassifikation bearbeiten') %]">
                                                    [% $row['subgroupdescr_de'] %]</a>
                                            </span>
                                            <span class='en'>
                                                <a href="#" class="notEditable" title="[% $user->gettext('Klassifikation bearbeiten') %]" data-type="text" data-pk="[% $row['subgroupid'] %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=classi&lang=en&id=[% $row['subgroupid'] %]" data-title="[% $user->gettext('Klassifikation bearbeiten') %]">
                                                    [% $row['subgroupdescr_en'] %]
                                                </a>
                                            </span>
                                        [% /if %]
                                    </td>
                                    <td>
                                        <a href="index.php?module=ticketlist&ClassificationSGID[]=[% $row['subgroupid'] %]" target="_blank">[% $Ticketcnt['SubGroupClass'][$row['subgroupid']] %]</a>
                                    </td>
                                    <td>
                                        <a href="index.php?module=ticketlist&ClassificationMGID[]=[% $row['maingroupid'] %]&ClassificationSGID[]=[% $row['subgroupid'] %]" target="_blank">[% $Ticketcnt['ClassCombi'][$row['ClassCombi']] %]</a>
                                    </td>

                                </tr>
                            [% /foreach %]
                        </tbody>
                        <tfoot>

                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<script>
    $(document).ready(function () {

        table = $('#reportTable').DataTable({
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            }
        });
        var data = table.buttons.exportData({
            columns: ':visible'
        });

    });

    [% if $user->hasRight(1100) %]
    $('#activateEditing').on('change', function (e) {
        if ($('#activateEditing').is(':checked')) {
            $(".notEditable").addClass('editable').removeClass('notEditable');
            $.fn.editable.defaults.mode = 'inline';
            $(".editable").editable({
                emptytext: '___',
                success: function (response, newValue) {
                    if (!response.success)
                        return response.message;
                }
            });
        } else {
            $(".editable").addClass('notEditable');
            $(".editable").editable('destroy');
        }
    });

    $('.deleteErrorPattern').on('click', function (e) {
        PatternID = $(this).data('id');
        bootbox.confirm("[% $user->gettext('Möchten Sie das Fehlerbild wirklich gelöscht werden?') %]", function (result) {
            if (result) {

                $.ajax({
                    type: "POST",
                    url: "index.php?module=errorpatterns&event=deleteErrorPattern",
                    data: {PatternID: PatternID}
                }).done(function (response) {
                    if (response.error) {
                        noty({
                            text: response.message,
                            type: 'error',
                            timeout: notifyTimeout
                        });
                    } else {
                        noty({
                            text: response.message,
                            type: 'success',
                            timeout: notifyTimeout
                        });
                        $('.PatternRow_' + PatternID).remove();
                    }
                });
            }
        })
    })

    [% /if %]


    $('#showEN').on('change', function (e) {
        $('.en').toggle();
    })
    $('#showDE').on('change', function (e) {
        $('.de').toggle();
    })

    $('select').select2({theme: 'bootstrap-5'});
    $(".datepicker").datepicker();

    $('#CSVExport').on('click', function (e) {
        $('#export').val(1);
        $('#EPReportForm').submit();
        $('#export').val(0);
    })

    $('#FilterHasTicket').on('change', function (e) {
        if ($('#FilterHasTicket').is(':checked')) {
            $('#startdate, #enddate').removeAttr('disabled');
        } else {
            $('#startdate, #enddate').attr('disabled', 'disabled');
        }

    })

    if ($('#FilterHasTicket').is(':checked')) {
        $('#startdate, #enddate').removeAttr('disabled');
    } else {
        $('#startdate, #enddate').attr('disabled', 'disabled');
    }

</script>
