<script type="text/javascript">

    function switchPage(pos) {
        document.getElementById("pos").value = pos;
        submitForm();
    }

</script> 

<style>
    .table th{
        cursor: pointer;
    }
</style>
<form action="" method="post" name="hm" onsubmit="return false" id="hm" enctype="multipart/form-data" class="form-inline" >

    <input type="hidden" id="sort" name="sort" value="[% $sort %]" />
    <input type="hidden" id="sortorder" name="sortorder" value="[% $sortorder %]" />
    <div class="card panel-fcs-border shadow-sm">
        <div class="card-header">
            <span class="fcs-card-title h2">[% $user->gettext('Formulare') %]</span>
        </div>
        <div class="card-body">
            <div class="card panel-info shadow-sm rounded">
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group row mb-3">
                                <label class="control-label">
                                    [% $user->gettext('Eintr&auml;ge pro Seite') %]:
                                </label>
                                <select  name="entries_per_page" onchange="document.hm.submit();" class="form-control">
                                    <option value="10" [% if $entries_per_page == 10 %]selected="selected"[% /if %]>10</option>
                                    <option value="20" [% if $entries_per_page == 20 %]selected="selected"[% /if %]>20</option>
                                    <option value="50" [% if $entries_per_page == 50 %]selected="selected"[% /if %]>50</option>
                                    <option value="100" [% if $entries_per_page == 100 %]selected="selected"[% /if %]>100</option>
                                </select>&nbsp;&nbsp;&nbsp;
                                <input type="hidden" name="pos" value="[% $pos %]" id="pos">
                            </div>
                        </div>
                        <div class="col-lg-6 text-end">
                            [% if $user->hasRight(36) || $user->hasRight(810) %]
                                <div class="btn-group">
                                    <input type="button" class="btn btn-outline-primary" value="[% $user->gettext('Neues Formular') %]" onclick="document.location.href = 'index.php?module=formwizard&event=newFormular'">
                                </div>
                            [% /if %]         
                        </div>
                    </div>
                </div>
            </div>
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <span class="fcs-card-title h3">
                        [% $entries %]
                        [% if $entries > 1 %] 
                            [% $user->gettext('Eintr&auml;ge') %]
                        [% else %]
                            [% $user->gettext('Eintrag') %]
                        [% /if %]      
                    </span>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr class="fields>">
                                    <th class="sort" id="formname">[% $user->gettext('Formular') %]</th>
                                    <th class="sort" id="tablename">[% $user->gettext('Tabelle') %]</th>
                                    <th class="sort" id="categoryname">[% $user->gettext('Kategorie') %]</th>
                                    <th class="sort" id="ttshortdescr">[% $user->gettext('Ticketvorlage') %]</th>
                                    <th class="sort" id="published">[% $user->gettext('Freigabe') %]</th>
                                    <th class="sort" id="createdate">[% $user->gettext('Erstellt am') %]</th>
                                    <th class="sort" id="createusername">[% $user->gettext('Erstellt von') %]</th>
                                    <th class="sort" id="updatedate">[% $user->gettext('Aktualisiert am') %]</th>
                                    <th class="sort" id="updateusername">[% $user->gettext('Aktualisiert von') %]</th>
                                    <th>&nbsp;</th>
                                </tr>
                            </thead>
                            <tbody>
                                [% foreach from=$forms item=form %]
                                    <tr>
                                        <td>[% $form.formname %]</td>
                                        <td>[% $form.tablename %]</td>
                                        <td>[% $form.categoryname %]</td>
                                        <td>[% $form.ttshortdescr %]</td>
                                        <td class="center">
                                            [% if $form.published == 1 %]
                                                <span class="fa fa-check" style="color:green;"></span>
                                            [% else %]
                                                <span class="fa fa-times" style="color:red;"></span>
                                            [% /if %]
                                        </td>

                                        <td>[% $form.createdate|date_format:"%d.%m.%Y %H:%M" %]</td>
                                        <td>[% $form.createusername %] ([% $form.createname %])</td>
                                        <td>[% if $form.updatedate > 0 %][% $form.updatedate|date_format:"%d.%m.%Y %H:%M" %][% /if %]</td>
                                        <td>[% $form.updateusername %] ([% $form.updatename %])</td>

                                        <td style="text-align:center !important;">
                                            [% if $form.isempty %]
                                                <a href="index.php?module=formwizard&event=removeFormular&FormID=[% $form.formid %]" class="btn btn-outline-secondary openInBigIFrameModal"><span class="fa fa-trash" title="[% $user->gettext('L&ouml;schen') %]"></span></a>
                                                [% elseif $form.published == 1 %]                            
                                                <a href="index.php?module=formwizard&event=disableFormular&id=[% $form.formid %]" class="btn btn-outline-secondary openInBigIFrameModal"><span class="fa fa-times" title="[% $user->gettext('Das Formular enthält Daten - Deaktivieren') %]"></span></a>
                                                [% /if %]                            
                                            
                                            <a href="index.php?module=formwizard&event=viewFormular&fid=[% $form.formid %]" class="btn btn-outline-secondary openInLargeModal"><span class="fa fa-search" title="[% $user->gettext('Vorschau') %]"></span></a>
                                            
                                            <a href="index.php?module=formwizard&event=editFormular&id=[% $form.formid %]" class="btn btn-outline-secondary"><span class="fa fa-pencil" title="[% $user->gettext('Bearbeiten') %]"></span></a>
                                        </td>
                                    </tr>
                                [% foreachelse %]
                                    <tr class="even">
                                        <td colspan="9" style="text-align:center !important">[% $user->gettext('Es wurden keine Formulare gefunden...') %]</td>
                                    </tr>
                                [% /foreach %]
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

<div class="modal fade" id="removeModal" tabindex="-1" role="dialog" aria-labelledby="removeModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body modalContent">
                ...
            </div>
        </div>
    </div>
</div>

<script>

    function removeForm(formID) {
        $(".modalContent").load('index.php?module=formwizard&event=removeFormular&FormID=' + formID + ' ' + '#removeContent');
        $('#removeModal').modal('show');
    }

    function disableForm(formID) {
        $(".modalContent").load('index.php?module=formwizard&event=disableFormular&id=' + formID + ' ' + '#removeContent');
        $('#removeModal').modal('show');
    }
    var current_sort = $("#sort").val();
    var current_sortorder = $("#sortorder").val();

    showSortIcon();

    $(".sort").on("click", function (e) {
        var sort = $(this).attr('id');

        var sortorder = 'asc';
        if (current_sort === sort) {
            if (current_sortorder === 'asc') {
                sortorder = 'desc';
            } else {
                sortorder = 'asc';
            }
        }
        $("#sort").val(sort);
        $("#sortorder").val(sortorder);
        submitForm();
    })

    function showSortIcon() {
        var content = $("#" + current_sort).html();
        if (current_sortorder == 'desc') {
            content += '<span class="fa fa-chevron-down"></span>';

        } else {
            content += '<span class="fa fa-chevron-up"></span>';
        }
        $("#" + current_sort).html(content);
    }
    
    function closeTicketFromIframe() {
        $("#myBigIFrameModal").modal('hide');
        window.location.href = window.location.href;
    }
</script>
