<script>
    function switchPage(page) {
        document.getElementById('pos').value = page;
        submitForm();
    }
</script>

<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <div class="row">
            <div class="col-sm-6">
                <span class="fcs-card-title h2">[% $user->gettext('Mandanten') %]</span>
            </div>
            <div class="col-sm-6 text-end">
                <div class="btn-group">
                    [% if $user->hasRight(850) %]
                        <input type="button" onclick="window.location.href = 'index.php?module=mandant&event=edit';" value="[% $user->gettext('Neuer Mandant') %]" class="btn btn-outline-primary lightContrast" />
                        <input type="button" onclick="window.location.href = 'index.php?module=mandant&event=importFromAssetDesk';" value="[% $user->gettext('Mandanten aus Asset.Desk importieren') %]" class="btn btn-outline-primary lightContrast" />
                    [% /if %]
                </div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <form action="" method="post" name="hm" onsubmit="return false;" id="hm" class="form-horizontal form-label-left">

            <input type="hidden" name="pos" id="pos" value="[% $pos %]" />
            <input type="hidden" name="sort" id="sort" value="[% $sort %]" />
            <input type="hidden" name="sortorder" id="sortorder" value="[% $sortorder %]" />


            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <h3 class="card-title">[% $entries %] [% $user->gettext('Einträge') %]</h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover" id="MandantList" >
                            <thead>

                                <tr>
                                    <th>
                                        [% $user->gettext('Mandant') %]
                                    </th>
                                    [% if $AssetDesk %]
                                        <th>
                                            [% $user->gettext('Buchungskreis') %]
                                        </th>
                                    [% /if %]
                                    <th>
                                        [% $user->gettext('Absenderadresse') %]
                                    </th>
                                    <th>
                                        [% $user->gettext('Erstellt am') %]
                                    </th>
                                    <th>
                                        [% $user->gettext('Zuletzt ge&auml;ndert am') %]
                                    </th>
                                    <th>
                                        [% $user->gettext('Anz. Kontakte') %]
                                    </th>
                                    [% if $show_deactives %]
                                        <th>[% $user->gettext('Status') %]</th>
                                        [% /if %]
                                    <th>[% $user->gettext('Aktion') %]</th>
                                </tr>
                            </thead>
                            <tbody>
                                [% foreach from=$Mandanten item=Mandant %]
                                    <tr>
                                        <td>[% $Mandant.mandant %]&nbsp;</td>
                                        [% if $AssetDesk %]
                                            <td>[% $Mandant.companycode %]</td>
                                        [% /if %]
                                        <td>[% $Mandant.sendfromadress %]</td>
                                        <td>[% if $Mandant.created %][% $Mandant.created|date_format:"%d.%m.%Y %H:%M" %][% /if %]&nbsp;</td>
                                        <td>[% if $Mandant.updated %][% $Mandant.updated|date_format:"%d.%m.%Y %H:%M" %][% /if %]&nbsp;</td>
                                        <td>
                                            <a href="index.php?module=contact&mandantid=[% $Mandant.id %]" target="_blank">[% $Mandant.cntcontacts %]</a>
                                        </td>
                                        [% if $show_deactives %]
                                            <td>[% if $Mandant.published == 1 %] [% $user->gettext('Aktiv') %] [% else %] [% $user->gettext('Deaktiviert') %] [% /if %]</td>
                                        [% /if %]
                                        <td>
                                            [% if $Mandant.id %]
                                                <div class="btn-group">
                                                    <a href="index.php?module=mandant&event=edit&id=[% $Mandant.id %]" title="[% $user->gettext('Bearbeiten') %]" class="btn btn-outline-secondary"><span class="fa fa-pencil"></span></a>
                                                        [% if $Mandant.cntcontacts == 0 %]
                                                        <a href="javascript:check('[% $Mandant.mandant %]', 'index.php?module=mandant&event=delete&id=[% $Mandant.id %]&show_deactives=[% if $show_deactives %]1[% else %]0[% /if %]')" title="[% $user->gettext('Löschen') %]" class="btn btn-outline-secondary"><span class="fa fa-times"></span></a>
                                                        [% /if %]
                                                </div>

                                            [% /if %]
                                        </td>
                                    </tr>
                                [% foreachelse %]
                                    <tr class="even">
                                        <td colspan="8">[% $user->gettext('Es wurden keine Mandanten gefunden') %]</td>
                                    </tr>
                                [% /foreach %]

                            </tbody>

                            <tfoot>
                                <tr>
                                    <td colspan="15">
                                        [% $Paging %]
                                    </td>
                                </tr>
                            </tfoot>

                        </table>
                    </div>
                </div>
            </div>
    </div>
</div>

</form>
<script>
    function check(Name, url) {
        bootbox.confirm('[% $user->gettext('Mandant ') %] <strong>' + Name + '</strong> [% $user->gettext('wirklich löschen?') %]', function (result) {
            if (result) {
                window.location.href = url;
            }
        })
    }
</script>
