
<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h2">[% $user->gettext('Benutzerrechte') %]</span>
    </div>

    <div class="card-body">


        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <div class="row">
                    <div class="col-sm-6">
                        <span class="fcs-card-title h4">[% $user->gettext('Benutzerrechte') %]</span>
                    </div>
                    <div class="col-sm-6 text-end">
                        <span class="btn btn-outline-secondary"><a href="index.php?module=reporting&class=userrightreport&event=userGroups" target="_top">[% $user->gettext('Nur Gruppen') %]</a></span>
                        <span class="btn btn-outline-secondary active"><a href="index.php?module=reporting&class=userrightreport&event=justUsers" target="_top">[% $user->gettext('Ohne Gruppen') %]</a></span>                        
                        <span class="btn btn-outline-secondary"><a href="index.php?module=reporting&class=userrightreport" target="_top">[% $user->gettext('Mit Gruppen') %]</a></span>
                        <span class="btn btn-outline-secondary"><a href="index.php?module=reporting&class=userrightreport&event=GroupRightMatrix" target="_top">[% $user->gettext('Gruppenrechte') %]</a></span>
                        
<span class="btn btn-outline-secondary"><a href="index.php?module=reporting&class=userrightreport&event=justUsers&excel" target="_blank">Excel</a></span>
                        
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class='table-responsive' style="max-height: 80vh;">
                    <table class='table table-bordered'>
                        <thead>
                            <tr>

                                <th>Recht</th>
                                    [% foreach from=$Users item=User %]
                                    <th>[% $User.Name %]</th>
                                    [% /foreach %]
                            </tr>
                        </thead>

                        [% foreach from=$Rights item=Right key=RightID %]   

                            <tr>

                                <td>[% $Right.rightname %]</td>

                                [% foreach from=$Users item=User %]
                                    <td>[% if $User.Rights.$RightID %]x[% else %]&nbsp;[% /if %]</td>
                                [% /foreach %]

                            </tr>
                        [% /foreach %]
                    </table>
                </div>


            </div>
        </div>
    </div>
</div>


<script>
    $(document).ready(function () {
        $('.tableAA').DataTable({
            dom: 'Bfrtip',
            buttons: [
//                'colvis',
                'excel',
                'print',
                'pdfHtml5'
            ],
            "paging": false,
            searching: true,
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 400,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                }
            }
        });
    })
</script>
