
<script language="JavaScript" src="modules/reporting/javascript/reporting.js" type="text/JavaScript"></script>

<script type="text/javascript" src="includes/js/bs_DataTables/datatables.min.js"></script>
<link rel="stylesheet" type="text/css" href="includes/js/bs_DataTables/datatables.min.css" media="screen" />    

<form  action="index.php?module=reporting&event=CatReport" method="post" name="HM-Form-Report" id="HM-Form-Report" enctype="multipart/form-data" class="form-inline">
    <input type="hidden" name="pos" id="pos" value="[% $pos %]" />
    <input type="hidden" name="sorting" id="sorting" value="[% $sorting %]" />
    <input type="hidden" name="sortOrder" id="sortOrder" value="[% $sortOrder %]" />
    <input type="hidden" name="action" id="action" value="" />
    <input type="hidden" name="utf8" id="utf8" value="0" />
    <input type="hidden" name="renewCache" id="renewCache" value="0" />

    <div class="card panel-fcs-border shadow-sm">
        <div class="card-header">
            <span class="fcs-card-title h2">[%$user->gettext('Kategoriereport')%]</span>
        </div>
        <div class="card-body">
            <div class="card panel-info shadow-sm rounded">
                <div class="card-body">
                    <div class="form-group">
                        <label class="control-label">[% $user->gettext('Von') %]:</label>
                        <input type="text" class="form-control datepicker" value="[% $smarty.session.CatReport.startdate %]" name="startdate" id="startdate" onkeyup="keyEvent(event)" />
                    </div>

                    <div class="form-group">
                        <label class="control-label">[% $user->gettext('Bis') %]:</label>
                        <input type="text" class="form-control datepicker" value="[% $smarty.session.CatReport.enddate %]" name="enddate" id="enddate" onkeyup="keyEvent(event)" />
                    </div>

                    <div class="form-group">
                        <select class="form-control" name="period" onchange="changePeriod(this);">
                            <option value="0" selected="selected">[% $user->gettext('Zeitraum') %]</option>
                            <option value="99" >[% $user->gettext('Heute') %]</option>
                            <option value="1" >[% $user->gettext('Gestern') %]</option>
                            <option value="2" >[% $user->gettext('Letzte Woche') %]</option>
                            <option value="3" >[% $user->gettext('Letzten Monat') %]</option>
                            <option value="4" >[% $user->gettext('Letztes Jahr') %]</option>
                            <option value="5" >[% $user->gettext('Aktuelles Jahr') %]</option>
                            [% if $timing_add %]
                                [% foreach from=$timing_add key=k item=v %]
                                    <option value="[% $v.id %]">[% $k %]</option>
                                [% /foreach %]
                            [% /if %]
                        </select>
                    </div>

                    <input type="button" value="[% $user->gettext('Anzeigen') %]" class="btn btn-outline-primary" onclick="setAction('');
                            $('#HM-Form-Report').submit();"/>
                </div>
            </div>

            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <span class="fcs-card-title h3">[%$user->gettext('Supporter - Aktivitäten')%]</span>
                        </div>
                        <div class="col-lg-6 text-end">
                            <div class="btn-group">
                                <input type="submit" name="Export" class="btn btn-outline-primary" value="Export" />        
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    
                        <table class="table table-striped datatable" id="SupporterTable" cellspacing="0" border="0">
                            <thead>
                                <tr>
                                    <td>[%$user->gettext('Kategorie 1')%]</td>

                                    <td>[%$user->gettext('Kategorie 2')%]</td>
                                    <td>[%$user->gettext('Anzahl geöffnet')%]</td>
                                    <td>[%$user->gettext('Anzahl geschlossen')%]</td>

                                    <td title="[%$user->gettext('Anzahl Eskalationsstufe 0')%]">[%$user->gettext('Eskal.-Stufe 0')%]</td>
                                    <td title="[%$user->gettext('Anzahl Eskalationsstufe 1')%]">[%$user->gettext('Eskal.-Stufe 1')%]</td>
                                    <td title="[%$user->gettext('Anzahl Eskalationsstufe 2')%]">[%$user->gettext('Eskal.-Stufe 2')%]</td>
                                    <td title="[%$user->gettext('Anzahl Eskalationsstufe 3')%]">[%$user->gettext('Eskal.-Stufe 3')%]</td>
                                    <td title="[%$user->gettext('Anzahl Eskalationsstufe 4')%]">[%$user->gettext('Eskal.-Stufe 4')%]</td>
                                    <td title="[%$user->gettext('Anzahl Eskalationsstufe 5')%]">[%$user->gettext('Eskal.-Stufe 5')%]</td>                                        
                                </tr>
                            </thead>
                            <tbody>
                                [% foreach from=$Report item=Column %]

                                    <tr>
                                        <td>[% $Column.kategorie1|default:"-- Ohne --" %]</td>
                                        <td>[% $Column.kategorie2|default:"-- Ohne --" %]</td>
                                        <td>[% $Column.cntopen|default:"0"  %]</td>
                                        <td>[% $Column.cntclosed|default:"0" %]</td>
                                        <td>[% $Column.cntesc0|default:"0" %]</td>
                                        <td>[% $Column.cntesc1|default:"0" %]</td>
                                        <td>[% $Column.cntesc2|default:"0" %]</td>
                                        <td>[% $Column.cntesc3|default:"0" %]</td>
                                        <td>[% $Column.cntesc4|default:"0" %]</td>
                                        <td>[% $Column.cntesc5|default:"0" %]</td>
                                    </tr>
                                [% /foreach %]
                            </tbody>
                        </table>
                    
                </div>
            </div>
        </div>
    </div>
</form>


<script>


    function changePeriod(element) {

        var value = element.options[element.selectedIndex].value;
        var startdate = document.forms['HM-Form-Report'].elements['startdate'];
        var enddate = document.forms['HM-Form-Report'].elements['enddate'];
        var now = new Date();
        var Tag = now.getDate();
        var Monat = now.getMonth();

        if (value == 99) {
            startdate.value = "[% $today %]";
            enddate.value = startdate.value;
        } else if (value == 1) {
            startdate.value = "[% $yesterday %]";
            enddate.value = startdate.value;
        } else if (value == 2) {
            startdate.value = "[% $lastweek %]";
            enddate.value = "[% $today %]";
        } else if (value == 3) {
            startdate.value = "[% $lastmonth_start %]";
            enddate.value = "[% $lastmonth_end %]";
        } else if (value == 4) {
            startdate.value = "[% $lastyear_start %]";
            enddate.value = "[% $lastyear_end %]";
        } else if (value == 5) {
            startdate.value = "[% $currentyear_start %]";
            enddate.value = "[% $currentyear_end %]";
        }
    [% if $timing_add %]
        [% foreach from=$timing_add item=timing2 %]
        else if (value == [% $timing2.id %]) {

            startdate.value = "[% $timing2.start %]";
            enddate.value = "[% $timing2.end %]";
        }
        [% /foreach %]
    [% /if %]
    }

    $('#PrintButton').on("click", function () {
        setAction('print');
        $form = $("#HM-Form-Report");
        $.fancybox({
            'title': 'Druckansicht',
            'href': $form.attr("action") + "&" + $form.serialize(),
            'type': 'iframe'
        });
        return false;
    })


    $('.datatable').dataTable({
        /*
         "sPaginationType": "full_numbers",
         "bLengthChange": true,
         "paging": false,
         "aLengthMenu": [
         [10, 50,-1],
         [25, 50,"All"]
         ],
         "iDisplayLength": -1                            
         */
        stateSave: true,
        "sPaginationType": "full_numbers",
        "bLengthChange": true,
        "iDisplayLength": 50,
        "oLanguage": {
            "sLengthMenu": "Zeige _MENU_ Eintr&auml;ge",
            "sZeroRecords": "Keine Eintr&auml;ge gefunden",
            "sInfo": "Eintrag _START_ bis _END_ (von _TOTAL_)",
            "sInfoEmpty": " ",
            "sInfoFiltered": " - gefiltert aus _MAX_ Eintr&auml;gen",
            "sSearch": "Filter",
            "oPaginate": {
                "sFirst": "&lt;&lt;",
                "sLast": "&gt;&gt;",
                "sNext": "&gt;",
                "sPrevious": "&lt;"
            }
        }
    });



</script>
