<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

<style>
    .diffCol {
        color:  green;
    }    
    .importError {
        color:red;
    }
    .importSuccess{
        color:green;
    }
</style>
<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h2">[% $user->gettext('Ticketimport') %]</span>
    </div>
    <div class="card-body">

        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <span class="fcs-card-title h3">[% $user->gettext('Zammad Import') %]

            </div>
            <div class="card-body">


                <form action="index.php?module=ticket&class=importTickets" method="post" class="form form-horizontal">
                    <div class="row">
                        <div class="col-sm-6">
                            <input type="text" class="form-control" name="target" placeholder="Verzeichnis der Zammad-Tickets" value="[% $target %]">    
                            <span class="help-block">Achtung: Erfolgreich verarbeitete Tickets werden aus dem Verzeichnis gelöscht. Kopieren Sie die Quelldateien in ein Arbeitsverzeichnis</span>
                        </div>
                        <div class="col-sm-6">
                            [% if !$Tickets %]
                                <button class="btn btn-outline-primary">Lade Tickets</button>
                            [% else %]
                                <span id="startImport" class="btn btn-outline-primary">Starte Import</span>
                                <span id="importLaeuft" style="display:none;width:10em;"></span>
                                <span class="btn btn-outline-primary" id="zeigeFehler">Zeige nur Import-Fehler</span>
                                <span class="btn btn-outline-primary" id="zeigeAlle" style="display:none;">Zeige alle</span>                        
                            [% /if %]                        
                        </div>                   
                    </div>
                </form>

                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-sm">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Zammad ID</th>
                                <th>Titel</th>
                                <th>Status</th>
                                <th>Anzahl Events</th>
                                <th>Messages</th>

                            </tr>
                        </thead>
                        <tbody>

                            [% foreach from=$Tickets item=Ticket key=csvKey %]
                                <tr id="itemRow_[% $Ticket.id %]" class="importTicket">
                                    <td><span id="item_[% $Ticket.id %]" class="fa fa-minus"></span></td>
                                    <td>[% $Ticket.id %]</td>
                                    <td>[% $Ticket.title %]</td>
                                    <td>[% $Ticket.status  %]</td>
                                    <td>[% $Ticket.cntEvents   %]</td>
                                    <td id="mess_[% $Ticket.id %]"></td>
                                </tr>
                            [% /foreach %]
                        </tbody>
                    </table>
                </div>       
            </div>
        </div>
    </div>
</div>



<script>
    [% if $jsonIDs %]
    jsonIDs = [% $jsonIDs %];
    [% /if %]

    $(document).ready(function () {

        $('#startImport').on("click", function (e) {
            importFirstSelectedDevice(0);


            $('#startImport').hide();
            $('#importLaeuft').show();
        })



        $('#zeigeFehler').on("click", function (e) {
            $('.importTicket.success').hide();
            $('#zeigeFehler').hide();
            $('#zeigeAlle').show();

        })

        $('#zeigeAlle').on("click", function (e) {
            $('.importTicket.success').show();
            $('#zeigeAlle').hide();
            $('#zeigeFehler').show();
        })



        /**
         * Comment
         */
        function importFirstSelectedDevice(index) {
            if (typeof jsonIDs[index] !== "undefined") {
                zid = jsonIDs[index];
                console.log(jsonIDs[index]);

                $.post("index.php?module=ticket&class=importTickets&event=getZammadData&zid=" + zid, function (data) {


                }).done(function (data) {

                    $('#importLaeuft').html(index + 1 + "\t von " + jsonIDs.length + " Tickets importiert");
                    console.log(data);

                    $('#item_' + zid).removeClass('fa-minus');
                    if (data.error) {
                        $('#item_' + zid).addClass('fa-flag');
                    } else {
                        $('#item_' + zid).addClass('fa-check');
                        $('#itemRow_' + zid).addClass('success');
                    }
                    markup = '';
                    $.each(data.messages, function (i, item) {
                        markup += item + "<br/>";
                    })
                    $('#mess_' + zid).html(markup);

                    delete jsonIDs[index];
                    importFirstSelectedDevice(index + 1);

                });

            } else {
                console.log("Fertig!");
            }
        }
    })
</script>
