<!DOCTYPE html>
<html lang="de">
<head>    
    <title>Excel Export</title>

    <!-- Dein Stylesheet -->
    <link rel="stylesheet" href="styles/[% $CSSTEMPLATE %]/css/screen.css">

    <script src="includes/js/ajax.js"></script>
    <script>
        var percent = 0;
        var pos     = -1;
        var gesammt = [% $cnt %];

        function showStatus() {
            pos++;
            const url = "index.php?module=ticketlist&event=xmlExcelExport&pos=" + pos;
            makeHttpRequest(url, "updateProgressbar", false);
        }

        function updateProgressbar(xmldoc) {
            percent = parseInt(xmldoc);
            const bar = document.getElementById("progress");
            const val = document.getElementById("progressvalue");
            const counter = document.getElementById("Zaehler");

            if (percent !== 999) {
                val.textContent = percent + "%";
                bar.style.width = percent + "%";
                counter.textContent = Math.ceil((gesammt / 100) * percent) + " / " + gesammt;

                if (percent < 100) {
                    showStatus();
                } else {
                    document.getElementById("finalize").classList.remove("d-none");
                }
            } else {
                val.textContent = "0%";
                bar.classList.add("bg-danger");
                bar.style.width = "100%";
            }
        }
    </script>

    <style>
        body {
            background: #fff !important;
        }
        .progress {
            height: 24px;
        }
    </style>
</head>
<body onload="[% if $closing %][% else %]showStatus();[% /if %]">

<div class="container py-5">
    <div class="card shadow-sm border-primary">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">
                <i class="fas fa-file-excel"></i> [% $user->gettext('Export') %]
            </h5>
        </div>
        <div class="card-body">

            <p class="mb-3">[% $user->gettext('Bitte warten Sie, während die Datei generiert wird...') %]</p>

            <div class="mb-3">
                <div class="progress">
                    <div class="progress-bar progress-bar-striped progress-bar-animated bg-success" id="progress" role="progressbar" style="width: 0%"></div>
                </div>
                <div class="mt-2 d-flex justify-content-between">
                    <span id="progressvalue">0%</span>
                    <span id="Zaehler">0 / [% $cnt %]</span>
                </div>
            </div>

            <div id="finalize" class="mt-4 d-none text-center">
                <a href="index.php?module=ticketlist&event=xmlExcelExport&finish=2" class="btn btn-success">
                    <i class="fas fa-download"></i> [% $user->gettext('Download .csv Datei') %]
                </a>
            </div>

        </div>
    </div>
</div>

</body>
</html>
