<div class="table-responsive">
    
    <table class="table table-striped table-hover" id="WarrantyProcessingWagePositionTable" >
        <thead>
            <tr>
                <th></th>
                <th>[% $user->gettext('Art') %]</th>
                <th>[% $user->gettext('Beschreibung') %]</th>                
                <th>[% $user->gettext('Anzahl') %]</th>
                <th>[% $user->gettext('Einzelpreis') %]</th>
                <th>[% $user->gettext('Gesamtpreis') %]</th>
                <th>[% $user->gettext('Kundenbezeichnung') %] 1</th>
                <th>[% $user->gettext('Kundenbezeichnung') %] 2</th>
                <th>[% $user->gettext('Kundenbezeichnung') %] 3</th>
                <th>[% $user->gettext('Kundenbezeichnung') %] 4</th>   
            </tr>
        </thead>
        <tbody>
            [% foreach from=$WarrantyProcessingWagePositions item=WarrantyProcessingWagePosition key=fcsUniqID %]
            <tr id="WageRow_[% $WarrantyProcessingWagePosition.fcsUniqID %]">
                <td><span class="btn btn-sm btn-outline-secondary" id="Wage_[% $WarrantyProcessingWagePosition.fcsUniqID %]" onclick="SaveWagePositions(this)"><span class="fa fa-plus" ></span> </span></td>
                <td>[% $WarrantyProcessingWagePosition.Type %]</td>
                <td>[% if $WarrantyProcessingWagePosition.TypeID == 4 %]<input type="text" class="form-control" maxlength="20" id="Description_[% $WarrantyProcessingWagePosition.fcsUniqID %]" />[% else %][% $WarrantyProcessingWagePosition.Description %][% /if %]</td>
                <td><input type="text" id="Amount_[% $WarrantyProcessingWagePosition.fcsUniqID %]" class="form-control" value="1" min="0" step="0.01" oninput="filterInput(this); CalculatePrice(this);" style="width:6em"></td>
                <td><span id="tdUnitPrice_[% $WarrantyProcessingWagePosition.fcsUniqID %]" data-unitprice="[% $WarrantyProcessingWagePosition.UnitPrice %]" class="formatPrice[% $WarrantyProcessingWagePosition.CurrencyCode|default:'EURO' %]">[% $WarrantyProcessingWagePosition.UnitPrice %]</span></td>
                <td><span id="tdPrice_[% $WarrantyProcessingWagePosition.fcsUniqID %]" class="formatPrice[% $WarrantyProcessingWagePosition.CurrencyCode|default:'EURO' %]">[% $WarrantyProcessingWagePosition.UnitPrice %]</span></td>
                
                [% if $WarrantyProcessingWagePosition.TypeID == 1 || $WarrantyProcessingWagePosition.TypeID == 2  || $WarrantyProcessingWagePosition.TypeID == 3 %]
                <td><input type="text" class="form-control" maxlength="20" lenght="20" id="AdditionalInformation1_[% $WarrantyProcessingWagePosition.fcsUniqID %]" placeholder="[% $user->gettext('Zusätzliche Informationen') %]"></td>
                <td><input type="text" class="form-control" maxlength="20" lenght="20" id="AdditionalInformation2_[% $WarrantyProcessingWagePosition.fcsUniqID %]" placeholder="[% $user->gettext('Kundenbezeichnung') %] 2"></td>
                <td><input type="text" class="form-control" maxlength="20" lenght="20" id="AdditionalInformation3_[% $WarrantyProcessingWagePosition.fcsUniqID %]" placeholder="[% $user->gettext('Kundenbezeichnung') %] 3"></td>
                <td><input type="text" class="form-control" maxlength="20" lenght="20" id="AdditionalInformation4_[% $WarrantyProcessingWagePosition.fcsUniqID %]" placeholder="[% $user->gettext('Kundenbezeichnung') %] 4"></td>
                [% /if %]

                [% if $WarrantyProcessingWagePosition.TypeID == 4 %]
                <td></td>
                <td><input type="text" class="form-control" maxlength="20" lenght="20" id="AdditionalInformation2_[% $WarrantyProcessingWagePosition.fcsUniqID %]" placeholder="[% $user->gettext('Rechnungsnummer') %] 2"></td>
                <td><input type="text" class="form-control" maxlength="20" lenght="20" id="AdditionalInformation3_[% $WarrantyProcessingWagePosition.fcsUniqID %]" placeholder="[% $user->gettext('Kundenbezeichnung') %] 3"></td>
                <td><input type="text" class="form-control" maxlength="20" lenght="20" id="AdditionalInformation4_[% $WarrantyProcessingWagePosition.fcsUniqID %]" placeholder="[% $user->gettext('Kundenbezeichnung') %] 4"></td>
                [% /if %]
            </tr>
                [% /foreach %]
        </tbody>
    </table>

</div>
<script>

    var WagePositionListJson = [% $WagePositionListJson %];


    function filterInput(input) {

        // Optional: Konvertiere Kommas zu Punkten, falls einheitliche Dezimaltrennzeichen gewünscht sind
    input.value = input.value.replace(',', '.');

    // Entferne alle ungültigen Zeichen
        input.value = input.value.replace(/[^0-9.,]/g, '');

    // Sicherstellen, dass nur ein Punkt oder Komma vorhanden ist
    if ((input.value.match(/[.]/g) || []).length > 1) {
        // Entferne zusätzliche Punkte oder Kommas, indem nur das erste Zeichen behalten wird
        input.value = input.value.substring(0, input.value.lastIndexOf(/[.]/));
    }

}

    function CalculatePrice(elem)
    {
        var FieldID = $(elem).attr("id").replace('Amount_', '');
        Amount = $('#Amount_'+FieldID).val();

        if(Amount < 0 || isNaN(Amount)){
            $('#Amount_'+FieldID).val(0);
            Amount = 0;
        }

        var unitPrice = parseFloat($('#tdUnitPrice_' + FieldID).data('unitprice')).toFixed(2);
//        var Currency = $("#tdUnitPrice_" + FieldID).html().replace(/[0-9. ]/g, '');
        var Currency = $("#tdUnitPrice_" + FieldID).text().replace(/[\d.,\s\u00A0]/g, '');

        var currencyCode = Currency === '€' ? 'EUR' : 'USD'; // Beispiel: 'USD' oder 'EUR (statt EURO)'

        var formatOptions = { style: 'currency', currency: currencyCode };

        var Price = parseFloat(Amount * unitPrice).toFixed(2);
        let formattedPrice = (Currency === '$') ? (Currency + Price) : (Price + " " + Currency);
        $('#tdPrice_' + FieldID).html(new Intl.NumberFormat(currencyCode === 'USD' ? 'en-US' : 'de-DE', formatOptions).format(Price));
    }


    function SaveWagePositions(elem) {
    FCSUniqID = $(elem).attr("id").replace('Wage_', '');;
    WagePosition = WagePositionListJson[FCSUniqID];

var selectedWagePosition ={} ;
selectedWagePosition.fcsUniqID = FCSUniqID;
selectedWagePosition.isWagePosition = true;
selectedWagePosition.InvoiceNumber = '';
selectedWagePosition.InvoicNo2 =  '';
selectedWagePosition.RowNo =  '';
selectedWagePosition.Anzahl = $('#Amount_' + FCSUniqID).val();
selectedWagePosition.Amount =  $('#Amount_'+FCSUniqID).val(); 
selectedWagePosition.InvoiceDate =  '';
selectedWagePosition.Classification =  '';
selectedWagePosition.ErrorPattern =  '';
selectedWagePosition.Artikel =  WagePosition.ArtikelNumber;
selectedWagePosition.Einzelpreis = WagePosition.UnitPrice;
selectedWagePosition.Gesamtpreis = selectedWagePosition.Amount * WagePosition.UnitPrice;

selectedWagePosition.Beschreibung = WagePosition.Description;
selectedWagePosition.WährungsBez =  WagePosition.CurrencyCode;
selectedWagePosition.Kundenbezeichnung1 = $('#AdditionalInformation1_'+FCSUniqID).val();
selectedWagePosition.Kundenbezeichnung2 = $('#AdditionalInformation2_'+FCSUniqID).val();
selectedWagePosition.Kundenbezeichnung3 = $('#AdditionalInformation3_'+FCSUniqID).val();
selectedWagePosition.Kundenbezeichnung4 = $('#AdditionalInformation4_'+FCSUniqID).val();
if($('#Description_'+FCSUniqID).val())
    selectedWagePosition.Kundenbezeichnung1 = $('#Description_'+FCSUniqID).val();

selectedWagePosition.Position = 1;
selectedWagePosition.Serials =  '';
console.log(selectedWagePosition);


var currencyCode = selectedWagePosition.WährungsBez === 'EURO' ? 'EUR' : selectedWagePosition.WährungsBez; // Beispiel: 'USD' oder 'EUR (statt EURO)'

var formatOptions = { style: 'currency', currency: currencyCode };

        if (FCSUniqID in addedPositionObjects){
            alert("Arbeitskosten " + selectedWagePosition.Description + " bereits zugefügt");
            return false;
        }
        
        var html = '<tr id="TableRowForPosition_' + FCSUniqID + '"><td>' + selectedWagePosition.Artikel + '</td><td>' + selectedWagePosition.Beschreibung + '</td><td>' + selectedWagePosition.Amount + '</td>';

        html += '<td>' + new Intl.NumberFormat(currencyCode === 'USD' ? 'en-US' : 'de-DE', formatOptions).format(selectedWagePosition.Einzelpreis) + ' </td>';
        html += '<td>' + new Intl.NumberFormat(currencyCode === 'USD' ? 'en-US' : 'de-DE', formatOptions).format(selectedWagePosition.Gesamtpreis) + ' </td>';

        html += "<td></td>";
        html += '<td></td>';
        html += "<td></td>";
        html += "<td></td>";
        html += "<td></td>";
        html += '<td>' + selectedWagePosition.Kundenbezeichnung1 + '<br/>';
        html +=  selectedWagePosition.Kundenbezeichnung2+"<br/>";
        html +=  selectedWagePosition.Kundenbezeichnung3+"<br/>";
        html +=  selectedWagePosition.Kundenbezeichnung4 + "</td>";


//        html += '<td><div id="WPPositionDropzoneField_' + FCSUniqID + '" class="well dz-clickable" style="padding:0px; border: solid 1px; border-color:cornflowerblue"><div class="dz-message"><h4>  Datei-Upload</h4></div></div></td>';
        html += '<td><div class="btn-group"><a id="ShowDocuments_' + FCSUniqID + '" href="javascript:ShowInvoicePositionDocuments(\'' + FCSUniqID + '\')" title="Dokumente anzeigen" class="btn btn-outline-primary disabled"><span class="fa fa-file"></span></a><a href="javascript:DeletePositionFromSelection(\'' + FCSUniqID + '\', \'9\')" title="Löschen" class="btn btn-outline-primary"><span class="fa fa-remove"></span></a></div></td>';
        html += '</tr>';

        $('#PositionSelection').append(html);

        $("div#WPPositionDropzoneField_" + FCSUniqID).dropzone({
            url: "index.php?module=upload&event=uploadDocs&tid=" + TicketID + "&ForWPRInvoicePosition=1&WPRPositionID=" + FCSUniqID,
            init: function () {
                this.on("queuecomplete", function (file) {
                    this.removeAllFiles();
                    $('#ShowDocuments_' + FCSUniqID).removeClass('disabled');
                });
            }
        });        

        //Beim übertragen der Rechnungsposition werden die Daten als versteckte Formularfelder im WP-Panel mit angefügt
        PositionAsFormHTML = '';
        var PositionData = {};
        $.each(selectedWagePosition, function (key, val) {
            PositionData[key] = val;
            PositionAsFormHTML += '<input type="hidden" id="PositionFormData_' + FCSUniqID+ '_' + key + '"  name="WR[Positions][' + FCSUniqID + '][' + key + ']" value="' + val + '"/>';
        });

        $('#WPRequestPanel').append(PositionAsFormHTML);
        $('#SerialNoCell_' + FCSUniqID).clone().removeAttr('id').appendTo(' #SerialNoCellList_' + FCSUniqID);
        
        addedArtikel.push(selectedWagePosition.fcsUniqID);
        addedPositionObjects[selectedWagePosition.fcsUniqID] = selectedWagePosition;

        copyWagePosition(FCSUniqID);
    }


    function copyWagePosition(FCSUniqID){

        var row = $("#WageRow_"+FCSUniqID);
        newUniqueID = Math.random().toString(16).slice(2);
        
        row.attr('id', 'WageRow_' + newUniqueID );
        row.find('#Description_' + FCSUniqID).attr('id', 'Description_' + newUniqueID);
        row.find('#Wage_' + FCSUniqID).attr('id', 'Wage_' + newUniqueID);            
        row.find('#tdUnitPrice_' + FCSUniqID).attr('id', 'tdUnitPrice_' + newUniqueID);
        row.find('#tdPrice_' + FCSUniqID).attr('id', 'tdPrice_' + newUniqueID);
        row.find('#Amount_' + FCSUniqID).attr('id', 'Amount_' + newUniqueID).val(1).trigger('input');
        row.find('#AdditionalInformation1_' + FCSUniqID).attr('id', 'AdditionalInformation1_' + newUniqueID).val("");
        row.find('#AdditionalInformation2_' + FCSUniqID).attr('id', 'AdditionalInformation2_' + newUniqueID).val("");
        row.find('#AdditionalInformation3_' + FCSUniqID).attr('id', 'AdditionalInformation3_' + newUniqueID).val("");
        row.find('#AdditionalInformation4_' + FCSUniqID).attr('id', 'AdditionalInformation4_' + newUniqueID).val("");

        
        WagePositionListJson[newUniqueID] = WagePositionListJson[FCSUniqID];
        WagePositionListJson[newUniqueID].fcsUniqID = newUniqueID;
    }


    $(".formatPriceEURO, .formatPriceEUR").each(function (i, obj) {                
		price = parseToNumber($(this).html());
	    formatedPrice = new Intl.NumberFormat('de-DE', { style: 'currency', currency: 'EUR' }).format(price);
	    $(this).html(formatedPrice);
    });
    $(".formatPriceUSD").each(function (i, obj) {                
		price = parseToNumber($(this).html());
	    formatedPrice = new Intl.NumberFormat('en-US', { style: 'currency', currency: 'USD' }).format(price);
	    $(this).html(formatedPrice);
    });
</script>
