
$(document).ready(function () {
    initializeDataTable();



    $('#faq-tree').on('select_node.jstree', function (e, data) {
        const rubrikId = data.node.id;  // ID der Rubrik, die ausgewählt wurde

        $('#loading-spinner').removeClass('d-none');
        $('#ArticleSearchResultTable').html('');

        // AJAX Request an den Controller
        $.ajax({
            url: 'index.php?module=knowledgebase&event=articel4Cat&cid=' + rubrikId, // Controller-URL
            method: 'GET',
            success: function (html) {
                // Der dynamisch geladene HTML-Code wird in den Container eingefügt
                $('#ArticleSearchResultTable').html(html);

                // Verstecke den Spinner, nachdem die Artikel geladen wurden
                $('#loading-spinner').addClass('d-none');

                // Rufe die DataTable-Initialisierungsfunktion auf
                initializeDataTable();
            },
            error: function () {
                alert('Fehler beim Laden der Artikel.');
            }
        });
    });


});
function initializeDataTable() {
    $('.table').DataTable({
        buttons: [
            'excel',
            'print',
            'pdfHtml5'
        ],
        stateSave: true,
        "sPaginationType": "full_numbers",
        "bLengthChange": true,
        "iDisplayLength": 10,
        "oLanguage": {
            "sLengthMenu": s_lengthMenu, // Verwende die übersetzte Variable
            "sZeroRecords": s_zeroRecords, // Verwende die übersetzte Variable
            "sInfo": s_info, // Verwende die übersetzte Variable
            "sInfoEmpty": s_infoEmpty, // Verwende die übersetzte Variable
            "sInfoFiltered": s_infoFiltered, // Verwende die übersetzte Variable
            "sSearch": s_search, // Verwende die übersetzte Variable
            "oPaginate": {
                "sFirst": s_first, // Verwende die übersetzte Variable
                "sLast": s_last, // Verwende die übersetzte Variable
                "sNext": s_next, // Verwende die übersetzte Variable
                "sPrevious": s_previous // Verwende die übersetzte Variable
            },
            "aaSorting": [[1, "asc"]]
        },
        initComplete: function () {
            this.api().columns().every(function () {
                var column = this;
                var select = $('<select><option value=""></option></select>')
                    .appendTo($(column.footer()).empty())
                    .on('change', function () {
                        var val = $.fn.dataTable.util.escapeRegex(
                            $(this).val()
                        );

                        column
                            .search(val ? '^' + val : '', true, true)
                            .draw();
                    });
                column.data().unique().sort().each(function (d, j) {
                    select.append('<option value="' + d + '">' + d + '</option>')
                });
            });
        }
    });
}




$(function () {
    $('#faq-tree').jstree({
        core: {
            data: {
                url: 'faqcategories/tree', // z. B. JSON mit parent/child/SortOrder
                dataType: 'json'
            },
            check_callback: hasRightToEdit,  // Erlaubt Änderungen nur wenn Recht da ist
        },
        plugins: hasRightToEdit ? ['contextmenu', 'dnd', 'wholerow', 'search'] : ['wholerow', 'search'],
        contextmenu: {
            items: function (node) {
                if (!hasRightToEdit) {
                    // Nur z.B. "Ansicht" erlauben oder gar nichts
                    return {};
                }
                return {
                    create: {
                        label: s_create,
                        action: function () {
                            // Modal öffnen

                            $('#node-name').val('');
                            $('#node-description').val('');

                            $('#createNodeModal').modal('show');

                            // Formular absenden
                            $('#createNodeForm').off('submit').on('submit', function (e) {
                                e.preventDefault();

                                const name = $('#node-name').val();
                                const description = $('#node-description').val();

                                $.post('faqcategories/create', {
                                    name: name,
                                    description: description,
                                    parent: node.id
                                }, function (res) {
                                    $('#faq-tree').jstree(true).refresh();
                                    $('#createNodeModal').modal('hide'); // Modal schließen
                                });
                            });
                        }
                    },
                    rename: {
                        label: s_edit,
                        action: function () {


                            // Setze Werte im Modal
                            $('#node-id').val(node.id); // Falls du Variante mit <input type="hidden"> nutzt
                            $('#node-name').val(node.text);
                            $('#node-description').val(node.original?.description || '');

                            // 💡 Setze die ID als data-Attribut
                            $('#createNodeModal').data('edit-id', node.id);
                            // Modal anzeigen
                            $('#createNodeModalLabel').text(s_edit);
                            $('#createNodeModal').modal('show');

                            // Submit-Handler setzen
                            $('#createNodeForm').off('submit').on('submit', function (e) {
                                e.preventDefault();

                                const name = $('#node-name').val();
                                const description = $('#node-description').val();
                                const id = $('#node-id').val(); 

                                $.post('faqcategories/rename', {
                                    id: id,
                                    name: name,
                                    description: description
                                }, function () {
                                    $('#faq-tree').jstree(true).refresh();
                                    $('#createNodeModal').modal('hide');
                                });
                            });
                        }
                    },
                    remove: {
                        label: s_remove,  // Hier verwenden wir die übersetzte Variable
                        _disabled: function () {
                            // Deaktiviere "Löschen", wenn der Knoten Kinder hat
                            return $('#faq-tree').jstree(true).get_node(node).children.length > 0;
                        },
                        action: function () {
                            if (!confirm(s_confirm_delete)) return;  // Verwende auch die Übersetzung im Confirm-Dialog

                            $.post('faqcategories/delete', {
                                id: node.id
                            }, function () {
                                $('#faq-tree').jstree(true).refresh();
                            });
                        }
                    }
                };
            }
        },
        dnd: {
            inside_pos: 'last',
            is_draggable: hasRightToEdit
        }
    });

    // Drag & Drop Handler
    $('#faq-tree').on('move_node.jstree', function (e, data) {
        $.post('faqcategories/move', {
            id: data.node.id,
            parent: data.parent === "#" ? null : data.parent,
            position: data.position
        }, function () {
            $('#faq-tree').jstree(true).refresh(); // optional
        });
    });

    //Filter
    var to = false;
    $('#faq-tree-search').keyup(function () {
        if (to) { clearTimeout(to); }
        to = setTimeout(function () {
            var v = $('#faq-tree-search').val();
            $('#faq-tree').jstree(true).search(v);
        }, 250);
    });
});



//Wurzelknoten anlegen
$(function () {
    $('#create-root-node').on('click', function () {
        // Reset Felder
        $('#node-name').val('');
        $('#node-description').val('');

        // Parent auf null setzen
        $('#createNodeModal').data('parent-id', '#').modal('show');
    });

    $('#createNodeForm').off('submit').on('submit', function (e) {
        e.preventDefault(); // Verhindert Standard-Form-Submit

        const name = $('#node-name').val();
        const description = $('#node-description').val();
        const parent = $('#createNodeModal').data('parent-id') === '#' ? null : $('#createNodeModal').data('parent-id');

        $.post('faqcategories/create', {
            name: name,
            description: description,
            parent: parent
        }, function () {
            $('#createNodeModal').modal('hide');
            $('#faq-tree').jstree(true).refresh();
        });
    });
});

