<script type="text/javascript" src="includes/js/jquery-ui-timepicker-addon.js"></script>

<div class="panel panel-fcs-border">
    <div class="panel-body">
        <div class="row">
            <div class="col-sm-12">
                <div class="form-group">
                    <label class="control-label col-lg-2">
                        Workflow-Definition*
                    </label>
                    <div class="col-lg-10">
                        <select id="WorkflowDefinitionID" name="WorkflowDefinitionID" required class="form-control multiple" onchange="SetWorkflow()">
                            <option value="" selected="selected">-- Bitte wählen --</option>
                            @foreach ($Workflows as $workflow)
                                <option value="{{ $workflow->ID }}">{{ $workflow->Description }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-lg-2">
                        Name*
                    </label>
                    <div class="col-lg-10">
                        <input type="text" size="15" required name="ScheduledWorkflowName" class="form-control" value="" />
                    </div>
                </div>

                @if ($HideInitiator == false)
                    <div class="form-group">
                        <label class="control-label col-lg-2"  title="Person, die den Workflow startet.">
                            Initiator
                        </label>
                        <div class="col-lg-10">
                            <select name="InitiatorID" id="InitiatorID" class="form-control">
                                <option value="0" selected="selected">-- Bitte wählen --</option>
                                @foreach ($Initiators as $initiator)
                                    <option value="{{ $initiator->user_id }}">{{ $initiator->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                @endif

                @if ($ShowSubstituder == true)
                    <div class="form-group">
                        <label class="control-label col-lg-2"  title="Vertreter der Person, die den Workflow startet.">
                            Vertreter
                        </label>
                        <div class="col-lg-10">
                            <select name="SubstituderID" id="SubstituderID" class="form-control">
                                <option value="0" selected="selected">-- Bitte wählen --</option>
                                @foreach ($Substituders as $substituder)
                                    <option value="{{ $substituder->user_id }}">{{ $substituder->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                @endif
                    
                @if ($HideContact == true)
                    <input type="hidden" value="[% $user->ContactID %]" name="ContactID">
                @else
                    <div class="form-group">
                        <label class="control-label col-lg-2">
                            Kontakt
                        </label>
                        <div class="col-lg-10">
                            <select size="1" name="ContactID" id="ContactID" class="form-control">
                                <option value="0" selected="selected">-- Bitte wählen --</option>
                                @foreach ($Contacts as $contact)
                                    <option value="{{ $contact->contact_id }}">{{ $contact->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                @endif

                @if ($ShowProject == true)
                    <div class="form-group">
                        <label class="control-label col-lg-2">
                            Projekt
                        </label>
                        <div class="col-lg-10">
                            <select name="ProjectID" id="ProjectID" class="form-control multiple">
                                <option value="0" selected="selected">-- Bitte wählen --</option>
                                @foreach ($Projects as $project)
                                    <option value="{{ $project->ProjectID }}">{{ $project->ProjectName }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                @endif

                <div class="form-group">
                    <label class="control-label col-lg-2">
                        Wiederholungsmodus
                    </label>
                    <div class="col-lg-10">
                        <select size="1" name="RepeatType" id="RepeatType" class="form-control" >
                            <option value="1" selected="selected">Täglich</option>
                            <option value="2">Wöchentlich</option>
                            <option value="3">Monatlich</option>
                            <option value="4">Jährlich</option>
                            <option value="5">Alle X-Tage</option>
                        </select>
                    </div>
                </div>

                <div class="form-group"  id="pnlMonthlyDay" style="display:none;">
                    <label class="control-label col-lg-2">
                        Tag des Monats
                    </label>
                    <div class="col-lg-1">
                        <input type="number" min="1" max="31" name="MonthlyDay" id ="MonthlyDay" class="form-control datetimepicker" value="1" />
                    </div>
                </div>

                <div class="form-group"  id="pnlYearlyDate" style="display:none;">
                    <label class="control-label col-lg-2">
                        Jährlich am
                    </label>
                    <div class="col-lg-2">
                        <input type="date" name="YearlyDate" id ="YearlyDate" class="form-control datetimepicker" value="{{ $CurrentDate }}" />
                    </div>
                </div>

                <div class="form-group" id="pnlDelayDays" style="display:none">
                    <label class="control-label col-lg-2">
                        Wiederholung alle
                    </label>
                    <div class="col-lg-1">
                        <input type="number" min="1" value="1" name="DelayDays" class="form-control" />
                    </div>
                    <label class="control-label col-lg-9">
                        Tage
                    </label>
                </div>

                <div class="form-group">
                    <label class="control-label col-lg-2">
                        Startzeit um*
                    </label>
                    <div class="col-lg-1">
                        <input type="time" required name="StartTime" class="form-control" value="" />
                    </div>
                </div>

                <div class="form-group" id="pnlWeekdays" style="display:none">
                    <label class="control-label col-lg-2">
                        Wiederholen am
                    </label>
                    <div class="col-lg-10">
                        <input type="checkbox" value="1" name="weekday[1]" />Mo
                        <input type="checkbox" value="2" name="weekday[2]" />Di
                        <input type="checkbox" value="3" name="weekday[3]" />Mi
                        <input type="checkbox" value="4" name="weekday[4]" />Do
                        <input type="checkbox" value="5" name="weekday[5]" />Fr
                        <input type="checkbox" value="6" name="weekday[6]" />Sa
                        <input type="checkbox" value="0" name="weekday[0]" />So
                    </div>
                </div>

                <div class="form-group" id="WorkflowActive">
                    <label class="control-label col-lg-2">
                        Aktiv
                    </label>
                    <div class="col-lg-10">
                        <input type="checkbox" value="1" name="Active" checked/>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $('#RepeatType').on('change', function(e)
    {
        ToggleRepeatPanels(parseInt(this.value));
    });

     function ToggleRepeatPanels(repeatType)
    {
        switch(repeatType)
        {
            case 1: //Täglich
                document.getElementById("pnlWeekdays").style.display = "none";
                document.getElementById("pnlMonthlyDay").style.display = "none";
                document.getElementById("pnlYearlyDate").style.display = "none";
                document.getElementById("pnlDelayDays").style.display = "none";
                break;
            case 2: //Wöchentlich
                document.getElementById("pnlWeekdays").style.display = "block";
                document.getElementById("pnlMonthlyDay").style.display = "none";
                document.getElementById("pnlYearlyDate").style.display = "none";
                document.getElementById("pnlDelayDays").style.display = "none";
                break;
            case 3: //Monatlich
                document.getElementById("pnlWeekdays").style.display = "none";
                document.getElementById("pnlMonthlyDay").style.display = "block";
                document.getElementById("pnlYearlyDate").style.display = "none";
                document.getElementById("pnlDelayDays").style.display = "none";
                break;
            case 4: //Jährlich
                document.getElementById("pnlWeekdays").style.display = "none";
                document.getElementById("pnlMonthlyDay").style.display = "none";
                document.getElementById("pnlYearlyDate").style.display = "block";
                document.getElementById("pnlDelayDays").style.display = "none";
                break;
            case 5: //Nach X-Tagen
                document.getElementById("pnlWeekdays").style.display = "none";
                document.getElementById("pnlMonthlyDay").style.display = "none";
                document.getElementById("pnlYearlyDate").style.display = "none";
                document.getElementById("pnlDelayDays").style.display = "block";
                break;
        }
    }
</script>
