<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* ManagedTenantOperationError File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\ManagedTenants\Model;
/**
* ManagedTenantOperationError class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class ManagedTenantOperationError extends \Beta\Microsoft\Graph\Model\Entity
{
    /**
    * Gets the error
    * The error message for the exception.
    *
    * @return string|null The error
    */
    public function getError()
    {
        if (array_key_exists("error", $this->_propDict)) {
            return $this->_propDict["error"];
        } else {
            return null;
        }
    }

    /**
    * Sets the error
    * The error message for the exception.
    *
    * @param string $val The value of the error
    *
    * @return ManagedTenantOperationError
    */
    public function setError($val)
    {
        $this->_propDict["error"] = $val;
        return $this;
    }
    /**
    * Gets the tenantId
    * The Microsoft Entra tenant identifier for the managed tenant.
    *
    * @return string|null The tenantId
    */
    public function getTenantId()
    {
        if (array_key_exists("tenantId", $this->_propDict)) {
            return $this->_propDict["tenantId"];
        } else {
            return null;
        }
    }

    /**
    * Sets the tenantId
    * The Microsoft Entra tenant identifier for the managed tenant.
    *
    * @param string $val The value of the tenantId
    *
    * @return ManagedTenantOperationError
    */
    public function setTenantId($val)
    {
        $this->_propDict["tenantId"] = $val;
        return $this;
    }
}
