<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* PlannerRoster File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\Model;

/**
* PlannerRoster class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class PlannerRoster extends Entity
{

     /**
     * Gets the members
    * Retrieves the members of the plannerRoster.
     *
     * @return array|null The members
     */
    public function getMembers()
    {
        if (array_key_exists("members", $this->_propDict)) {
           return $this->_propDict["members"];
        } else {
            return null;
        }
    }

    /**
    * Sets the members
    * Retrieves the members of the plannerRoster.
    *
    * @param PlannerRosterMember[] $val The members
    *
    * @return PlannerRoster
    */
    public function setMembers($val)
    {
        $this->_propDict["members"] = $val;
        return $this;
    }


     /**
     * Gets the plans
    * Retrieves the plans contained by the plannerRoster.
     *
     * @return array|null The plans
     */
    public function getPlans()
    {
        if (array_key_exists("plans", $this->_propDict)) {
           return $this->_propDict["plans"];
        } else {
            return null;
        }
    }

    /**
    * Sets the plans
    * Retrieves the plans contained by the plannerRoster.
    *
    * @param PlannerPlan[] $val The plans
    *
    * @return PlannerRoster
    */
    public function setPlans($val)
    {
        $this->_propDict["plans"] = $val;
        return $this;
    }

}
