<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* WindowsMalwareCategory File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\Model;

use Microsoft\Graph\Core\Enum;

/**
* WindowsMalwareCategory class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class WindowsMalwareCategory extends Enum
{
    /**
    * The Enum WindowsMalwareCategory
    */
    const INVALID = "invalid";
    const ADWARE = "adware";
    const SPYWARE = "spyware";
    const PASSWORD_STEALER = "passwordStealer";
    const TROJAN_DOWNLOADER = "trojanDownloader";
    const WORM = "worm";
    const BACKDOOR = "backdoor";
    const REMOTE_ACCESS_TROJAN = "remoteAccessTrojan";
    const TROJAN = "trojan";
    const EMAIL_FLOODER = "emailFlooder";
    const KEYLOGGER = "keylogger";
    const DIALER = "dialer";
    const MONITORING_SOFTWARE = "monitoringSoftware";
    const BROWSER_MODIFIER = "browserModifier";
    const COOKIE = "cookie";
    const BROWSER_PLUGIN = "browserPlugin";
    const AOL_EXPLOIT = "aolExploit";
    const NUKER = "nuker";
    const SECURITY_DISABLER = "securityDisabler";
    const JOKE_PROGRAM = "jokeProgram";
    const HOSTILE_ACTIVE_X_CONTROL = "hostileActiveXControl";
    const SOFTWARE_BUNDLER = "softwareBundler";
    const STEALTH_NOTIFIER = "stealthNotifier";
    const SETTINGS_MODIFIER = "settingsModifier";
    const TOOL_BAR = "toolBar";
    const REMOTE_CONTROL_SOFTWARE = "remoteControlSoftware";
    const TROJAN_FTP = "trojanFtp";
    const POTENTIAL_UNWANTED_SOFTWARE = "potentialUnwantedSoftware";
    const ICQ_EXPLOIT = "icqExploit";
    const TROJAN_TELNET = "trojanTelnet";
    const EXPLOIT = "exploit";
    const FILESHARING_PROGRAM = "filesharingProgram";
    const MALWARE_CREATION_TOOL = "malwareCreationTool";
    const REMOTE__CONTROL__SOFTWARE = "remoteControlSoftware";
    const TOOL = "tool";
    const TROJAN_DENIAL_OF_SERVICE = "trojanDenialOfService";
    const TROJAN_DROPPER = "trojanDropper";
    const TROJAN_MASS_MAILER = "trojanMassMailer";
    const TROJAN_MONITORING_SOFTWARE = "trojanMonitoringSoftware";
    const TROJAN_PROXY_SERVER = "trojanProxyServer";
    const VIRUS = "virus";
    const KNOWN = "known";
    const UNKNOWN = "unknown";
    const SPP = "spp";
    const BEHAVIOR = "behavior";
    const VULNERABILITY = "vulnerability";
    const POLICY = "policy";
    const ENTERPRISE_UNWANTED_SOFTWARE = "enterpriseUnwantedSoftware";
    const RANSOM = "ransom";
    const HIPS_RULE = "hipsRule";
}
