<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* VulnerabilitySeverity File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Microsoft\Graph\SecurityNamespace\Model;

use Microsoft\Graph\Core\Enum;

/**
* VulnerabilitySeverity class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class VulnerabilitySeverity extends Enum
{
    /**
    * The Enum VulnerabilitySeverity
    */
    const NONE = "none";
    const LOW = "low";
    const MEDIUM = "medium";
    const HIGH = "high";
    const CRITICAL = "critical";
    const UNKNOWN_FUTURE_VALUE = "unknownFutureValue";
}
