<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* TermGroupScope File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Microsoft\Graph\TermStore\Model;

use Microsoft\Graph\Core\Enum;

/**
* TermGroupScope class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class TermGroupScope extends Enum
{
    /**
    * The Enum TermGroupScope
    */
    const GRAPHGLOBAL = "global";
    const SYSTEM = "system";
    const SITE_COLLECTION = "siteCollection";
    const UNKNOWN_FUTURE_VALUE = "unknownFutureValue";
}
