/**
 * @license Copyright Â© 2013 Stuart Sillitoe <stuart@vericode.co.uk>
 * This is open source, can modify it as you wish.
 *
 * Stuart Sillitoe
 * stuartsillitoe.co.uk
 *
 */

/**
 * List of dicts which define strings to choose from to insert into the editor.
 *
 * Each insertable string dict is defined by three possible keys:
 *    'value': The value to insert.
 *    'name': The name for the string to use in the dropdown.
 *    'label': The voice label (also used as the tooltip title) for the string.
 *
 * Only the value to insert is required to define an insertable string, the
 * value will be used as the name (and the name as the label) if other keys are
 * not provided.
 *
 * If the value key is *not* defined and the name key is, then a group header
 * with the given name will be provided in the dropdown box.  This heading is
 * not clickable and does not insert, it is for organizational purposes only.
 */

/**
 * String to use as the button label.
 */
CKEDITOR.config.strinsert_button_label = 'Insert';

/**
 * String to use as the button title.
 */
CKEDITOR.config.strinsert_button_title = 'Insert content';

/**
 * String to use as the button voice label.
 */
CKEDITOR.config.strinsert_button_voice = 'Insert content';

CKEDITOR.plugins.add('strinsert',
        {
            requires: ['richcombo'],
            icons: 'project,project_add,content',
            lang: 'de,en',

            init: function (editor)
            {
                var config = editor.config;
                // Gets the list of insertable strings from the settings.
                var strings = config.strinsert_strings;



                // add the menu to the editor
                editor.ui.addRichCombo('strinsert',
                        {
                            label: editor.lang.strinsert.toolbar,
                            title: editor.lang.strinsert.toolbar,
                            voiceLabel: editor.lang.strinsert.toolbar,
                            toolbar: 'document,60',
                            className: 'cke_format',
                            multiSelect: false,
                            panel:
                                    {
                                        css: [editor.config.contentsCss, CKEDITOR.skin.getPath('editor')],
                                        voiceLabel: editor.lang.panelVoiceLabel
                                    },
                            init: function ()
                            {
                                for (var i = 0, len = strings.length; i < len; i++)
                                {
                                    string = strings[i];
                                    // If there is no value, make a group header using the name.
                                    if (!string.value) {
                                        this.startGroup(string.name);
                                    }
                                    // If we have a value, we have a string insert row.
                                    else {
                                        // If no name provided, use the value for the name.
                                        if (!string.name) {
                                            string.name = string.value;
                                        }
                                        // If no label provided, use the name for the label.
                                        if (!string.label) {
                                            string.label = string.name;
                                        }
                                        this.add(string.value, string.name, string.label);
                                    }
                                }
                            },
                            onClick: function (value)
                            {                              
                                editor.insertText(value.replace(/(?:_NEWLINE_)/g, '\n'));
                            },
                        });

                editor.ui.addButton('project_add', {
                    label: editor.lang.strinsert.addSnippet_text,
                    command: 'addSnippet',
                    toolbar: 'document,61'
                });
                editor.addCommand('addSnippet', {modes: {wysiwyg: 1, source: 1},
                    exec: function (editor) {
                        $('#showAddSnippet').click();
                    },
                    async: true
                });

                editor.ui.addButton('content', {
                    label: editor.lang.strinsert.showList_title,
                    command: 'showSnippetList',
                    toolbar: 'document,62'
                });
                editor.addCommand('showSnippetList', {modes: {wysiwyg: 1, source: 1},
                    exec: function (editor) {
                        $('#showSnippetlist').click();
                    },
                    async: true
                });
            }
        });
