<?php
use Illuminate\Support\Facades\Session;
use App\Services\HMEncryptionService;

//use Illuminate\Support\Facades\App;
/**
 * index.php
 *
 * MVC - Controller
 *
 * @author Dirk Herbes
 * @author Jan Koepke
 * @package Framework
 */
// Base Settings
//echo Session::getId();
//exit;



error_reporting(0);
//echo __CLASS__." ".__FUNCTION__." ".__LINE__." ". (microtime(true) - $_SERVER['REQUEST_TIME_FLOAT']);

define('DS', DIRECTORY_SEPARATOR);
define('_VALID_HM', 1);
//define('_HM_BASE', dirname(__FILE__));
define('_HM_BASE', dirname($_SERVER['SCRIPT_FILENAME']));
if(!defined('_HM_PUBLIC')){
    define('_HM_PUBLIC', _HM_BASE . DIRECTORY_SEPARATOR . 'public' . DIRECTORY_SEPARATOR);
}
if (!defined('_HM_INCLUDES')) {
    define('_HM_INCLUDES', _HM_BASE . DS . 'includes' . DS);
}
define('_HM_RELPATH', str_replace('index.php', '', $_SERVER['SCRIPT_NAME']));
define('_HM_PEAR_DIR', _HM_INCLUDES . 'PEAR' . DS);
define('_HM_RELUPLOAD', _HM_RELPATH . 'upload/');
define('_HM_STYLEPATH', 'styles/default/css/ownStyles/');
define('UPDATE_PASSWORD', false);
ini_set('include_path', _HM_PEAR_DIR);
ini_set('post_max_size', '64M');
ini_set('upload_max_filesize', '64M');
ini_set('max_execution_time', 300);
session_save_path(_HM_BASE . DS . "..".DS."storage".DS."framework".DS."sessions");

ini_set('memory_limit', '2048M');
//echo setlocale(LC_ALL, "de_DE.iso88591", "de_DE.iso885915@euro");
//Textlimit für mssql auf maximum setzen:
ini_set('mssql.textlimit', 2147483600);
ini_set('mssql.textsize', 2147483600);
ini_set('default_charset', "UTF-8");
ini_set('mssql.charset', "UTF-8");
//session_id(Session::getId());
if ('' == session_id()) {
    session_start();
}

//Wenn die licence im Stammverzeichnis liegt: Übertragen nach /legacy
if (!file_exists(_HM_BASE . DS . 'licence.php') && file_exists(_HM_BASE . DS . '..' . DS . 'licence.php')) {
    copy(_HM_BASE . DS . '..' . DS . 'licence.php', _HM_BASE . DS . 'licence.php');
}
//Wenn die config im Stammverzeichnis liegt: Übertragen nach /legacy
if (!file_exists(_HM_BASE . DS . 'configuration.php') && file_exists(_HM_BASE . DS . '..' . DS . 'configuration.php')) {
    copy(_HM_BASE . DS . '..' . DS . 'configuration.php', _HM_BASE . DS . 'configuration.php');
} else if (!file_exists(_HM_BASE . DS . 'configuration.php') && file_exists(_HM_BASE . DS . 'example.configuration.php')) {
    copy(_HM_BASE . DS . 'example.configuration.php', _HM_BASE . DS . 'configuration.php');
    $_SESSION['install']['force'] = 1;
    $_SESSION['install']['InitDB'] = 1;
    $_SESSION['install']['redirectToInstall'] = 1;
    header('Location: ../legacy/index.php?module=installation');
    exit;
}

require_once _HM_BASE . DS . 'configuration.php';


if (defined('DBPASS_ENCRYPTED') && !defined('DBPASS')){
    $DBPass = HMEncryptionService::decrypt(DBPASS_ENCRYPTED);
    if ($DBPass === false || $DBPass == '') {
        die('Datenbankpasswort aus der configuration.php kann nicht entschlüsselt werden.');
    }
    define('DBPASS', $DBPass);
}



if (!defined('DBNAME') || trim(DBNAME) == '' && (!isset($_GET) || $_GET['module'] != 'installation') ) {

    $_SESSION['install']['force'] = 1;
    $_SESSION['install']['InitDB'] = 1;
    $_SESSION['install']['redirectToInstall'] = 1;
    header('Location: index.php?module=installation');
}


//Wenn die Daten in der configuration.php nicht mit denen der .env übereinstimmen, .env neu generieren:

if (isset($_ENV['DB_HOST']) && defined('DBHOST') &&  $_ENV['DB_HOST'] != DBHOST) {
$const = get_defined_constants();
$DBPASS_ENCRYPTED = (defined('DBPASS_ENCRYPTED') && DBPASS_ENCRYPTED != '') ? DBPASS_ENCRYPTED : HMEncryptionService::encrypt(DBPASS);
$Filename= _HM_BASE . DS . '..' . DS . '.env';
$handle = fopen($Filename,"w");

$text =
<<<"END"
APP_NAME=Laravel
APP_ENV=local
APP_KEY=base64:KYfkOIIcgjnr3Mz5a3b5T4Vb6riSmvgyvAx3IvUlcwc=
APP_DEBUG=false
APP_URL={$const['HTTPURL']}

LOG_CHANNEL=stack
LOG_LEVEL=debug

DB_CONNECTION={$const['DBTYPE']}
DB_HOST={$const['DBHOST']}
DB_PORT={$const['DBPORT']}
DB_DATABASE={$const['DBNAME']}
DB_USERNAME={$const['DBUSER']}
DB_PASSWORD_ENCRYPTED="{$DBPASS_ENCRYPTED}"

BROADCAST_DRIVER=log
CACHE_DRIVER=file
FILESYSTEM_DRIVER=local
QUEUE_CONNECTION=sync
SESSION_DRIVER=file
SESSION_LIFETIME=120

MEMCACHED_HOST=127.0.0.1

REDIS_HOST=127.0.0.1
REDIS_PASSWORD=null
REDIS_PORT=6379

MAIL_MAILER=smtp
MAIL_HOST=mailhog
MAIL_PORT=1025
MAIL_USERNAME=null
MAIL_PASSWORD=null
MAIL_ENCRYPTION=null
MAIL_FROM_ADDRESS=null
MAIL_FROM_NAME="${APP_NAME}"

AWS_ACCESS_KEY_ID=
AWS_SECRET_ACCESS_KEY=
AWS_DEFAULT_REGION=us-east-1
AWS_BUCKET=
AWS_USE_PATH_STYLE_ENDPOINT=false

PUSHER_APP_ID=
PUSHER_APP_KEY=
PUSHER_APP_SECRET=
PUSHER_APP_CLUSTER=mt1

MIX_PUSHER_APP_KEY="${PUSHER_APP_KEY}"
MIX_PUSHER_APP_CLUSTER="${PUSHER_APP_CLUSTER}"

APIDEFAULTCONTACT=
AZUREDEVOPS_SERVER_LANGUAGE=
AZUREDEVOPS_SERVERURL=
AZUREDEVOPS_PAT=

END;

fwrite($handle, $text); // in Datei schreiben
fclose($handle);
}


//Wenn in der config nicht gesetzt => BOOTSTRAP aktivieren:
if (!defined('BOOTSTRAP')) {
    define('BOOTSTRAP', 1);
}
//Ist das Uploadverzeichnis nicht definiert: Standardpfad verwenden:
if (!defined('_HM_UPLOAD')) {
    define('_HM_UPLOAD', realpath(_HM_BASE . '/../upload') . DIRECTORY_SEPARATOR);
}

// Database Connection
$dsn = DBTYPE . '://' . DBUSER . ':' . DBPASS . '@' . DBHOST;
if (DBPORT > 0)
    $dsn .= ':' . DBPORT;
$dsn .= '/' . DBNAME;

define('FR_DSN', $dsn);
define('SMARTY_DIR', _HM_BASE . DS . 'inc' . DS . 'Smarty' . DS);
define('FR_TEMPLATE', 'default');

//Transaction steuerbar machen
if (!defined('DBUSETRANSACTIONS')) {
    define('DBUSETRANSACTIONS', 0);
}

// Error Reporting Off
error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING & ~E_STRICT & ~E_DEPRECATED);
if((defined('DEBUGMODE') && DEBUGMODE == 1)){
    ini_set('display_errors', 1);
}
else{
    ini_set('display_errors', 0);
}




// Time measuring
if (isset($_SESSION['UserName'])) {
    $_SERVER['Zeitmessung']['UserName'] = $_SESSION['UserName'];
}
$_SERVER['Zeitmessung']['Query'] = $_SERVER['QUERY_STRING'];
$_SERVER['Zeitmessung']['beginn'] = microtime(true);

// {{{ __autoload($class)
/**
 * __autoload
 *
 * Autoload is ran by PHP when it can't find a class it is trying to load.
 * By naming our classes intelligently we should be able to load most classes
 * dynamically.
 *
 * @author Dirk Herbes <d.herbes@fair-computer.de>#!/usr/bin/env php
 * @param string $class Class name we're trying to load
 * @return void
 * @package Framework
 */
//require_once(_HM_PEAR_DIR.'Doctrine.php');
//spl_autoload_register(array('Doctrine', 'autoload'));

define('SMARTY_SPL_AUTOLOAD', 1);
define('SMARTY_SYSPLUGINS_DIR', _HM_BASE . DS . 'inc' . DS . 'Smarty' . DS . 'sysplugins' . DS);

require_once _HM_BASE . DS . 'inc' . DS . 'Smarty' . DS . 'Autoloader.php';
Smarty_Autoloader::registerBC();

function hmautoload($class) {
    $file = str_replace('_', DS, substr($class, 2)) . '.php';
    include_once _HM_BASE . DS . 'inc' . DS . $file;
}

spl_autoload_register('hmautoload');


//function __autoload($class) {
//    $file = str_replace('_', DS, substr($class, 2)) . '.php';
//    include_once _HM_BASE . DS . 'inc' . DS . $file;
//}
// }}}
//Kompatibilität zu alten Ticketaufrufen herstellen:
if (isset($_GET['option']) && 'ticket' == $_GET['option'] && isset($_GET['task']) && 'details' == $_GET['task']) {
    header('Location: index.php?module=ticket&event=show&id=' . $_GET['id']);
}

$QUERY_STRING = (strpos($_SERVER['QUERY_STRING'], '&') !== FALSE) ? substr($_SERVER['QUERY_STRING'], 0, strpos($_SERVER['QUERY_STRING'], '&')) //String vor dem ersten &
        : trim($_SERVER['QUERY_STRING']);


if ($QUERY_STRING != '' && strpos($QUERY_STRING , 'module') === false) {
    $RESTRequests = new FR_Entities_RESTRequest();
    $AvailabaleRESTRequest = $RESTRequests->isAvailabaleRESTRequest();
    if ($AvailabaleRESTRequest !== false) {
        $RESTRequests->redirectTo();
    }
//    print_r($RESTRequests->AvailableRequests);
}


//KB- oder Ticket-Shortcut:
//Paramterformat: index.php?kb-1   oder index.php?tid-456
preg_match_all('/(\w*)-(\d*)/m', $QUERY_STRING, $matches, PREG_SET_ORDER, 0);
if (isset($matches[0]) && isset($matches[0][0]) && $matches[0][1] != '' && $matches[0][2]) {
    switch ($matches[0][1]) {
        case 'tid':
            header('Location: index.php?module=ticket&event=show&id=' . $matches[0][2]);
            exit;
            break;
        case 'kb':
            header('Location: index.php?module=knowledgebase&fid=' . $matches[0][2]);
            exit;
    }
}



switch ($QUERY_STRING) {
//Weitere REST-Requests befuinden sich im FR_Entities_RESTRequest

    case 'UpdateExpExpense':
        $_GET['module'] = 'ticket';
        $_GET['event'] = 'changeExpExpense';
        $_REQUEST['save'] = 1;
        $_REQUEST['keepOnHold'] = 1;
        $_REQUEST['json'] = 1;
        /*
          $_REQUEST['ExpExpense'];
          $_REQUEST['ticketid'];
         */
        break;

    case 'UpdateTicketStatus':
        //3, 9 oder 6 (CLOSE | DONE | REOPENED)
        switch ($_REQUEST['newStatusID']) {
            case 3:
                $_GET['module'] = 'ticket';
                $_GET['event'] = 'RESTupdateTicketStatusClose';
                break;
            case 6:
                $_GET['module'] = 'ticket';
                $_GET['event'] = 'RESTupdateTicketStatusReopen';
                break;
            case 9:
                $_GET['module'] = 'ticket';
                $_GET['event'] = 'RESTupdateTicketStatusDone';
                break;
            default:
                echo json_encode("Just StatusID 3,6 or 9 allowed");
                break;
        }
        break;

    default:
        break;
}
/* REST Routing Ende */


$module = basename((isset($_GET['module'])) ? $_GET['module'] : 'start');
$event = basename((isset($_GET['event'])) ? $_GET['event'] : '__default');
$class = basename((isset($_GET['class'])) ? $_GET['class'] : $module);


$classFile = _HM_BASE . DS . 'modules' . DS . $module . DS . $class . '.php';

/* Ende REST Routing */




//TAPI-APP Abfrage markieren:
//if (isset($_REQUEST['phoneno']) && '' != $_REQUEST['phoneno']) {
if (isset($_REQUEST['phoneno'])) {
    $_SESSION['TAPILogin'] = TRUE;
    $_SESSION['UserName'] = $_REQUEST['lx_username'];
    if (!isset($_SESSION['TAPIPass']) && isset($_REQUEST['lx_password'])) {
        //Wenn das Passwort schon gehashed ist, nicht noch einmal hashen:
        if (32 == strlen($_REQUEST['lx_password'])) {
            $_SESSION['TAPIPass'] = $_REQUEST['lx_password'];
        } else {
            $_SESSION['TAPIPass'] = md5($_REQUEST['lx_password']);
        }
    }
    $_SESSION['RandomUserID'] = '1';
}

// Module file exists ?
if (file_exists($classFile)) {

    require_once($classFile);

    // Module class exists ?
    if (class_exists($class)) {

        try {

            // Init Module
            $instance = new $class();
            $instance->className = $class;

            // Is this a valid module ?
            if (!FR_Module::isValid($instance)) {
                die('Requested module is not valid framework module!');
                //header('Location: error404.html');
            }

            $instance->moduleName = $module;

            // Have you access to module ?

                       if ($instance->authenticate()) {

                try {
                    if (method_exists($instance, $event)) {
                        $result = $instance->$event();

                        if (!PEAR::isError($result)) {

                            $instance->eventName = $event;
                            $presenter = FR_Presenter::factory($instance->presenter, $instance);

                            if (!PEAR::isError($presenter)) {
                                $presenter->display();
                            } else {
                                die($presenter->getMessage());
                                //header('Location: /error404.html');
                            }
                        }
                    } else {
                        //header('Location: /error404.html');
                       header("HTTP/1.1 500 Internal Server Error");


                        exit;
                    }
                } catch (Exception $error) {
                    die($error->getMessage());
                    //header('Location: /error404.html');
                }
            } else {
                //die('You do not have access to the requested page!');
                //ggf. URL merken:

                if ('module=start&class=shoutbox' != trim($_SERVER['QUERY_STRING']) &&
                        FALSE === strpos($_SERVER['QUERY_STRING'], 'module=messages') &&
                        FALSE === strpos($_SERVER['QUERY_STRING'], 'module=login') &&
                        FALSE === strpos($_SERVER['QUERY_STRING'], 'module=tapi')
                ) {
                    $_SESSION['QUERY_STRING'] = trim($_SERVER['QUERY_STRING']);
                }

                if (FALSE === strpos($_SERVER['QUERY_STRING'], 'popup=1')) {
                    //echo $_SERVER['QUERY_STRING'];
                    header('Location: index.php?module=login');
                    exit;
                } else {
                    echo "<b>Session abgelaufen - Ihr Benutzer wurde abgemeldet.</b>";
                }
            }
        } catch (Exception $error) {
//TODO: Eigene Errorpage

        }
    } else {
//TODO: Eigene Errorpage

    }
} else {
//TODO: Eigene Errorpage

}


function clientInSameSubnet($IPAddress = false) {
    //$this->tools->printArray($_SERVER);

    if (!$IPAddress)
        $IPAddress = $_SERVER['LOCAL_ADDR'];

    if ($IPAddress == '127.0.0.1') {
        return true;
    }
    return (!filter_var($IPAddress, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) );
}

?>
