<script src="includes/js/dropzone.js"></script>
<link href="includes/js/dropzone.css" rel="stylesheet" type="text/css" />

<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

<style>
    .diffCol {
        color:  green;
    }    
    .importError {
        color:red;
    }
    .importSuccess{
        color:green;
    }
</style>
<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h2">[% $user->gettext('Kommerzielle Gerätedaten') %]</span>
    </div>
    <div class="card-body">

        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <span class="fcs-card-title h3">[% $user->gettext('CSV Import') %]

                    <div class="pull-right">
                        <a href="index.php?module=assets&class=commercialdevdata" class='btn btn-outline-secondary'>[% $user->gettext('Liste') %]</a>
                        
                        <a href="index.php?module=assets&class=commercialdevdata&event=getCSVHeaders" class="btn btn-outline-primary">[% $user->gettext('CSV-Vorlage herunterladen') %]</a>
                    </div>
            </div>
            <div class="card-body">

                <div class="card panel-info shadow-sm rounded">
                    <div class="card-body">
                        <form action="index.php?module=assets&class=commercialdevdata&event=CSVImport" method="post" id="CSVImportForm" class="form form-horizontal center-block">

                            <label><input type="checkbox" name="notExist" id="notExist" value="1" checked> [% $user->gettext('Neue Daten') %]</label>

                            <label><input type="checkbox" name="hasUpdate" id="hasUpdate" value="1" checked> [% $user->gettext('Geänderte Daten') %]</label>


                            <label><input type="checkbox" name="noChanges" id="noChanges" value="1" checked> [% $user->gettext('Daten ohne Änderungen') %]</label>


                            [% if $cntEntries %]


                                <p>[% $user->gettext('Es wurden') %][% $cntEntries %] [% $user->gettext('Einträge zum importieren gefunden. Sollen diese angelegt / aktualisiert werden?' %]</p>
                                <input type="hidden" name="importData" value="1">
                                <span id="startImport" class="btn btn-outline-secondary">[% $user->gettext('Ja') %]</span>
                                <table id="ResultTable"  class="table table-bordered table-striped table-sm hidden">
                                    <thead>
                                        <tr>
                                            <th>
                                                [% $user->gettext('Software') %]
                                            </th>
                                            <th>
                                                [% $user->gettext('Messages') %]
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>



                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped table-sm">
                                        <thead>
                                            <tr>
                                                <th>
                                                    <input type="checkbox" id="SelectAll" />
                                                </th>
                                                <th>
                                                    [% $user->gettext('Aktion') %]
                                                </th>
                                                [% foreach from=$Headers item=Col %]                                                    
                                                    <th>
                                                        [% $Col %]
                                                    </th>
                                                [% /foreach %]
                                            </tr>
                                        </thead>
                                        <tbody>

                                            [% foreach from=$CSVData item=Object key=csvKey %]
                                                <tr id="CSVColNo_[% $csvKey %]" class="[% if $Compare.$csvKey.exist %]exist [% if $Compare.$csvKey.update %]hasUpdate[% else %]noChanges[% /if %][% else %] notExist[% /if %]">
                                                    <td>
                                                        [% if !$Compare.$csvKey.exist || $Compare.$csvKey.update  %]
                                                            <input type="checkbox" class="SWCatalogSelect" id="SWCatalogSelect_[% $csvKey %]" name="selectedAssets[[% $csvKey %]]" value="[% $csvKey %]" class="form-control" />
                                                        [% /if %]
                                                    </td>
                                                    <td>
                                                        [% if $Compare.$csvKey.exist %]                                                         
                                                            [% if $Compare.$csvKey.update %]
                                                                [% $user->gettext('Update') %] 
                                                            [% else %]
                                                                [% $user->gettext('Keine Änderungen') %] 
                                                            [% /if %]

                                                        [% else %]
                                                            [% $user->gettext('Anlegen') %]
                                                        [% /if %]
                                                    </td>
                                                    [% foreach from=$Object item=val key=ColName %]
                                                        <td [% if $Compare.$csvKey.values.$ColName %] class="diffCol"[% /if %]>
                                                            [% $val %]
                                                            [% if $Compare.$csvKey.values.$ColName %]
                                                                <hr/><span class="diffValue" title="[% $user->gettext('Vorheriger Wert') %]">
                                                                    [% $Compare.$csvKey.values.$ColName %]                                                                
                                                                </span>
                                                            [% /if %]
                                                        </td>
                                                    [% /foreach %]
                                                </tr>
                                            [% /foreach %]
                                        </tbody>
                                    </table>
                                </div>

                            [% else %]
                                [% $user->gettext('CSV-Datei per Drag and Drop reinziehen') %]
                            [% /if %]
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<script>

    $(document).ready(function () {

$('#SelectAll').on("click", function(){
    $('.SWCatalogSelect:visible').prop('checked', true);
})
        $("#hasUpdate").on("click", function () {
            $('.hasUpdate').toggleClass('hidden');
        })

        $("#notExist").on("click", function () {
            $('.notExist').toggleClass('hidden');
        })

        $("#noChanges").on("click", function () {
            $('.noChanges').toggleClass('hidden');
        })


        $('#startImport').on("click", function (e) {
            importFirstSelectedCatalog();
        })

        /**
         * Comment
         */
        function importFirstSelectedCatalog() {
            CSVColNo = $(".SWCatalogSelect:checkbox:checked:first").val();
            if (typeof CSVColNo === "undefined") {
                return;
            }

            console.log("Nächste: ");
            console.log("ColNo: " + CSVColNo);


            $.post("index.php?module=assets&class=commercialdevdata&event=startCSVImport&CSVColNo=" + CSVColNo, function (data) {


            }).done(function (data) {
                console.log(data);
                $('#ResultTable').removeClass('hidden');

                markup = "<tr id='Result_" + CSVColNo + "' class=' " + (data.error ? 'importError' : 'importSuccess') + "' ><td>" + data.CDData.devicename + " / " + data.CDData.hostname + "</td><td>";
                $.each(data.messages, function (i, item) {
                    markup += item + "<br/>";
                })
                markup += "</td></tr>";
                $('#ResultTable > tbody').append(markup);

                if (data.error) {
                    $("#CSVColNo_" + CSVColNo).addClass('importError');
                    //Wenn es einen Fehler gab, die Markierung entfernen.
                    $('#SWCatalogSelect_' + CSVColNo).prop('checked', false);
                } else {
                    $("#CSVColNo_" + CSVColNo).fadeOut();
                    $("#CSVColNo_" + CSVColNo).remove();
                }


                $("#Result_" + CSVColNo).hide();
                $("#Result_" + CSVColNo).fadeIn();


                importFirstSelectedCatalog();
            });
        }

        Dropzone.options.myDropzone = {

            init: function () {

                this.on("queuecomplete", function (file) {
                    //this.removeAllFiles();
                });
            }
        };

        $(".panel-fcs-content").dropzone({
            url: "index.php?module=assets&event=getCSVFile",
            init: function () {
                this.on("queuecomplete", function (file) {
                    //this.removeAllFiles();
                    location.reload();
                });
            }
        });
    })
</script>
