<!-- Component CSV-Import begin -->
<script>
    /**
     *
     */
    function readUsers() {
        var url = "index.php?module=azure&event=trigger_get_users_auth&entries_per_page=" + $("#EntriesPerPage").val();
        window.location = url;
    }
    function checkAll(el) {
        var objArray = document.getElementsByName("employee[]");
        if (objArray && objArray.length > 0) {
            for (i = 0; i < objArray.length; i++) {
                objArray[i].checked = el.checked;
            }
        }
    }

    function checkEmployee(id) {
        var objArray = document.getElementsByName("employee[]");
        if (objArray && objArray.length > 0) {
            for (i = 0; i < objArray.length; i++) {
                if (objArray[i].value == id) {
                    objArray[i].checked = (objArray[i].checked)
                            ? false : true;
                }
            }
        }
    }

    function switchPage(page) {
        document.getElementById('pos').value = page;
        submitForm();
    }

    function changeSort(sort) {
        var el = document.getElementById("sort");
        var els = document.getElementById("order");
        if (el) {
            if (el.value == sort) {
                if (els) {
                    els.value = (els.value == "asc") ? "desc" : "asc";
                }
            } else {
                el.value = sort;
            }
            submitForm();
        }
    }

    function keyEvent(event) {
        if (event.keyCode == 13)
            submitForm();
    }

    var iMode = null;

    function importCheck(mode) {

        if (mode == 1 || isChecked()) {

            if (document.getElementById('csvFormat2') == undefined || !document.getElementById('csvFormat2').checked) {

                iMode = mode;
                $("#dialog-PopUpFrameContent").dialog('open');
            } else {
                document.getElementById("iMode").value = mode;

                submitForm();
            }
        } else {
            alert("[% $user->gettext('Bitte selektieren Sie min. einen Mitarbeiter.') %]");
        }
    }

    function isChecked() {
        var objArray = document.getElementsByName("employee[]");
        if (objArray && objArray.length > 0) {
            for (i = 0; i < objArray.length; i++) {
                if (objArray[i].checked) {
                    return true;
                }
            }
        }
        return false;
    }

    function closePopUpFrame() {
        var el = document.getElementById("PopUpFrame");
        var obj = document.getElementById("PopUpFrameContent");
        el.style.visibility = "hidden";
        obj.style.visibility = "hidden";
    }

    function startImport() {
        var el1 = document.getElementById("uMode");
        var el2 = document.getElementById("cMode");

        var pwd1 = $("#passwd1").val();
        var pwd2 = $("#passwd2").val();

        if (el2.checked) {
            $("#FormcMode").val('Y');
        }
        if (el1.checked) {
            $("#FormuMode").val('Y');
        }
        $("#Formpasswd1").val($("#passwd1").val());
        $("#Formpasswd2").val($("#passwd2").val());

        if (el1 && el2 && (el1.checked || el2.checked)) {
            if (el1.checked)
            {
                if (pwd1 != pwd2) {
                    alert("[% $user->gettext('Passwörter stimmen nicht überein. Bitte kontrollieren Sie Ihre Eingabe.') %]");
                } else {
                    if (pwd1 != '') {
                        document.getElementById("iMode").value = iMode;
                        submitForm();
                    } else {
                        alert("[% $user->gettext('Bitte geben Sie ein Standardpasswort ein') %]");
                    }
                }
            } else
            {
                document.getElementById("iMode").value = iMode;
                submitForm();
                //$("#hm").submit();
            }

        } else {
            alert("[% $user->gettext('Bitte geben Sie an als was Sie den Mitarbeiter anlegen wollen') %]");
        }
    }

    function collapseTr() {

        $(".invisible").show();

    }

</script>


<form action="" method="post" name="hm" id="hm" enctype="multipart/form-data" style="margin:0;padding:0;" class="form-inline fcs-form-padding">
    <input type="hidden" name="pos" id="pos" value="[% $pos %]" />
    <input type="hidden" name="sort" id="sort" value="[% $sort %]" />
    <input type="hidden" name="order" id="order" value="[% $order %]" />
    <input type="hidden" name="iMode" id="iMode" value="" />

    <input type="hidden" name="cMode" id="FormcMode" value="" />
    <input type="hidden" name="uMode" id="FormuMode" value="" />
    <input type="hidden" name="passwd1" id="Formpasswd1" value="" />
    <input type="hidden" name="passwd2" id="Formpasswd2" value="" />

    <!-- ###CONTENT### begin -->
    <div class="card panel-fcs-border shadow-sm">
        <div class="card-header">
            <span class="fcs-card-title h2">
                [%$user->gettext('Benutzer aus Azure AD importieren')%]
            </span>
        </div>
        <div class="card-body">
              [% if $AzureErrorMessage %]
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="alert alert-danger">
                                    [% $AzureErrorMessage %].
                                </div>
                            </div>
                        </div>
                    [% /if %]
            <div class="card panel-info shadow-sm rounded">
                <div class="card-body">
                  
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="row">
                                
                                <div class="form-group row mb-3 " style="margin-left: 10px;">
                                    <label class="control-label">[%$user->gettext('Benutzer pro Abruf')%]: </label>
                                    <select id="EntriesPerPage" class="form-control">
                                        <option value="0" [% if !$entries_per_page  %]selected="selected"[% /if %]>[%$user->gettext('Alle')%]</option>
                                        <option value="10" [% if $entries_per_page == 10 %]selected="selected"[% /if %]>10</option>
                                        <option value="50" [% if $entries_per_page == 50 %]selected="selected"[% /if %]>50</option>
                                        <option value="100" [% if $entries_per_page == 100 %]selected="selected"[% /if %]>100</option>
                                        <option value="500" [% if $entries_per_page == 500 %]selected="selected"[% /if %]>500</option>
                                        <option value="999" [% if $entries_per_page == 999 %]selected="selected"[% /if %]>999</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 text-end">
                            <div class="btn-group">
                                [% if !$users%]<a href="javascript: readUsers();" class="btn btn-outline-primary">[% $user->gettext('Azure AD scannen') %]</a>[% /if%]
                                <a href="index.php?module=azure&event=clearData" class="btn btn-outline-primary" >[% $user->gettext('Daten leeren') %]</a>
                                <a href="javascript:import_users();" class="btn btn-outline-primary" >[% $user->gettext('Auswahl importieren') %]</a>
                                <a href="javascript:import_all_users(0);" class="btn btn-outline-primary" >[% $user->gettext('Alle importieren') %]</a>
                            </div>
                            [% if $updated %]<div style="text-align:center;"><strong>Daten wurden importiert...</strong></div>[% /if %]
                        </div>
                    </div>

                </div>

            </div>
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <span class="fcs-card-title h3">[% $user->gettext('Benutzerliste')%]</span>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr class="fields">
                                    <th style="text-align:center !important;">
                                        
                                    </th>
                                    <th style="text-align:center !important;">
                                        [% $user->gettext('id') %]
                                    </th>
                                    <th style="text-align:center !important;">
                                        [% $user->gettext('Typ') %]
                                    </th>
                                    <th style="text-align:center !important;">
                                        [% $user->gettext('Name') %]
                                    </th>
                                    <th style="text-align:center !important;">
                                        [% $user->gettext('Benutzername') %]
                                    </th>
                                    <th style="text-align:center !important;">
                                        [% $user->gettext('Vorname') %]
                                    </th>
                                    <th style="text-align:center !important;">
                                        [% $user->gettext('Nachname') %]
                                    </th>
                                    <th style="text-align:center !important;">
                                        [% $user->gettext('E-Mail') %]
                                    </th>
                                    <th style="text-align:center !important;">
                                        [% $user->gettext('Andere E-Mails') %]
                                    </th>
                                    <th style="text-align:center !important;">
                                        [% $user->gettext('Tel.') %]
                                    </th>
                                    <th style="text-align:center !important;">
                                        [% $user->gettext('Mobil') %]
                                    </th>
                                    <th style="text-align:center !important;">
                                        [% $user->gettext('Straße') %]
                                    </th>
                                    <th style="text-align:center !important;">
                                        [% $user->gettext('PLZ') %]
                                    </th>
                                    <th style="text-align:center !important;">
                                        [% $user->gettext('Stadt') %]
                                    </th>
                                    <th style="text-align:center !important;">
                                        [% $user->gettext('Land') %]
                                    </th>
                                    <th style="text-align:center !important;">
                                        [% $user->gettext('Staat') %]
                                    </th>
                                    <th style="text-align:center !important;">
                                        [% $user->gettext('Position') %]
                                    </th>
                                    <th style="text-align:center !important;">
                                        [% $user->gettext('Abteilung') %]
                                    </th>
                                    <th style="text-align:center !important;">
                                        [% $user->gettext('Firma') %]
                                    </th>
                                    <th style="text-align:center !important;">
                                        [% $user->gettext('Sprache') %]
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                [% foreach from=$users item=$u key=$k %]
                                    <tr>
                                        <td style="text-align:center !important;"><input type="checkbox" class="cb_azure" id="cb_azure_[% $k %]" onchange="addToImport([% $k %])" value="[% $employee.employeeid %]" /></td>
                                        <td style="text-align:center !important;">[% $u.id  %]</td>
                                        <td style="text-align:center !important;">[% if $u.userType == "Member"  %][% $user->gettext('Benutzer') %][% else %][% $user->gettext('Kontakt') %][% /if %]</td>
                                        <td style="text-align:center !important;">[% $u.displayName  %]</td>
                                        <td style="text-align:center !important;">[% $u.userPrincipalName  %]</td>
                                        <td style="text-align:center !important;">[% $u.givenName  %]</td>
                                        <td style="text-align:center !important;">[% $u.surname  %]</td>
                                        <td style="text-align:center !important;">[% $u.mail  %]</td>
                                        <td style="text-align:center !important;">[% $Tools->FCS_Implode($u.otherMails, ', ') %]</td>
                                        <td style="text-align:center !important;">[% $Tools->FCS_Implode($u.businessPhones, ', ') %]</td>
                                        <td style="text-align:center !important;">[% $u.mobilePhone %]</td>
                                        <td style="text-align:center !important;">[% $u.streetAddress  %]</td>
                                        <td style="text-align:center !important;">[% $u.postalCode  %]</td>
                                        <td style="text-align:center !important;">[% $u.city  %]</td>
                                        <td style="text-align:center !important;">[% $u.state  %]</td>
                                        <td style="text-align:center !important;">[% $u.country  %]</td>
                                        <td style="text-align:center !important;">[% $u.jobTitle  %]</td>
                                        <td style="text-align:center !important;">[% $u.department %]</td>
                                        <td style="text-align:center !important;">[% $u.companyName %]</td>
                                        <td style="text-align:center !important;">[% $u.preferredLanguage  %]</td>
                                    </tr>
                                    <tr class="even" id='tr_[% $u.id %]' style='display:none;'>
                                        <td colspan="20" style="text-align:left !important;" id='td_[% $u.id %]'></td>
                                    </tr>
                                [% foreachelse %]
                                    <tr class="even">
                                        <td colspan="20" style="text-align:center !important;">[% $user->gettext('Keine Benutzer zum importieren gefunden...') %]</td>
                                    </tr>
                                [% /foreach %]


                            </tbody>
                        </table>

                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            [% if !$list_full && $users %]
                                <a href='javascript: readUsers();' class='btn btn-outline-primary'>[% $user->gettext('Mehr Benutzer laden')%]</a>
                            [% /if %]
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <div id="dialog-PopUpFrameContent" >
        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <span class="fcs-card-title h5">[% $user->gettext('Standardangaben f&uuml;r die Mitarbeiter') %]</span>
            </div>
            <div class="card-body">
                <div class="form-group row mb-3 row">
                    <label for="cMode" class="control-label col-lg-10">[% $user->gettext('Als Kontakt anlegen:') %]</label>
                    <div class="col-lg-2">
                        <input type="checkbox" name="cMode" value="Y" id="cMode" />
                    </div>
                </div>
                <div class="form-group row mb-3 row">
                    <label for="uMode" class="control-label col-lg-10">[% $user->gettext('Als Benutzer anlegen:') %]</label>
                    <div class="col-lg-2">
                        <input type="checkbox" name="uMode" value="Y" id="uMode" [% if !$ADImport %]onclick="collapseTr()"[% /if %] />
                    </div>
                </div>
                [% if !$ADImport %]

                    <div class="form-group row mb-3 row invisible" id="invisible1" style="display:none;">
                        <label for="passwd1" class="control-label col-lg-4">[% $user->gettext('Passwort') %]:</label>  
                        <div class="col-lg-8">
                            <input type="password" class="form-control" name="passwd1" id="passwd1" autocomplete="off"  />
                        </div>
                    </div>
                    <div class="form-group row mb-3 row invisible" id="invisible2" style="display:none;">
                        <label for="passwd2" class="control-label col-lg-4">[% $user->gettext('Passwort best&auml;tigen') %]:</label>  
                        <div class="col-lg-8">
                            <input type="password" class="form-control" name="passwd2" id="passwd1" autocomplete="off"  />
                        </div>
                    </div>
                [% /if %]
                <div class="btn-group row text-center">
                    <div class="col-lg-6">
                        <input type="button" class="btn btn-outline-primary" value="[% $user->gettext('Importieren') %]" onclick="startImport();" />
                    </div>
                    <div class="col-lg-6">
                        <input type="button" class="btn btn-outline-secondary" value="[% $user->gettext('Abbruch') %]" onclick="$('#dialog-PopUpFrameContent').dialog('close');" />
                    </div>
                </div>
            </div>
        </div>

    </div>
</form>
<!-- Component CSV-Import end -->
<script>
    var to_import = [];
    var index = 0;
    $(".dialog").fancybox({
        maxWidth: 500,
        maxHeight: 300,
        closeClick: false,
        autoOpen: false,
        onClosed: function () {
            parent.location.reload(true);
        }
    });

    $("#dialog-PopUpFrameContent").dialog({
        autoOpen: false,
        maxWidth: 500,
        maxHeight: 300,
        closeClick: false,
        onClosed: function () {
            parent.location.reload(true);
        },
        beforeClose: function (event, ui) {

        }
    });
    Array.prototype.remove = function (x) {
        var i;
        for (i in this) {
            if (this[i].toString() == x.toString()) {
                this.splice(i, 1)
            }
        }
    }
    /**
     * Add to import array
     */
    function addToImport(key) {
        var checked = $("#cb_azure_" + key).is(":checked")

        if (checked) {
            to_import.push(key);
        }
        else{
            to_import.remove(key);
        }

    }
    /**
     * Import selected users
     */
    function import_users() {
        console.log( to_import);
        import_user(0);
    }

    function import_user(code) {
        $.post('index.php?module=azure&event=start_import&code=' + to_import[code], function (data) {
            console.log(data);
            var json = JSON.parse(data);
            $('#tr_' + json.azure_id).show();
            var message = '';
            if (json.message.user.success) {
                message += '<p style="color:green;"><span class="fa fa-square-check"></span> ';
            } else {
                message += '<p style="color:red;"><span class="fa fa-xmark"></span>';
            }

            message += json.message.user.text + '</p>';

            if (json.message.contact.success) {
                message += '<p style="color:green;"><span class="fa fa-square-check"></span> ';
            } else {
                message += '<p style="color:red;"><span class="fa fa-xmark"></span>';
            }

            message += json.message.contact.text + '</p>';
            $('#td_' + json.azure_id).html(message);
            if (code < to_import.length - 1) {
                import_user(code + 1);

            }
        });
    }

    /**
     * Import all users
     */
    function import_all_users(code) {
        $.post('index.php?module=azure&event=start_import&code=' + code, function (data) {
            console.log(data);
            var json = JSON.parse(data);
            $('#tr_' + json.azure_id).show();
            var message = '';
            if (json.message.user.success) {
                message += '<p style="color:green;"><span class="fa fa-square-check"></span> ';
            } else {
                message += '<p style="color:red;"><span class="fa fa-xmark"></span>';
            }

            message += json.message.user.text + '</p>';

            if (json.message.contact.success) {
                message += '<p style="color:green;"><span class="fa fa-square-check"></span> ';
            } else {
                message += '<p style="color:red;"><span class="fa fa-xmark"></span>';
            }

            message += json.message.contact.text + '</p>';
            $('#td_' + json.azure_id).html(message);
            if (json.next_index < [% $count_users %]) {
                import_all_users(json.next_index);

            }
        });
    }

</script>
