<script type="text/javascript">

    function switchPage(pos) {
        document.getElementById("pos").value = pos;
        submitForm();
    }

</script> 

<style>
    .table th{
        cursor: pointer;
    }
</style>

<form action="" method="post" name="hm" onsubmit="return false" id="hm" enctype="multipart/form-data" class="form-horizontal form-label-left" >

    <input type="hidden" id="sort" name="sort" value="[% $sort %]" />
    <input type="hidden" id="sortorder" name="sortorder" value="[% $sortorder %]" />
    <input type="hidden" id="message" name="message" value="0" />
    <input type="hidden" id="type" name="type" value="" />
    <div class="card panel-fcs-border shadow-sm">
        <div class="card-header">
            <span class="fcs-card-title h1">[% $user->gettext('Ticketbewertung Kriterien') %]</span>
        </div>
        <div class="card-body">
            <div class="card panel-info shadow-sm rounded">
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-9" style="padding-left: 30px;">
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group row mb-3">
                                        <label class="control-label col-sm-3">
                                            [% $user->gettext('Eintr&auml;ge pro Seite') %]
                                        </label>
                                        <div class="col-sm-9 text-left">
                                            <select style="width:15%;" name="entries_per_page" onchange="document.hm.submit();" class="form-control">
                                                <option value="10" [% if $entries_per_page == 10 %]selected="selected"[% /if %]>10</option>
                                                <option value="20" [% if $entries_per_page == 20 %]selected="selected"[% /if %]>20</option>
                                                <option value="50" [% if $entries_per_page == 50 %]selected="selected"[% /if %]>50</option>
                                                <option value="100"[% if $entries_per_page == 100 %]selected="selected"[% /if %]>100</option>
                                            </select>&nbsp;&nbsp;&nbsp;
                                        </div>

                                        <input type="hidden" name="pos" value="[% $pos %]" id="pos">
                                    </div>
                                </div>

                            </div>


                        </div>
                        <div class="col-lg-3 text-end">
                            [% if $user->hasRight(36) || $user->hasRight(810) %]
                                <div class="btn-group">
                                    <a href="index.php?module=criteria&event=create" class="btn btn-outline-primary openInBigIFrameModal">[% $user->gettext('Neues Bewertungskriterium') %]</a>
                                </div>
                            [% /if %]         
                        </div>
                    </div>
                </div>
            </div>
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <span class="fcs-card-title h3">
                        [% $entries %]
                        [% if $entries > 1 %] 
                            [% $user->gettext('Bewertungskriterien') %]
                        [% else %]
                            [% $user->gettext('Bewertungskriterium') %]
                        [% /if %]
                        [% $user->gettext('gefunden') %]
                    </span>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr class="fields>">
                                    <th class="sort" id="name">[% $user->gettext('Name') %]</th>
                                    <th class="sort" id="createdby">[% $user->gettext('Ersteller') %]</th>
                                    <th class="sort" id="createdat">[% $user->gettext('Erstellt am') %]</th>
                                    <th class="sort" id="updatedby">[% $user->gettext('Letzte Aktualisierung von') %]</th>
                                    <th class="sort" id="updatedat">[% $user->gettext('Letzte Aktualisierung am') %]</th>
                                    <th class="text-center" id="active">[% $user->gettext('Aktiv') %]</th>
                                    <th class="sort text-center" id="order">[% $user->gettext('Reihenfolge') %]</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                [% foreach from=$cList item=c %]
                                    <tr>
                                        <td title="[% $c.criteria_comment %]"> [% if $smarty.const.STANDARD_CRITERIA == $c.criteria_id %]<span class="fa fa-bookmark" title="[% $user->gettext('Standard Kriterium. Beschreibung wird anstatt Name angezeigt.') %]"></span>[% /if %] [% $c.criteria_name %]</td>
                                        <td>[% $c.created_name %]</td>
                                        <td>[% $c.created_date|date_format:"%d.%m.%Y %H:%M" %]</td>
                                        <td>[% $c.updated_name %]</td>
                                        <td>[% $c.updated_date|date_format:"%d.%m.%Y %H:%M" %]</td>
                                        <td class="text-center"> 
                                            [% if $c.criteria_active == 1 %]
                                                <span class="fa fa-check" style="color:green;"></span>
                                            [% else %]
                                                <span class="fa fa-times" style="color:red;"></span>
                                            [% /if %]
                                        </td>
                                        <td class="text-center">[% $c.criteria_order %]</td>
                                        <td style="text-align:center !important;">
                                            <a href="index.php?module=criteria&event=update&id=[% $c.criteria_id %]" class="btn btn-outline-secondary openInBigIFrameModal"><span class="fa fa-pencil" title="[% $user->gettext('Bearbeiten') %]"></span></a>
                                            <a href="javascript:deleteCriteria([% $c.criteria_id %])" class="btn btn-outline-secondary"><span class="fa fa-trash" title="[% $user->gettext('Löschen') %]"></span></a>

                                        </td>
                                    </tr>
                                [% foreachelse %]
                                    <tr class="even">
                                        <td colspan="9" style="text-align:center !important">[% $user->gettext('Es wurden keine Kriterien gefunden...') %]</td>
                                    </tr>
                                [% /foreach %]
                            </tbody>
                        </table>
                    </div>
                    <div class="col-lg-12 col-sm-12 hidden-sm hidden-xs">
                        <div class="col-lg-6 col-sm-6"></div>
                        <div class="col-lg-6 col-sm-6 text-end">
                            [% $Paging %]
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>



<script>



    var current_sort = $("#sort").val();
    var current_sortorder = $("#sortorder").val();

    showSortIcon();



    $(".sort").on("click", function (e) {
        var sort = $(this).attr('id');
        var sortorder = 'asc';
        if (current_sort === sort) {
            if (current_sortorder === 'asc') {
                sortorder = 'desc';
            } else {
                sortorder = 'asc';
            }
        }
        $("#sort").val(sort);
        $("#sortorder").val(sortorder);
        submitForm();
    })

    function showSortIcon() {
        var content = $("#" + current_sort).html();
        if (current_sortorder == 'desc') {
            content += '<span class="fa fa-chevron-down"></span>';

        } else {
            content += '<span class="fa fa-chevron-up"></span>';
        }
        $("#" + current_sort).html(content);
    }


    function deleteCriteria(id) {
        bootbox.confirm("<b>[% $user->gettext('Kriterium wirklich löschen?')%]</b>", function (result) {
            if (result) {
                $.post('index.php?module=criteria&event=deleteCriteria&id=' + id, function (data) {
                    console.log(data);
                    if (data == 1) {
                        window.location.href = window.location.href;
                    }
                })
            }
        })
    }

    function closeTicketFromIframe() {
        $("#myBigIFrameModal").modal('hide');
        window.location.href = window.location.href;


    }
</script>
