<link rel="stylesheet" type="text/css" href="includes/js/select2/css/select2.min.css"/>
<script type="text/javascript" src="includes/js/select2/js/select2.full.min.js"></script>
<script type="text/javascript" src="includes/js/select2/js/i18n/de.js"></script>

<script type="text/javascript">

    function switchPage(pos) {
        document.getElementById("pos").value = pos;
        submitForm();
    }

</script>

<form action="index.php?module=employee&class=datastructure" id = "hm" method="post" enctype="multipart/form-data">
    <input type="hidden" id="sort" name="sort" value="[% $sort %]" />
    <input type="hidden" id="sortorder" name="sortorder" value="[% $sortorder %]" />
    <input type="hidden" id="message" name="message" value="0" />
    <div class="card panel-fcs-border shadow-sm">
        <div class="card-header">
            <span class="fcs-card-title h2">
                [% $user->gettext('Datenstruktur') %]
            </span>
        </div>
        <div class="card-body">
            <div class="card panel-info shadow-sm rounded">
                <div class="card-body">
                    <p>[% $user->gettext('Hier können Sie die Mitarbeiter Daten durch Datenimport aus einer CSV-Datei anlegen.') %]</p>
                    <p>[% $user->gettext('Bitte laden Sie <b>nur CSV Dateien</b> im folgenden Format hoch') %]:</p>
                    [% if $user->Security->Company == 'Stadt Schwabach' %]
                        <b>[% $user->gettext('Referat') %];[% $user->gettext('Amt') %];[% $user->gettext('Mitarbeiter') %]</b>
                    [% else %]
                        <b>[% $user->gettext('Filiale') %];[% $user->gettext('Mitarbeiter') %];[% $user->gettext('Jobbeschreibung') %]</b>
                    [% /if %]
                    <div class="form-group row mb-3">

                        <div class="col-sm-12">
                            <div class="input-group">
                                <input type="file" name="CSV" class="form-control">
                                <span class="input-group-text btn btn-outline-secondary" onclick="uploadCSV();">[% $user->gettext('Hochladen')%]</span>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <span class="fcs-card-title h3">
                        [% $entries %]
                        [% if $entries > 1 %]
                            [% $user->gettext('Einträge') %]
                        [% else %]
                            [% $user->gettext('Eintrag') %]
                        [% /if %]
                        [% $user->gettext('gefunden') %]
                    </span>
                </div>
                [%*
                <div class="card-body">
                <div class="table-responsive">
                <table class="table table-striped">
                <thead>
                <tr class="fields>">
                <th class="sort" id="branch">[% $user->gettext('Filiale') %]</th>
                <th class="sort" id="employee">[% $user->gettext('Mitarbeiter') %]</th>
                <th class="sort" id="role">[% $user->gettext('Jobbeschreibung') %]</th>
                </tr>
                </thead>
                <tbody>
                [% foreach from=$employee item=e %]
                <tr>
                <td>[% $e.filiale %]</td>
                <td>
                [% if !$e.hmuserid %]
                [% $e.mitarbeiter %]
                [% else %]
                <a href='index.php?module=user&event=edit&id=[% $e.hmuserid %]'>[% $e.mitarbeiter %]</a>
                [% /if %]
                </td>
                <td>[% $e.job %]</td>
                [% foreachelse %]
                <tr class="even">
                <td colspan="9" style="text-align:center !important">[% $user->gettext('Es wurden keine Einträge gefunden...') %]</td>
                </tr>
                [% /foreach %]
                </tbody>
                </table>

                </div>
                <div class="col-lg-12 col-sm-12 hidden-sm hidden-xs">
                <div class="col-lg-6 col-sm-6"></div>
                <div class="col-lg-6 col-sm-6 text-end">
                [% $Paging %]
                </div>
                </div>
                </div>
                *%]


                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr class="fields>">
                                    <th>[% if $user->Security->Company == 'Stadt Schwabach' %][% $user->gettext('Referat') %][% else %][% $user->gettext('Filiale') %][% /if %]</th>
                                    <th>[% if $user->Security->Company == 'Stadt Schwabach' %][% $user->gettext('Mitarbeiter') %][% else %][% $user->gettext('Mitarbeiter') %][% /if %]</th>
                                    <th>[% if $user->Security->Company == 'Stadt Schwabach' %][% $user->gettext('Amt') %][% else %][% $user->gettext('Jobbeschreibung') %][% /if %]</th>
                                </tr>
                            </thead>
                            <tbody>
                                [% foreach from=$Data.Filialen item=Filiale key=FilialID %]

                                    <tr>
                                        <td> [% if $Filiale.disabled %]<del> [% $Filiale.text %]</del>[% else %]    [% $Filiale.text %] [% /if %]                                                                                        

                                            </span>
                                        </td>
                                        <td>
                                            <ul class="list-unstyled">
                                                [% foreach from=$Data['Mitarbeiter'][$Filiale.id]  item=Mitarbeiter %]
                                                    <li style="padding-bottom:5px;">
                                                        [% if $Mitarbeiter.user_id %]
                                                            <a href="index.php?module=user&event=edit&id=[% $Mitarbeiter.user_id %]"> [% $Mitarbeiter.text %]
                                                                ([% $Mitarbeiter.username %])</a>
                                                            [% else %]    [% $Mitarbeiter.text %] 
                                                            [% /if %]       

                                                        <span class="btn btn-outline-secondary btn-xs pull-right" title="[% $user->gettext('Benutzerzuordnung bearbeiten') %]" onclick="editUserID([% $Mitarbeiter.id %], [% $Mitarbeiter.user_id|default:"0" %]);"><span class="fa fa-pencil"></span></span>
                                                    </li>                                                    
                                                [% foreachelse %]
                                                    <li>
                                                        --
                                                    </li>
                                                [% /foreach %]
                                            </ul>                                
                                        </td>
                                        <td>
                                            <ul class="list-unstyled">
                                                [% foreach from=$Data.Jobs[$Filiale.id] item=Jobs %]
                                                    <li>
                                                        [% if $Jobs.disabled %]<del> [% $Jobs.text %]</del>[% else %]    [% $Jobs.text %] [% /if %]       
                                                    </li>
                                                [% foreachelse %]
                                                    <li>
                                                        --
                                                    </li>
                                                [% /foreach %]
                                            </ul>                                                  
                                        </td>
                                    [% foreachelse %]
                                    <tr class="even">
                                        <td colspan="9" style="text-align:center !important">[% $user->gettext('Es wurden keine Einträge gefunden...') %]</td>
                                    </tr>
                                [% /foreach %]
                            </tbody>
                        </table>

                    </div>
                    <div class="col-lg-12 col-sm-12 hidden-sm hidden-xs">
                        <div class="col-lg-6 col-sm-6"></div>
                        <div class="col-lg-6 col-sm-6 text-end">
                            [% $Paging %]
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>                       
</form>

<div class="modal fade" id="UserSelectModal" role="dialog" aria-labelledby="exampleModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="exampleModalLabel">[% $user->gettext('Benutzer auswählen') %]</h4>
            </div>
            <div class="modal-body">
                <form id="connectUserForm">
                    <input type="hidden" id="MitarbeiterID" name="MitarbeiterID" value="" />
                    <div class="form-group row mb-3">
                        <label for="UserID" class="control-label">Benutzer</label>
                        <select  name="UserID" id="UserID" class="form-control" style="width: 100%;">
                            <option value="0">-- [% $user->gettext('Kein Benutzer zugeordnet') %] --</option>
                            [% html_options options=$Users %]
                        </select>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-primary" id="connectUser">[% $user->gettext('Speichern') %]</button>
            </div>
        </div>
    </div>
</div>

<script>
    function uploadCSV() {
        $("#hm").submit();
    }

    var current_sort = $("#sort").val();
    var current_sortorder = $("#sortorder").val();

    showSortIcon();



    $(".sort").on("click", function (e) {
        var sort = $(this).attr('id');
        var sortorder = 'asc';
        if (current_sort === sort) {
            if (current_sortorder === 'asc') {
                sortorder = 'desc';
            } else {
                sortorder = 'asc';
            }
        }
        $("#sort").val(sort);
        $("#sortorder").val(sortorder);
        submitForm();
    })

    function showSortIcon() {
        var content = $("#" + current_sort).html();
        if (current_sortorder == 'desc') {
            content += '<span class="fa fa-chevron-down"></span>';

        } else {
            content += '<span class="fa fa-chevron-up"></span>';
        }
        $("#" + current_sort).html(content);
    }


    function editUserID(MitarbeiterID, UserID) {
        $("#UserID").val(UserID).trigger('change');
        $("#MitarbeiterID").val(MitarbeiterID);
        $("#UserID").select2({theme: 'bootstrap-5'});
        $('#UserSelectModal').modal('show');
    }

    $("#connectUser").on('click', function () {
        var mID = $("#MitarbeiterID").val();
        var uID = $("#UserID").val();
        $.post('index.php?module=employee&class=datastructure&event=connectUser&MitarbeiterID=' + mID + "&UserID=" + uID, function (data) {
            if (data == 1) {
                location.reload();
            }
        })
    })
</script>
