<script type="text/javascript">

    function switchPage(pos) {
        document.getElementById("pos").value = pos;
        $("#ManageClassificationsForm").submit();
    }

</script>
<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <h2 class="card-title-fcs">[% $user->gettext('Klassifikationen verwalten') %]</h2>
    </div>

    <div class="card-body">
        <div class="card panel-info shadow-sm rounded">
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-12">
                        <form action="index.php?module=errorpatterns&event=classifications" method="post" name="hm" id="ManageClassificationsForm" enctype="multipart/form-data" class="form-inline fcs-form-padding">
                            <input type="hidden" name="pos" value="[% $pos %]" id="pos">
                            <div class="form-group row mb-3">
                                        <label class="control-label">
                                            [% $user->gettext('Eintr&auml;ge pro Seite') %]
                                        </label>
                                            <select name="entries_per_page" onchange="document.hm.submit();" class="form-control">                                                
                                                <option value="10" [% if $entries_per_page == 10 %]selected="selected"[% /if %]>10</option>
                                                <option value="20" [% if $entries_per_page == 20 %]selected="selected"[% /if %]>20</option>
                                                <option value="50" [% if $entries_per_page == 50 %]selected="selected"[% /if %]>50</option>
                                                <option value="100" [% if $entries_per_page == 100 %]selected="selected"[% /if %]>100</option>
                                            </select>&nbsp;&nbsp;&nbsp;

                                    </div>
                            <div class="form-group row mb-3">
                                <label class="control-label">[% $user->gettext('Maschinentyp wählen') %]</label>

                                <select name="AssetTypeID" id="AssetType" class="select2 form-control" onchange=" document.getElementById('pos').value =1; $('#ManageClassificationsForm').submit(); ">
                                    <option value="0">-- [% $user->gettext('Alle Klassifikationen anzeigen') %] --</option>
                                    [% foreach $AssetTypes as $AssetType %]
                                        <option value="[% $AssetType.devicetypeid %]" [% if $AssetTypeID == $AssetType.devicetypeid %]selected[% /if %]>[% $AssetType.devicetypeid %] - [% $AssetType.typename %]</option>
                                    [% /foreach %]
                                </select>

                            </div>

                            <div class="form-group row mb-3">
                                <label class=" control-label">[% $user->gettext('Hauptbaugruppen') %]</label>

                                <select name="Filter[MainGroupID]" id="MainGroupID" class="form-control" onchange="document.getElementById('pos').value =1; $('#ManageClassificationsForm').submit();">
                                    <option value="0">-- [% $user->gettext('Alle HBGs anzeigen') %] --</option>
                                    [% html_options options=$filterMainGroups selected=$Filter.MainGroupID %]
                                </select>

                            </div>

                            <div class="form-group row mb-3">
                                <label class=" control-label">[% $user->gettext('Symptome / Komponenten') %]</label>

                                <select name="Filter[Symptome]" id="MainGroupID" class="form-control" onchange="document.getElementById('pos').value =1; $('#ManageClassificationsForm').submit();">
                                    <option value="0" [% if $Filter.Symptome == 0 %]selected[% /if %]>[% $user->gettext('Symptome und Komponenten') %]</option>
                                    <option value="1" [% if $Filter.Symptome == 1 %]selected[% /if %]>[% $user->gettext('Nur Symptome') %]</option>
                                    <option value="2" [% if $Filter.Symptome == 2 %]selected[% /if %]>[% $user->gettext('Nur Komponenten') %]</option>
                                </select>

                            </div>                                    

                        </form>
                    </div>
                </div>
            </div>
        </div>

        [% if $AssetTypeID > 0 %]
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <div class="row">
                        <div class="col-sm-6">
                            <span class="fcs-card-title h4">[% $AddClassificationTitle %]</span>
                        </div>
                        <div class="col-sm-6 text-end">
                            <div class="btn-group">

                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <form action="" class="form-inline fcs-form-padding" >
                                <div class="form-group row mb-3">
                                    <label class="control-label">[% $user->gettext('Hauptbaugruppe') %]</label>
                                        <select name="MainGroupID" id="selectMainGroupID" class="select2" style="width:100%">
                                            <option>-- [% $user->gettext('Hauptgruppe wählen') %] --</option>
                                            [% foreach $MainGroups as $MainGroup %]
                                                <option value="[% $MainGroup.id %]">[% $MainGroup.codekey %] - [% $MainGroup.descr_de %] ([% $MainGroup.descr_en %])</option>
                                            [% /foreach %]
                                        </select>
                                </div>
                                <div class="form-group row mb-3">
                                    <label class="control-label">[% $user->gettext('Unterbaugruppe') %]</label>
                                        <select name="SubGroupID[]" id="selectSubGroupID" class="select2"  style="width:100%">
                                            <option>-- [% $user->gettext('Untergruppe wählen') %] --</option>
                                        </select>
                                </div>
                                <div class="form-group row mb-3">
                                    <span class="btn btn-outline-secondary" id="addToAssetType">[% $selectedAssetType.typename %] [% $user->gettext('zuweisen') %]</span>
                                </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4 text-left" >
                            <h3 class="card-title text-left" style="font-size: 24px; display:inline">
                                [% $user->gettext('Klassifikationen')%] [% $user->gettext('für') %] [% $selectedAssetType.typename %]
                            </h3>
                        </div>
                        <div class="text-end">
                            [%*
                            <div class="form-group row mb-3">
                            <span class="btn btn-outline-secondary" id="CSVExport" onclick="OnExportCSV();"><span class="fa fa-download"></span> CSV Export</span>
                            <button id="btnAddPattern" class="btn btn-outline-secondary" type="button" role="button" onclick="OnAddPattern();">[% $user->gettext('Hinzufügen')%]</button>
                            </div>
                            *%]
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="ErrorPatternTable" class="table">
                            <thead>
                                <tr>
                                    <th>[% $user->gettext('Code HBG')%]</th>
                                    <th>[% $user->gettext('DE')%]</th>
                                    <th>[% $user->gettext('EN')%]</th>


                                    <th>[% $user->gettext('Code UBG')%]</th>
                                    <th>[% $user->gettext('DE')%]</th>
                                    <th>[% $user->gettext('EN')%]</th>

                                    <th>[% $user->gettext('Code')%]</th>
                                    <th>[% $user->gettext('DE')%]</th>
                                    <th>[% $user->gettext('EN')%]</th>
                                    <th>[% $user->gettext('Anz. Fehlerbilder')%]</th>
                                    <th>[% $user->gettext('Aktion')%]</th>
                                </tr>
                            </thead>
                            <tbody id="ErrorPatternTableBody">
                                [% foreach from=$Classifications item=cl %]
                                    <tr>
                                        <td>[% $cl.mg_codekey %]</td>
                                        <td>[% $cl.mg_de %]</td>
                                        <td>[% $cl.mg_en %]</td>

                                        [% if $cl.mg_symptome == 1 %]
                                            <td colspan='6' class='text-left'><strong>[% $user->gettext('Symptom') %]</strong></td>
                                                [% else %]
                                            <td>[% $cl.sg_codekey  %]</td>
                                            <td>[% $cl.sg_de %]</td>
                                            <td>[% $cl.sg_en %]</td>

                                            <td>[% $cl.mg_codekey %] -- [% $cl.sg_codekey %]</td>
                                            <td>[% $cl.mg_de %] -- [% $cl.sg_de %]</td>
                                            <td>[% $cl.mg_en %] -- [% $cl.sg_en %]</td>
                                        [% /if %]
                                        <td>[% $cl.cnteps %]</td>
                                        <td>
                                            <a href="index.php?module=errorpatterns&event=removeErrorPatternToClassification&atid=[% $AssetTypeID %]&mgid=[% $cl.mg_id %]&sgid=[% $cl.sg_id %]" class="btn btn-outline-secondary btn-sm" title='[% $user->gettext('Klassifikation aus Assettyp entfernen') %]'><span class="fa fa-times"></span> </a>

                                            <a href="index.php?module=errorpatterns&event=addErrorPatternToClassification&atid=[% $AssetTypeID %]&mgid=[% $cl.mg_id %]&sgid=[% $cl.sg_id %]" class="btn btn-outline-secondary btn-sm openInLargeModal"><span class="fa fa-plus"></span> [% $user->gettext('Fehlerbild') %]</a>
                                        </td>
                                    </tr>
                                [% /foreach %]

                            </tbody>
                        </table>
                    </div>
                    <div class="col-lg-12 col-sm-12 hidden-sm hidden-xs">
                        <div class="col-lg-6 col-sm-6"></div>
                        <div class="col-lg-6 col-sm-6 text-end">
                            [% $Paging %]
                        </div>
                    </div>    
                </div>
            </div>
        [% else %]
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <div class="row">
                        <div class="col-sm-6">
                            <span class="fcs-card-title h4">[% $user->gettext('Alle Klassifikationen') %]</span>
                        </div>
                        <div class="col-sm-6 text-end">
                            <div class="btn-group">
                                <a href="index.php?module=errorpatterns&event=addclassifications" class="btn btn-outline-secondary">[% $user->gettext('Klassifikation zufügen') %]</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="ErrorPatternTable" class="table">
                            <thead>
                                <tr>
                                    <th>[% $user->gettext('Code HBG')%]</th>
                                    <th>[% $user->gettext('DE')%]</th>
                                    <th>[% $user->gettext('EN')%]</th>
                                    <th></th>
                                    <th>[% $user->gettext('Code UBG')%]</th>
                                    <th>[% $user->gettext('DE')%]</th>
                                    <th>[% $user->gettext('EN')%]</th>
                                    <th></th>
                                    <th>[% $user->gettext('Code')%]</th>
                                    <th>[% $user->gettext('DE')%]</th>
                                    <th>[% $user->gettext('EN')%]</th>
                                    <th>[% $user->gettext('Tickets')%]</th>
                                </tr>
                            </thead>
                            <tbody id="ErrorPatternTableBody">
                                [% foreach from=$Classifications item=cl %]
                                    <tr>
                                        <td>
                                            [% $cl.mg_codekey %]
                                        </td>
                                        <td>[% $cl.mg_de %]</td>
                                        <td>[% $cl.mg_en %]</td>
                                        <td>
                                            <a href="index.php?module=errorpatterns&event=editclassification&id=[% $cl.mg_id %]" class="btn btn-outline-secondary btn-xs" title="[% $user->gettext('Hauptbaugruppe bearbeiten') %]"><span class="fa fa-pencil"></span></a>
                                                [% if !$cl.mgtickets && !$cl.cntsubgroups  %]
                                                <a href="index.php?module=errorpatterns&event=deleteclassifiction&id=[% $cl.mg_id %]" class="btn btn-outline-secondary btn-xs" title="[% $user->gettext('HG löschen') %]"><span class="fa fa-times"></span></a>
                                                [% /if %]
                                        </td>

                                        [% if $cl.mg_symptome == 1 %]
                                            <td colspan='7' class='text-left'><strong>[% $user->gettext('Symptom') %]</strong></td>
                                                [% else %]                                    
                                            <td>[% $cl.sg_codekey %]</td>
                                            <td>[% $cl.sg_de %]</td>
                                            <td>[% $cl.sg_en %]</td>
                                            <td>
                                                <a href="index.php?module=errorpatterns&event=editclassification&id=[% $cl.sg_id %]" class="btn btn-outline-secondary btn-xs" title="[% $user->gettext('Unterbaugruppe bearbeiten') %]"><span class="fa fa-pencil"></span></a>
                                                    [% if !$cl.sgtickets %]
                                                    <a href="index.php?module=errorpatterns&event=deleteclassifiction&id=[% $cl.sg_id %]" class="btn btn-outline-secondary btn-xs" title="[% $user->gettext('UBG löschen') %]"><span class="fa fa-times"></span></a>
                                                    [% /if %]
                                            </td>
                                            <td>[% $cl.mg_codekey %] -- [% $cl.sg_codekey %]</td>
                                            <td>[% $cl.mg_de %] -- [% $cl.sg_de %]</td>
                                            <td>[% $cl.mg_en %] -- [% $cl.sg_en %]</td>
                                        [% /if %]
                                        <td>[% if $cl.cnttickets %]<a href="index.php?module=ticketlist&ClassificationCode=[% $cl.mg_id %]_[% $cl.sg_id %]" target="_blank">[% $cl.cnttickets %]</a>[% /if %]</td>
                                    </tr>
                                [% /foreach %]
                            </tbody>
                        </table>
                    </div>
                    <div class="col-lg-12 col-sm-12 hidden-sm hidden-xs">
                        <div class="col-lg-6 col-sm-6"></div>
                        <div class="col-lg-6 col-sm-6 text-end">
                            [% $Paging %]
                        </div>
                    </div>      
                </div>
            </div>
        [% /if %]
    </div>
</div>
<script>
    $('.select2').select2({theme: 'bootstrap-5'});

    $('#selectMainGroupID').on('change', function (e) {
        selectMainGroupID = $('#selectMainGroupID').val();
        $('#selectSubGroupID').empty();
        $('#selectSubGroupID').select2({theme: 'bootstrap-5',
            multiple: true,
            closeOnSelect: false,
            scrollAfterSelect: true,
            width: 'resolve',
            ajax: {
                url: 'index.php?module=errorpatterns&event=getSubGroupsForMainGroupID&mgid=' + selectMainGroupID,
                dataType: 'json'
            }
        }).width('100%');
    })

    $('#addToAssetType').on('click', function (e) {

        $.ajax({
            type: "POST",
            url: "index.php?module=errorpatterns&event=addClassificationToAssettype",
            data: {AssetTypeID: $('#AssetType').val(), MainGroupID: $('#selectMainGroupID').val(), SubGroupID: $('#selectSubGroupID').val()}
        }).done(function (response) {
            if (response.error) {
                noty({
                    text: response.message,
                    type: 'error',
                    timeout: notifyTimeout
                });
            } else {
                noty({
                    text: response.message,
                    type: 'success',
                    timeout: notifyTimeout
                });
                //Neuer Tag angelegt und verknüpft
//                var newOption = new Option(response.name, response.newID, false, true);
//                $('#MainGroupID').append(newOption).trigger('change');
//                $('#NewMainGroupModal').modal('hide');
            }
        });

    })
    $(".select2").select2({theme: 'bootstrap-5'});
</script>
