<form action = "index.php?module=field&event=updateField&id=[% $field.field_id %]" method="POST" class="form-horizontal form-label-left">
    <input type="hidden" name="saveField" value="1">
    <input type="hidden" name="fieldID" value="[% $field.field_id %]">
    <input type="hidden" name="fieldName" value="[% $field.field_name %]">
    [% if $message == 1 %]
        <div class="alert alert-success" role="alert">
            [% $user->gettext('Feld aktualisiert. Bitte die Liste neu laden, oder weiter bearbeiten.') %]
        </div>
    [% elseif $message == -1 %]
        <div class="alert alert-danger" role="alert">
            [% $user->gettext('Feld konnte momentan nicht aktualisiert werden') %]
        </div>
    [% elseif $message == -2 %]
        <div class="alert alert-danger" role="alert">
            [% $user->gettext('Es gibt schon ein Feld mit diesem Namen.') %]
        </div>
    [% /if %]
    <div class="card panel-fcs-border shadow-sm">
        <div class="card-header">
            <div class="row">
                <div class="col-sm-6">
                    <span class="fcs-card-title h3">
                        [% $user->gettext('Feld bearbeiten') %]:[% $field.field_name %]
                    </span>
                    [% if $onlyshow %]
                        <p><i>[% $user->gettext('Das Feld ist momentan einem Tickettyp zugewiesen. Sie können nur Name und Kommentar aktualisieren.') %]</i></p>
                    [% /if %]
                </div>
                <div class="col-sm-6 text-end">
                    <div class="btn-group">
                        <button class="btn btn-outline-primary">[% $user->gettext('Speichern') %]</button>
                    </div>
                </div>
            </div>

        </div>
        <div class="card-body">
            <div class="form-group row mb-3">
                <label class="col-sm-3 control-label">
                    [% $user->gettext('Feldname') %]:
                </label>
                <div class="col-sm-9">
                    <input type="text" required value="[% $field.field_name %]" class="form-control" name="field_name">
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-3 control-label">
                    [% $user->gettext('Kommentar') %]:
                </label>
                <div class="col-sm-9">
                    <input type="text" value="[% $field.comment %]" class="form-control" name="field_comment" placeholder="[% $user->gettext('Empfohlen, um das Feld zu identifizieren') %]">
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-3 control-label">
                    [% $user->gettext('Feldtyp') %]:
                </label>
                <div class="col-sm-9">
                    <select class="form-control" name="field_type" id="typeChange" [% if $onlyshow %]disabled="disabled"[% /if %]>
                        <option value="0">[% $user->gettext('Feldtyp auswählen') %]</option>
                        <option value="text" [% if $field.field_type=='text' %]selected[% /if %]>[% $user->gettext('Textfeld') %]</option>
                        <option value="textarea" [% if $field.field_type=='textarea' %]selected[% /if %]>[% $user->gettext('Textbereich') %]</option>
                        <option value="checkbox" [% if $field.field_type=='checkbox' %]selected[% /if %]>[% $user->gettext('Check Box') %]</option>
                    </select>
                </div>
            </div>

            <div id="fieldDiv">
                [% if $field.field_type == 'text' %]
                    <div class="form-group row mb-3">
                        <label class="col-sm-3 control-label">
                            [% $user->gettext('Datentyp') %]:
                        </label>
                        <div class="col-sm-9">
                            <select id="form_check" class="form-control" name="check" [% if $onlyshow %]disabled="disabled"[% /if %]>
                                <option value="">[% $user->gettext('Texte') %]</option>
                                <option value="int" [% if $field.field_validation.check == "int" %]selected[% /if %]>[% $user->gettext('Nur Zahlen') %]</option>
                                <option value="dmY" [% if $field.field_validation.check == "dmY" %]selected[% /if %]>[% $user->gettext('Datum (d.m.Y)') %]</option>
                                <option value="dmYhm" [% if $field.field_validation.check == "dmYhm" %]selected[% /if %]>[% $user->gettext('Datum + Zeit') %]</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-sm-3 control-label">
                            [% $user->gettext('Passwort') %]:
                        </label>
                        <div class="col-sm-9" [% if $onlyshow %]disabled="disabled"[% /if %]>
                            <input type="checkbox" name="password" [% if $field.field_validation.password %]checked[% /if %] >
                        </div>
                    </div>
                [% /if %]

                [% if $field.field_type == 'select' || $field.field_type == 'radio'  %]
                    <div class="form-group row mb-3">
                        <label class="col-sm-3 control-label">
                            [% $user->gettext('Optionen') %]:
                        </label>
                        <div class="col-sm-9">
                            <div id="field_options">
                                [% foreach from=$field.field_validation.options key=k item=option %]
                                    <div class="input-group" id="opt_[% $k %]">
                                        <input [% if $onlyshow %]readonly[% /if %] type="text" class="form-control options" name="options[]"  value="[% $option %]" placeholder="Option" />
                                        [% if !$onlyshow %]<div class="input-group-text"><span class="fa fa-trash" onclick="$('#opt_[% $k %]').remove();"></span></div>[% /if %]
                                    </div>
                                [% /foreach %]
                            </div>
                            [% if !$onlyshow %]<a class="btn btn-outline-secondary" onclick="addOption();"><span class="fa fa-plus"></span>Option hinzufügen</a>[% /if %]
                        </div>
                    </div>
                [% /if %]
            </div>

        </div>
    </div>

</form>

<script>

    var optNum = 0;

    function addOption() {
        $("#field_options").append(
                `
                                <div class="input-group" id="opt_add_` + optNum + `">
                                        <input type="text" class="form-control options" name="options[]"  value="" placeholder="Option" />
                                        <div class="input-group-text"><span class="fa fa-trash" onclick="$('#opt_add_` + optNum + `').remove();"></span></div>
                                </div>
                                `
                );
        optNum++;
    }

    $("#typeChange").on('change', function () {
        updateFieldList();
    })

    function updateFieldList() {
        var field_type = $("#typeChange").val();
        if (field_type == "text") {
            addText();
        }
        if (field_type == "textarea" || field_type == "0" || field_type == "checkbox") {
            addTextarea();
        }

        if (field_type == "select" || field_type == "radio") {
            addSelect();
        }
    }

    function addText() {
        $("#fieldDiv").empty();
        $("#fieldDiv").append(
                `<div class="form-group row mb-3">
                <label class="control-panel col-lg-3">
    [% $user->gettext('Wert pr&uuml;fen auf') %]:
                </label>
                <div class="col-lg-9">
                    <select id="form_check" class="form-control" name="check">
                        <option value=""></option>
                        <option value="dmY">[% $user->gettext('Datum (d.m.Y)') %]</option>
                        <option value="dmYhm">[% $user->gettext('Datum + Zeit') %]</option>
                    </select>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="control-panel col-lg-3">
    [% $user->gettext('Passwortfeld') %]:
                </label>
                <div class="col-lg-9">
                    <input type="checkbox" id="form_pass" name="password" />
                </div>
            </div>
            
        `);
    }

    function addSelect() {
        $("#fieldDiv").empty();
        $("#fieldDiv").append(
                `<div class="form-group row mb-3">
            <label class="control-panel col-lg-3">
    [% $user->gettext('Optionen') %]:
            </label>
            <div class="col-lg-9">
                <input type="text" class="form-control options" name="options[]" placeholder="Option" />
                <div id="field_options">
                </div>
                <a class="btn btn-outline-secondary" onclick="addOption();"><span class="fa fa-plus"></span>Option hinzufügen</a>
            </div>
        </div>`
                );
    }

    function addTextarea() {
        $("#fieldDiv").empty();
    }


</script>