IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[SelectRequiredActionTickets]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE [dbo].[SelectRequiredActionTickets]
GO

CREATE PROCEDURE SelectRequiredActionTickets
(
    @StatusID int,
    @UserID int = 0
)
AS 
 	SELECT
        COUNT(*) AS CountTickets
    FROM
        hm_Ticket
        LEFT JOIN hm_TicketSupporter ON hm_Ticket.ID = hm_TicketSupporter.TicketID
    WHERE
        TicketStatusID = @StatusID
        AND
        (
            ContactID = @UserID
            OR hm_TicketSupporter.UserID = @UserID
            OR @UserID = 0
        ) 
GO

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[SelectActiveMasterTickets]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE [dbo].[SelectActiveMasterTickets]
GO

CREATE PROCEDURE SelectActiveMasterTickets
AS 
    CREATE TABLE #TempTickets
    (
    ServiceBulletin VARCHAR(MAX) NULL,
    TicketDesireDate DATETIME NULL,
    Active INT NULL,
    Done INT NULL
    )

    SELECT DISTINCT TicketReferenzID
    INTO   #TempOpenMasterTickets
    FROM   hm_Ticket
    WHERE TicketStatusID != 3 AND TicketStatusID != 9 AND TicketReferenzID IS NOT NULL

    DECLARE @MasterTicketID int

    WHILE (SELECT Count(*) FROM #TempOpenMasterTickets) > 0
    BEGIN
	    SELECT TOP 1 @MasterTicketID = TicketReferenzID FROM #TempOpenMasterTickets
	    SELECT ID
	    INTO   #TempActiveChilds
	    FROM   hm_Ticket
	    WHERE TicketStatusID != 3 AND TicketStatusID != 9 AND TicketReferenzID = @MasterTicketID

	    SELECT ID
	    INTO   #TempDoneChilds
	    FROM   hm_Ticket
	    WHERE (TicketStatusID = 3 OR TicketStatusID = 9) AND TicketReferenzID = @MasterTicketID

	    INSERT INTO
		    #TempTickets
	    SELECT
		    hm_UserDefFieldValue.Value AS ServiceBulletin, hm_Ticket.TicketDesireDate, (SELECT COUNT(*) FROM #TempActiveChilds) AS Active, (SELECT COUNT(*) FROM #TempDoneChilds) AS Done
	    FROM 
		    hm_Ticket
			LEFT JOIN hm_UserDefFieldValueTicket ON hm_Ticket.ID = hm_UserDefFieldValueTicket.TicketID
			LEFT JOIN hm_UserDefFieldValue ON hm_UserDefFieldValueTicket.UserDefFieldValueID = hm_UserDefFieldValue.UserDefFieldValueID
			LEFT JOIN hm_UserDefField ON hm_UserDefFieldValue.UserDefFieldID = hm_UserDefField.UserDefFieldID
	    WHERE 
		    hm_Ticket.ID = @MasterTicketID AND hm_UserDefField.FieldName = 'Service Bulletins / Service Information'
	    GROUP BY
		    hm_Ticket.ID, hm_Ticket.TicketDesireDate, hm_UserDefFieldValue.Value

	    DROP TABLE #TempActiveChilds
	    DROP TABLE #TempDoneChilds

	    DELETE #TempOpenMasterTickets WHERE TicketReferenzID = @MasterTicketID
    END

    DROP TABLE #TempOpenMasterTickets

    SELECT * FROM #TempTickets

    DROP TABLE #TempTickets
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_TicketEvent' AND COLUMN_NAME = 'IsFinancialCommitment')
    ALTER TABLE [dbo].[hm_TicketEvent] ADD [IsFinancialCommitment] [tinyint] NOT NULL DEFAULT (0)
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_TicketEvent' AND COLUMN_NAME = 'FinancialCommitmentComment')
    ALTER TABLE [dbo].[hm_TicketEvent] ADD [FinancialCommitmentComment] [varchar](MAX) NULL
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 5000)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, SegmentID, RightsOrder, RightDescr) VALUES (5000, 'Gewährleistung', 1, 24, 52, 'Mit diesem Recht darf der Nutzer Bearbeitung als Finanzielle Zusage markieren.');
GO
