<script type="text/javascript" src="includes/js/bs_DataTables/dataTables.min.js"></script>
<link rel="stylesheet" type="text/css" href="includes/js/bs_DataTables/dataTables.min.css" media="screen" />

<style>
    img {
        max-width: 100%;
        height: auto;
    }

    .selectedTableRow{
        background-color: lightgrey;
    }
</style> 

<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <div class="row">
            <div class="col-sm-6">
                <h2 class="card-title-fcs">                    
                    [% $user->gettext('BOT Matching') %]
                </h2>
            </div>
            <div class="col-sm-6 text-end">     
                <a href="index.php?module=knowledgebase&fid=[% $FAQEntry.faq.faqdataid %]" class="btn btn-outline-secondary">[% $user->gettext('Zum Artikel') %]</a>                                            
                <div class="btn-group">
                    <a href="index.php?module=knowledgebase&event=BotMatcher&fid=[% $PrevFAQ %]" class="btn btn-outline-primary [% if !$PrevFAQ %]disabled[% /if %]"><span class="fa fa-chevron-left"></span> [% $user->gettext('Vorheriger Artikel') %]</a>
                    <a href="index.php?module=knowledgebase&event=BotMatcher&fid=[% $NextFAQ %]" class="btn btn-outline-primary [% if !$NextFAQ %]disabled[% /if %]">[% $user->gettext('Nächster Artikel') %] <span class="fa fa-chevron-right"></span></a>
                </div>
            </div>
        </div>        

    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-6">                   
                        <div class="card panel-info shadow-sm rounded">
                            <div class="card-header">
                                <h3 class="card-title">                                    
                                    [% $user->gettext('Knowledgebasebeitrag') %]                                    
                                </h3>
                            </div>
                            <div class="card-body">                                                                   

                                <div id="FAQEntry">
                                    [% if $FAQEntry.category.faqcategoryid > 0 %]
                                        <a href="?module=knowledgebase&cid=[% $FAQEntry.category.faqcategoryid %]" class="Category">[% $FAQEntry.category.name %]</a>
                                    [% /if %]
                                    <h3>[% $FAQEntry.faq.shortdescription %]</h3>

                                    <div>
                                        [% $FAQEntry.faq.description %]
                                    </div>

                                    <p>
                                        [% if $FAQEntry.faq.attachment && $user->UserID %]
                                        <h4>
                                            [% if $Tools->FCS_Count($FAQEntry.attachments) == 1 %]
                                                [% $user->gettext('Beigef&uuml;gtes Dokument') %]
                                            [% else %]
                                                [% $user->gettext('Beigef&uuml;gte Dokumente') %]
                                            [% /if %]:
                                        </h4>
                                        <ul class="list-inline">

                                            [% foreach from=$FAQEntry.attachments item=attachment %]
                                                <li>     
                                                    <a 
                                                        [% if $attachment.attachmenttypid != 2 %]
                                                            [% if $attachment.thumbnail != '' %]
                                                                href="index.php?module=upload&class=download&event=ShowImage&name=[% $attachment.changedfilename %]" class="ImageDialog btn btn-link" target="top">
                                                            [% else %]
                                                                href="index.php?module=upload&class=download&id=[% $attachment.attachmentid %]" class="btn btn-link"target="top">
                                                            [% /if %]
                                                        [% else %]
                                                            href="[% $attachment.url %]" target="top">
                                                        [% /if %]
                                                        [% $attachment.shortdescr %] 
                                                        <img src="
                                                             [% if $attachment.thumbnail != '' %]
                                                                 index.php?module=upload&class=download&event=ShowImage&name=[% $attachment.thumbnail %]
                                                             [% else %]
                                                                 [% $attachment.mimetyp %]
                                                             [% /if %]" class="help" width="20" height="20" border="0" title="[% $attachment.shortdescr %]&#10;[% $attachment.longdescr  %][% if $attachment.attachmenttypid == 2 %]: [% $attachment.url %][% /if %]"  />
                                                    </a>
                                                </li>
                                            [% /foreach %]                                                        
                                            <li>
                                                <a href="index.php?module=upload&class=download&event=view&kbid=[% $FAQEntry.faq.faqdataid %]" class="btn btn-outline-secondary">[% $user->gettext('&Uuml;bersicht') %]</a>
                                            </li>
                                        </ul>                
                                    [% /if %]
                                    <hr />
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <strong>[% $user->gettext('Letzte Änderung') %]:</strong> [% $FAQEntry.faq.updatedate|date_format:"%d.%m.%Y %H:%M" %]                            
                                        </div>
                                        <div class="col-sm-6 text-end">
                                            <strong>[% $user->gettext('Verfasser') %]:</strong> [% $FAQEntry.faq.createuser %]                            
                                        </div>

                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6">
                                        </div>
                                        <div class="col-sm-6 text-end">
                                            <strong>[% $user->gettext('Letzte Änderung von') %]:</strong> [% $FAQEntry.faq.updateuser %]                            
                                        </div>
                                    </div>                                                            
                                    </p>

                                    [% if $FAQEntry.categories %]
                                        <fieldset id="rubriken">
                                            <legend class="bg-info">[% $user->gettext('Rubriken zu diesem Artikel') %]</legend>
                                            <ul class="list-inline">
                                                [% foreach from=$FAQEntry.categories item=category %]
                                                    <li><a href="?module=knowledgebase&cid=[% $category.faqcategoryid %]" class="btn btn-outline-secondary">[% $category.name %]</a></li>
                                                    [% /foreach %]
                                            </ul>
                                        </fieldset>			
                                    [% /if %]

                                    [% if $showRating %]
                                        <fieldset id="Voting" style="clear:both;">
                                            <legend class="bg-info p-2">[% $user->gettext('Bewertung der N&uuml;tzlichkeit dieses Artikels') %]:</legend>

                                            <div style="margin:5px;">		
                                                <b>[% $user->gettext('Durchschnittliche Bewertung') %]:</b> 
                                                [% $FAQEntry.voting.rating %]
                                            </div>

                                            [% if $FAQEntry.voting.voted == 0 %]
                                                <div>
                                                    [% $user->gettext('vollkommen &uuml;berflüssig') %]
                                                    <input type="radio" name="voting" value="1" /> 1  
                                                    <input type="radio" name="voting" value="2" /> 2
                                                    <input type="radio" name="voting" value="3" /> 3
                                                    <input type="radio" name="voting" value="4" /> 4 
                                                    <input type="radio" name="voting" value="5" /> 5 
                                                    [% $user->gettext('sehr wertvoll') %]
                                                </div>
                                            [% /if %]
                                        </fieldset>
                                        <br/>
                                    [% /if %]


                                </div>    


                            </div>
                        </div>

                        <div class="card panel-info shadow-sm rounded">
                            <div class="card-header">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <span class="fcs-card-title h4">[% $user->gettext('Ticketvorschau') %]</span>
                                    </div>
                                    <div class="col-sm-6 text-end">                                        
                                    </div>
                                </div>
                            </div>
                            <div class="card-body" id="TicketPreview">
                                <p>[% $user->gettext('Klicken Sie ein Ticket in der Tabelle an um hier eine Vorschau des Tickets zu erhalten.') %]</p>
                            </div>
                        </div>  

                    </div>
                    <div class="col-md-6">
                        <form action="index.php?module=knowledgebase&event=BotMatcher&fid=[% $FAQEntry.faq.faqdataid %]" method="POST" enctype="multipart/form-data" class="form-inline" id="MatchingForm">
                            <input type="hidden" name="fid" value="[% $FAQEntry.faq.faqdataid %]"/>
                            <input type="hidden" name="save" value="1" />
                            <div class="card panel-info shadow-sm rounded">
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <span class="fcs-card-title h4">[% $user->gettext('Matching Tickets') %]</span>
                                        </div>
                                        <div class="col-sm-6">                                        
                                            <input type="text" id="SearchInput" class="form-control" placeholder="[% $user->gettext('Filter') %]"/>
                                            <input type="submit" class="btn btn-outline-secondary pull-right" value="[% $user->gettext('Matching speichern') %]" />
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">

                                    <div class="table-responsive">
                                        <table class="table table-hover table-bordered">
                                            <thead>
                                                <tr>
                                                    <td>[% $user->gettext('') %]</td>
                                                    <td>[% $user->gettext('ID') %]</td>
                                                    <td>[% $user->gettext('Titel') %]</td>
                                                    <td>[% $user->gettext('Trefferquote') %]</td>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                [% foreach from=$Tickets item=Ticket %]
                                                    <tr class="ticket-in-list" id="Ticket_[% $Ticket.id %]" data-tid="[% $Ticket.id %]">
                                                        <td><input type="checkbox" name="confirmedTickets[[% $Ticket.id %]]" value="1" class="form-control" [% if $Ticket.confirmed %]checked[% /if %]/></td>
                                                        <td class="filterField"><a href="index.php?module=ticket&event=show&tid=[% $Ticket.id %]" target="_blank">#[% $Ticket.id %]</a></td>
                                                        <td class="filterField">[% $Ticket.ticketdescr %]</td>
                                                        <td>[% $Ticket.cosine %]</td>
                                                    </tr>
                                                [% foreachelse %]
                                                    <tr>
                                                        <td colspan="4">
                                                            [% $user->gettext('Keine treffenden Tickets zu diesem Eintrag gefunden') %]
                                                        </td>
                                                    </tr>
                                                [% /foreach %]
                                            </tbody>
                                        </table>
                                    </div>

                                </div>
                            </div>
                        </form>


                    </div>
                </div>     
            </div>
        </div>                
    </div>
</div>

<script>
    $(document).ready(function () {
        $(".ImageDialog").fancybox();
    });

    $(".ticket-in-list").on('click', function (e) {
        tid = $(this).data('tid');
        $(".ticket-in-list").removeClass('selectedTableRow');
        $("#Ticket_" + tid).addClass('selectedTableRow');
        url = "index.php?module=ticket&event=showTicketPreview&tid=" + tid;

        $("#TicketPreview").fadeOut().on("load", url).fadeIn();
    });


    function toggleSearch() {
        var val = $("#SearchInput").val();
        if (val.trim() != "") {

            $(".ticket-in-list").hide();
            //var divs = $(".ticketdescr:containsCI(" + val + ")");
            var divs = $(".filterField:containsCI(" + val + ")");
            var res = [];

            divs.each(function () {
                //console.log($(this));
                //res.push(findCollapsedPanel($(this).parents()));
                $(this).parents().show();
            });
        } else {
            $(".ticket-in-list").show();
        }

    }

    $("#SearchInput").keyup(function (e) {
        //if (e.keyCode == 13) {
        toggleSearch();
        //}
    });

    $.expr[":"].containsCI = $.expr.createPseudo(function (arg) {
        return function (elem) {
            return $(elem).text().toUpperCase().indexOf(arg.toUpperCase()) >= 0;
        };
    });

    $('.table').DataTable({
        stateSave: true,
        "sPaginationType": "full_numbers",
        "bLengthChange": true,
        "iDisplayLength": 10,
        "oLanguage": {
            "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
            "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
            "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
            "sInfoEmpty": " ",
            "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
            "sSearch": "Filter",
            "oPaginate": {
                "sFirst": "&lt;&lt;",
                "sLast": "&gt;&gt;",
                "sNext": "&gt;",
                "sPrevious": "&lt;"
            },
            "aaSorting": [[1, "asc"]]
        }
    });
</script>
