<style>
.kb-content {
  max-height: 20em;
  overflow: hidden;
  position: relative;
  transition: max-height 0.5s ease;
}

.kb-content.expanded {
  max-height: 1000em; /* quasi unendlich */
}

.toggle-content-btn {
  font-size: 0.9rem;
}
</style>


<div class="card panel-info shadow-sm rounded" style="max-width: 100%;">
    <div class="card-body portlet-content">
        [% if $Tools->FCS_Count($FAQSearchResult) == 0 %]
        <span>[% $user->gettext('Es wurden keine KnowledegeBase Einträge gefunden') %]</span>
        [% else %]    
        <div class="row">

        [% foreach from=$FAQSearchResult item=result %]            
            <div class="col-12">
                <div class="card shadow-sm border rounded-3">
                    <div class="card-header d-flex justify-content-between align-items-center">

                        <div class="d-flex align-items-center">
                                [% if  $result.Thumbnail  %]
                                    <img src='index.php?module=upload&class=download&event=ShowImage&name=Medium_[%  $result.Thumbnail %]' class="me-3 rounded"  style="max-height: 50px;  object-fit: cover;">
                                [% /if %]
                            <h5 class="mb-0">[% $result.ShortDescription %]</h5>
                        </div>


                        <div class="btn-group">
                            <button class="btn btn-outline-primary lightContrast" title="[% $user->gettext('Knowledgebase Artikel Link in die Beschreibung einfügen') %]" onclick="CopyLinkIntoDescription(`[% $result.ShortDescription|escape:"quotes" %]`, '[% $result.FAQDataID %]', '[% $result.FAQCategoryID %]')"><i class="fa fa-plus"></i></button>
                            <button class="btn btn-outline-primary lightContrast" title="[% $user->gettext('Knowledgebase Artikel in die Beschreibung einfügen') %]" onclick="CopyTextIntoDescription(`[% $result.Description|escape:"html" %]`, '[% $result.FAQDataID %]', '[% $result.FAQCategoryID %]')"><i class="fa fa-paste"></i></button>
                            <a href="index.php?module=knowledgebase&fid=[% $result.FAQDataID %]&cid=[% $result.FAQCategoryID %]" target="_blank" title="[% $user->gettext('Knowledgebase Artikel anzeigen') %]" class="btn btn-outline-primary lightContrast"><i class="fa fa-link"></i></a>
                        </div>     
                    </div>

  <div class="card-body">
    <div class="kb-content collapsed" id="kb-content-[% $result.FAQDataID %]">
      <p>
        [% $result.Description %]
      </p>
    </div>
    <button class="btn btn-link px-0 toggle-content-btn d-none" data-target="#kb-content-[% $result.FAQDataID %]">[% $user->gettext('Mehr anzeigen') %]</button>
  </div>
                    <div class="card-body">
                        <p class="card-text">
                        
                        </p>
                    </div>
                </div>
            </div>
        [% /foreach %]

        </div>
        [% /if %]
    </div>
</div>

<script>
document.getElementById('SearchKBEntryModal').addEventListener('shown.bs.modal', function () {
  // Modal ist jetzt vollständig sichtbar und DOM ist gerendert
  document.querySelectorAll('.toggle-content-btn').forEach(button => {
    const target = document.querySelector(button.dataset.target);
    
    if (target.scrollHeight > target.offsetHeight + 1) {
      button.classList.remove('d-none');

      // Sicherstellen, dass Event nur einmal gebunden wird
      if (!button.dataset.bound) {
        button.addEventListener('click', function () {
          const expanded = target.classList.toggle('expanded');
          this.textContent = expanded ? 'Weniger anzeigen' : 'Mehr anzeigen';
        });
        button.dataset.bound = 'true';
      }
    }
  });
});

</script>
