
<!-- Component Project Type begin -->


<script src="includes/js/dropzone.js"></script>
<link href="includes/js/dropzone.css" rel="stylesheet" type="text/css" />
<link rel="stylesheet" href="includes/jstree/jstree.min.css" />
<script src="includes/jstree/jstree.min.js"></script>
<script src="includes/js/crypto-js.min.js"></script>
 

<style>
    .booked > label {
        display: inline-block;
        width: 2.5em;
    }
</style>
[% if $id > 0 %]
    <script>
        var ProjectID = [% $id %];
        [% if $project.documenttree %]
            var HasTree = true;
            [% else %]
                 var HasTree = false;
        [% /if %]
    </script>
[% /if %]

<form action="index.php?module=project&event=[% if $id > 0 %]edit&id=[% $id %][% else %]newProject[% /if %]" method="post" name="project" class="form-horizontal form-label-left">


    <input type="hidden" name="search[pos]" id="pos" value="[% $pos %]" />
    <input type="hidden" name="search[orderby]" id="sort" value="[% $sort %]" />
    <input type="hidden" name="search[ordering]" id="sortorder" value="[% $ordering %]" />

    <input type="hidden" id="ProjectID" value="[% if $id > 0 %][% $id %][% else %]0[% /if %]" />


    <div class="card panel-fcs-border shadow-sm">
        <div class="card-header">
            <h2 class="card-title-fcs">[% if $id > 0 %][% $user->gettext('Projekt bearbeiten') %]: [% $project.projectname %] (#[% $id %])[% else %][% $user->gettext('Neues Projekt anlegen') %][% /if %]</h3>
        </div>
        <div class="card-body">
            <div class="card panel-info shadow-sm rounded">
                <div class="card-body">

                    [% if $error || $Tools->FCS_Count($errors) %]


                        [% if $error == 202 %]
                            <div class="alert alert-success" id="project_success">
                                [% $user->gettext('Das Projekt wurde erfolgreich aktualisiert.') %]
                            </div>
                        [% /if %]
                        [% if $error == 404 %]
                            <div class="alert alert-danger" id="project_error">
                                [% $user->gettext('Das Projekt konnte nicht gefunden werden.') %]
                            </div>

                        [% /if %]
                        [% if $error == 500 %]
                            <div class="alert alert-danger" id="project_error">
                                [% $user->gettext('Das Projekt konnte nicht gespeichert werden.') %]
                            </div>
                        [% /if %]
                        [% if $Tools->FCS_Count($errors) %]

                            [% foreach from=$errors item=element %]
                                <div class="alert alert-danger" >[% $user->gettext($element) %]</div>
                            [% /foreach %]

                        [% /if %]


                    [% /if %]
                    <div class="btn-group">

                        [% if $user->hasRight(504) && $id > 0 && $project.running == 1 && $user->hasRight(1) %]
                            <input type="button" onclick="window.open('index.php?module=ticket&event=newTicket&pid=[% $id %]', 'NewTicket');" value="[% $user->gettext('Neues Ticket') %]" class="btn btn-outline-primary" />
                        [% /if %]
                        [% if $smarty.const.HISTORY && $user->hasRight(1200) %]
                            <a href="index.php?module=history&class=project&pid=[% $id %]" class="btn btn-outline-secondary">[% $user->gettext('Historie')%] </a>
                        [% /if %]
                        <input type="button" value="[% $user->gettext('Liste') %]" class="btn btn-outline-secondary" onclick="window.location.href = 'index.php?module=project';"/>
                        [% if $user->hasRight(502) %]
                            <input type="submit" value="[% $user->gettext('Speichern') %]" class="btn btn-outline-primary" />
                            [% if $id > 0 %]
                                <input type="button" value="[% $user->gettext('Projekt löschen') %]" class="btn btn-outline-primary" onclick="bootbox.confirm('[% $user->gettext('Projekt wirklich unwiderruflich löschen?') %]', function (result) {
                                            if (result) {
                                                window.location.href = 'index.php?module=project&event=delete&projectid=[% $id %]';
                                            }
                                        })" />
                            [% /if %]
                        [% /if %]

                    </div>
                </div>
            </div>

            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <h3 class="card-title">[% if $id > 0 %][% $project.projectname %][% else %][% $user->gettext('Neues Projekt anlegen') %][% /if %]</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group row mb-3 [% if $errors.projecttypeid %]has-error[% /if %]">
                                <label class="col-lg-3 control-label" for="ProjectTypeID">[% $user->gettext('Projekttyp') %]</label>
                                <div class="col-lg-9">
                                    <select size="1" name="ProjectTypeID" id="ProjectTypeID" class="form-select" style="width:100%;" onchange="selectProjectType(this);">
                                        <option value="0" [% if $project.projecttypeid < 1 %]selected="selected"[% /if %]>&gt;&gt;[% $user->gettext('Bitte wählen Sie einen Projekttyp') %]&lt;&lt;</option>
                                        [% html_options options=$types selected=$project.projecttypeid %]
                                    </select>
                                    <span class="required"></span>
                                </div>
                            </div>



                            <div class="form-group row mb-3">
                                <label class="col-lg-3 control-label" for="ProjectName">[% $user->gettext('Projektname') %]</label>
                                <div class="col-lg-9">
                                    <input type="text" size="40" maxlength="255" name="ProjectName" id="ProjectName" class="form-control required" value="[% $project.projectname %]" required="required" />
                                </div>
                            </div>

                            <div class="form-group row mb-3">
                                <label class="col-lg-3 control-label">[% $user->gettext('Beschreibung') %]</label>
                                <div class="col-lg-9">
                                    <div id="quillEditor">
                                        [% $user->getQuillToolbar() %]
                                        <div id="editor" style="min-height: 200px;">

                                        </div>
                                    </div>
                                    <textarea name="Description" id = "LongDescr" class="form-control" style="height: 0px; visibility:hidden;">[% $project.description %]</textarea>
                                </div>
                            </div>


                        </div>     <!--linke Spalte ende-->

                        <div class="col-md-6">
                            [% if $id > 0 %]
                                <div class="form-group row mb-3">
                                    <label class="col-lg-3 control-label" for="Status">[% $user->gettext('Projektstatus') %]</label>
                                    <div class="col-lg-9">
                                        <p class="form-control-static">[% $project.pstatus %]</p>
                                    </div>
                                </div>      
                            [% /if %]

                            <div class="form-group row mb-3">
                                <label class="col-lg-3 control-label" for="Active">[% $user->gettext('Aktiv') %]</label>
                                <div class="col-lg-9">
                                    <input type="checkbox" value="1" id="Active" name="Active" [% if $project.active == 1 %]checked="checked"[% /if %] />
                                </div>
                            </div>
                            <div class="form-group row mb-3">
                                <label class="col-lg-3 control-label" for="ProjectEmployeeID">[% $user->gettext('Verantwortlicher') %]</label>

                                <div class="col-lg-9">
                                    <select name="ProjectEmployeeID" id="ProjectEmployeeID" class="form-select" style="width:100%;" data-selected-text-format="count>-1"
                                            data-count-selected-text= "{0} [%$user->gettext('gewählt')%]" data-actions-box="true">
                                        [% html_options options=$Employees selected=$project.projectemployeeid %]
                                    </select>
                                </div>
                            </div>

                             <div class="form-group row mb-3">
                                <label class="col-lg-3 control-label" for="ProjectEmployeeID">[% $user->gettext('Ansprechpartner (Benutzer)') %]</label>
                                <div class="col-lg-9">
                                    <select name="UserIDs[]" id="UserIDs" class="form-select multiple" style="width:100%;" data-selected-text-format="count>-1"
                                            data-count-selected-text= "{0} [%$user->gettext('gewählt')%]" data-actions-box="true" multiple="multiple">
                                        [% foreach $users as $id=>$user %]
                                            <option value="[% $id %]" [% if fcs_in_array($id, $selected_users) %]selected="selected"[% /if %]>[% $user %]</option>
                                         [% /foreach %]
                                    </select>
                                </div>
                            </div>       
                            <div class="form-group row mb-3">
                                <label class="col-lg-3 control-label" for="ProjectEmployeeID">[% $user->gettext('Ansprechpartner (Gruppe)') %]</label>
                                <div class="col-lg-9">
                                    <select name="GroupIDs[]" id="GroupIDs" class="form-select multiple" style="width:100%;" data-selected-text-format="count>-1"
                                            data-count-selected-text= "{0} [%$user->gettext('gewählt')%]" data-actions-box="true" multiple="multiple">
                                        [% foreach $groups as $id=>$group %]
                                            <option value="[% $id %]" [% if fcs_in_array($id, $selected_groups) %]selected="selected"[% /if %]>[% $group %]</option>
                                            [% /foreach %]
                                    </select>
                                </div>
                            </div>

                            [% if $ref_level1_name|trim != "" %]
                                <div class="form-group row mb-3">
                                    <label class="col-lg-3 control-label">[% $user->gettext($ref_level1_name) %]</label>
                                    <div class="col-lg-9">
                                        <select size="1" name="Level1ID[]" class="form-control" style="width:100%;" id="Level1ID" onchange="selectLevel1ID(this);">
                                            [% if $project.projecttypeid > 0 %]
                                                [% if $Tools->FCS_Count($project.ref_level1) %]
                                                    [% if $project.level1id|trim == "" %]<option value="">[% $user->gettext('>> Bitte wählen Sie... <<') %]</option>[% /if %]
                                                    [% html_options options=$project.ref_level1 selected=$project.level1id %]
                                                [% else %]
                                                    <option value="">[% $user->gettext('>> Keine Auswahl möglich <<') %]</option>
                                                [% /if %]
                                            [% else %]
                                                <option value="">[% $user->gettext('>> Bitte erst Projekttyp wählen <<') %]</option>
                                            [% /if %]
                                        </select>
                                    </div>
                                </div>
                            [% /if %]
                            [% if $ref_level2_name|trim != "" %]
                                <div class="form-group row mb-3">
                                    <label class="col-lg-3 control-label">[% $user->gettext($ref_level2_name) %]</label>
                                    <div class="col-lg-9">
                                        <select size="15" name="Level2ID[]" multiple="multiple" class="form-control" style="width:100%;" id="Level2ID">
                                            [% if $project.projecttypeid > 0 %]
                                                [% if $Tools->FCS_Count($project.ref_level2) %]
                                                    [% html_options options=$project.ref_level2 selected=$project.level2id %]
                                                [% else %]
                                                    <option value="">[% $user->gettext('>> Keine Auswahl möglich <<') %]</option>
                                                [% /if %]
                                            [% else %]
                                                <option value="">[% $user->gettext('>> Bitte erst Projekttyp wählen <<') %]</option>
                                            [% /if %]
                                        </select>
                                    </div>
                                </div>
                            [% /if %]

                            <div class="form-group row mb-3">
                                <label class="col-lg-3 control-label" for="ProjectFactor">[% $user->gettext('Projektfaktor') %]</label>
                                <div class="col-lg-9">
                                    <input type="text"maxlength="15" name="ProjectFactor" id="ProjectFactor" class="form-control" value="[% $project.projectfactor %]" />
                                    <span class="help-block">[% $user->gettext('Ist der Projektfaktor größer 0 wird dieser mit den aus den Tickets verbuchten Aufwänden multipliziert.') %]</span>
                                </div>
                            </div>

                        </div>
                                
                     
                        <div class="col-md-12">
                            <div class="card panel-info shadow-sm rounded">
                                <div class="card-body row">


                                    <div class="col-md-6">
                                        [% if $user->hasRight(507) %]
                                        <div class="form-group row mb-3">
                                            <label class="col-lg-3 control-label">[% $user->gettext('Laufzeit') %]</label>
                                            <div class="col-lg-9">
                                                <div class="col-md-6">
                                                    <div class="form-group row mb-3 [% if $errors.startdate %]has-error[% /if %]">
                                                        <label class="col-lg-3 control-label" for="StartDate">[% $user->gettext('von') %]</label>
                                                        <div class="col-lg-9">
                                                            <input type="text" size="10" maxlength="10" name="StartDate" id="StartDate" class="form-control datepicker" value="[% if $project.startdate %][% $project.startdate %][% else %][% $smarty.now|date_format:"%d.%m.%Y" %][% /if %]" />
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group row mb-3 [% if $errors.enddate %]has-error[% /if %]">
                                                        <label class="col-lg-3 control-label" for="EndDate">[% $user->gettext('bis') %]</label>
                                                        <div class="col-lg-9">
                                                            <input type="text" size="10" maxlength="10" name="EndDate" id="EndDate" class="form-control datepicker [% if $errors.enddate %]form-controlerror[% /if %]" value="[% if $project.enddate %][% $project.enddate %][% else %][% $smarty.now|date_format:"%d.%m.%Y" %][% /if %]" />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        [% /if %]
                                        [% if $user->hasRight(506) %]
                                        <div class="form-group row mb-3">
                                            <label class="col-lg-3 control-label" for="EstimatedBudget">[% $user->gettext('Budget') %]</label>
                                            <div class="col-lg-9">
                                                <div class="col-md-12">
                                                    <div class="input-group">
                                                        <input type="text" maxlength="15" name="EstimatedBudget" id="EstimatedBudget" class="form-control" value="[% $project.estimatedbudget %]" />
                                                        <span class="input-group-text">[% if $hmcompany == 'OTTO FISCHER AG' %]CHF[% else %][% $user->getCurrencyDescr() %][% /if %]</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        [% /if %]
                                    </div>
                                    [% if $user->hasRight(506) %]
                                    <div class="col-md-6">

                                        <div class="form-group row mb-3">
                                            <label class="col-lg-3 control-label">[% $user->gettext('Kosten') %]</label>
                                            <div class="col-lg-9">
                                                <div class="col-md-6">
                                                    <div class="form-group row mb-3">
                                                        <label class="col-lg-3 control-label">[% $user->gettext('SOLL') %]</label>
                                                        <div class="col-lg-9">
                                                            <div class="input-group">
                                                                <input type="text" size="13" maxlength="15" class="form-control readonly" value="[% $project.runningcosts %]" readonly="readonly"  style="cursor:help;" title="[% $user->gettext('Der SOLL Wert berechnen sich aus dem Budget, der Projektdauer und dem aktuellen Zeitpunkt im Projekt (Budget / Gesamtdauer * Laufzeit)') %]" />
                                                                <span class="input-group-text">[% if $hmcompany == 'OTTO FISCHER AG' %]CHF[% else %][% $user->getCurrencyDescr() %][% /if %]</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group row mb-3">
                                                        <label class="col-lg-3 control-label">[% $user->gettext('IST') %]</label>
                                                        <div class="col-lg-9">
                                                            <div class="input-group">
                                                                <input type="text" size="13" maxlength="15" name="UsedBudget" class="form-control readonly" value="[% $project.usedbudget %]" readonly="readonly" />
                                                                <span class="input-group-text">[% if $hmcompany == 'OTTO FISCHER AG' %]CHF[% else %][% $user->getCurrencyDescr() %][% /if %]</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>


                                        [% if $project.department %]
                                            <div class="form-group row mb-3">
                                                <label class="col-lg-3 control-label">[% $user->gettext('Abteilung') %]</label>
                                                <div class="col-lg-9">
                                                    <p class="form-control-static">
                                                        [% $project.department %]
                                                    </p>
                                                </div>
                                            </div>
                                        [% /if %]


                                        <div class="form-group row mb-3">
                                            <label class="col-lg-3 control-label">[% $user->gettext('Gesamter Aufwand') %]</label>
                                            <div class="col-lg-9">
                                                <div class="col-md-6"><input type="text" size="13" maxlength="15" class="form-control readonly" value="[% $project.completeexpense_human %]" readonly="readonly" /></div>
                                                <div class="col-md-6">   <div class="input-group">
                                                        <input type="text" size="13" maxlength="15" class="form-control readonly" value="[% $project.completeexpense %]" readonly="readonly" />
                                                        <span class="input-group-text">[% $user->gettext('Minuten') %]</span>
                                                    </div></div>


                                            </div>

                                        </div>
                                    </div>
                                                    [% /if %]
                                </div>
                            </div>
                        </div>
                                                   
                        <div class="col-md-12">
                            [% if $hmcompany == 'ALIGIA GMBH' %]
                                <div class="card panel-info shadow-sm rounded">
                                    <div class="card-header">
                                        <h3 class="card-title">[% $user->gettext('Fakturiert') %]</h3>
                                    </div>
                                    <div class="card-body">
                                        <table class="table">
                                            <tr class="even">
                                                <td>[% $user->gettext('Fakturiert') %]:</td>
                                                <td colspan="6" class="booked">
                                                    <label for="invoiced[1]" >Jan.</label>
                                                    <input type="text" name="invoiced[1]" size="9" value="[% $project.invoiced_1 %]"/>
                                                    <label for="invoiced[2]" >Feb.</label>
                                                    <input type="text" name="invoiced[2]" size="9" value="[% $project.invoiced_2 %]"/>
                                                    <label for="invoiced[3]" >März</label>
                                                    <input type="text" name="invoiced[3]" size="9" value="[% $project.invoiced_3 %]"/>
                                                    <label for="invoiced[4]" >Apr.
                                                    </label>
                                                    <input type="text" name="invoiced[4]" size="9" value="[% $project.invoiced_4 %]"/>
                                                    <label for="invoiced[5]" >Mai
                                                    </label>
                                                    <input type="text" name="invoiced[5]" size="9" value="[% $project.invoiced_5 %]"/>
                                                    <label for="invoiced[6]">Juni
                                                    </label>
                                                    <input type="text" name="invoiced[6]" size="9" value="[% $project.invoiced_6 %]" />
                                                    <br/>
                                                    <label for="invoiced[7]">Juli
                                                    </label>
                                                    <input type="text" name="invoiced[7]" size="9"  value="[% $project.invoiced_7 %]"/>
                                                    <label for="invoiced[8]">Aug.
                                                    </label>
                                                    <input type="text" name="invoiced[8]" size="9" value="[% $project.invoiced_8 %]"/>
                                                    <label for="invoiced[9]">Sep.
                                                    </label>
                                                    <input type="text" name="invoiced[9]" size="9" value="[% $project.invoiced_9 %]"/>
                                                    <label for="invoiced[10]">Okt.
                                                    </label>
                                                    <input type="text" name="invoiced[10]" size="9" value="[% $project.invoiced_10 %]"/>
                                                    <label for="invoiced[11]">Nov.
                                                    </label>
                                                    <input type="text" name="invoiced[11]" size="9" value="[% $project.invoiced_11 %]"/>
                                                    <label for="invoiced[12]">Dez.
                                                    </label>
                                                    <input type="text" name="invoiced[12]" size="9" value="[% $project.invoiced_12 %]"/>
                                                </td>
                                            </tr>
                                            <tr class="even">
                                                <td>[% $user->gettext('Abschlag') %]:</td>
                                                <td colspan="6" class="booked">
                                                    <label for="deduction[1]" >Q1</label>
                                                    <input type="text" name="deduction[1]" size="9" value="[% $project.deduction_1 %]"/>

                                                    <label for="deduction[2]" >Q2</label>
                                                    <input type="text" name="deduction[2]" size="9" value="[% $project.deduction_2 %]"/>

                                                    <label for="deduction[3]" >Q3</label>
                                                    <input type="text" name="deduction[3]" size="9" value="[% $project.deduction_3 %]"/>

                                                    <label for="deduction[4]" >Q4</label>
                                                    <input type="text" name="deduction[4]" size="9" value="[% $project.deduction_4 %]"/>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            [% /if %]
                        </div>

                    </div>

                </div>
            </div>

             [% if $smarty.const.USEDOCUMENTTREE !== 1  %]
            <div id="DocumentsItem" class="card panel-info shadow-sm rounded">
                <div class="card-header" role="tab" id="headingDocuments">
                    <a class="collapsed" role="button" id="DocumentTabLink" data-toggle="collapse" data-parent="#DEACTIVEleftAccordion" href="#DocumentsPanel" aria-expanded="false" aria-controls="collapseContact">
                        <div class="row">
                            <div class="col-6">
                                <h4 class="card-title">
                                    [% $user->gettext('Dokumente') %]
                                </h4>
                            </div>
                            <div class="col-6 text-end">
                                <span class="fa fa-paperclip"></span> <span id="DocumentCount">[% $AttachmentCount %]</span>
                            </div>
                        </div>
                    </a>
                </div>
                <div id="DocumentsPanel" class="panel-collapse in" role="tabpanel" aria-labelledby="headingDocuments">
                    <div class="card-body">
                        <div id="AttachmentList" style="position: relative !important; ">[% $user->gettext('Keine Dokumente vorhanden') %]</div>

                        <div id="DropzoneField" class="well">
                            <div class="dz-message">
                                <h3>[% $user->gettext('Dokumente hinzuf&uuml;gen') %]</h3>
                                [% $user->gettext('Dateien zum Upload (auch mehrere) hier hereinziehen oder klicken zur Dateiauswahl') %]
                            </div>
                            <div class="fallback">
                                <input name="file" type="file" multiple />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            [% /if %]
            [% if $id > 0 && $smarty.const.USEDOCUMENTTREE == 1  %]
                <div id="DocumentTree" class="card panel-info shadow-sm rounded">
                    <div class="card-header" role="tab" id="headingDocuments">
                        <a class="collapsed" role="button" id="DocumentTabLink" data-toggle="collapse" data-parent="#DEACTIVEleftAccordion" href="#DocumentsPanel" aria-expanded="false" aria-controls="collapseContact">
                            <div class="row">
                                <div class="col-12">
                                    <h3 class="card-title-fcs" style="display:inline">
                                        [% $user->gettext('Dokumentenbaum') %]
                                    </h3>
                                    [% if $project.hastree %]
                                        [% if $project.docTreeFileExist %]                                            
                                            <a id="justDownloadZip" target="_blank" href="index.php?module=project&event=createZipAndDownload&justDownload&id=[% $id %]" class="btn btn-outline-primary" title="Existierende Datei [% $project.docTreeFile.name %] vom [% $project.docTreeFile.date %] mit [% $project.docTreeFile.size %] herunterladen"><i class="fa-solid fa-download"></i></a>
                                            <a id="DownloadZIP" target="_blank" href='index.php?module=project&event=createZipAndDownload&id=[% $id %]' class="btn btn-outline-primary" title="[% $user->gettext('Dokumentenbaum neu zippen und herunterladen') %]"><i class="far fa-file-archive"></i></a>
                                        [% else %]
                                            <a id="DownloadZIP" target="_blank" href='index.php?module=project&event=createZipAndDownload&id=[% $id %]' class="btn btn-outline-primary">[% $user->gettext('Dokumentenbaum als ZIP-Datei herunterladen') %]</a>
                                        [% /if %]


                                    <a id="ExportTree" target="_blank" href='index.php?module=project&event=ExportTreeToExcel&ProjectID=[% $id %]' class="btn btn-outline-primary" title="[% $user->gettext('Dokumentenbaum als Excel exportieren') %]"><i class="fa-regular fa-file-excel"></i></a>
                                    [% else if $project.documenttree  %]
                                    <a target="_blank" href='index.php?module=project&event=edit&id=[% $id %]&downloadZip=1' class="btn btn-outline-primary">[% $user->gettext('Dokumentenbaum als ZIP-Datei herunterladen') %]</a>
                                     <a id="ExportTree" target="_blank" href='index.php?module=project&event=edit&id=[% $id %]&exportTree=1' class="btn btn-outline-primary">[% $user->gettext('Dokumentenbaum als Excel exportieren') %]</a>
                                    [% /if %]
                                </div>
                                <div class="col-6 text-end">

                            </div>
                            </div>
                        </a>
                    </div>
                    <div id="DocumentsPanel" class="panel-collapse in" role="tabpanel" aria-labelledby="headingDocuments">
                        <div class="card-body">
                         
                            [% if $project.documenttree %]
                                <div id="DocTree" style="margin-bottom: 30px;"></div>

                            <div id="DocTree2" style="margin-bottom: 30px;"></div>
                            [% /if %]
                        
                            <div id="dropArea" class="well dropArea">
                                <div class="dz-message">
                                    <h3>[% $user->gettext('Neuen Ordner hochladen') %]</h3>
                                    [% $user->gettext('Ordner zum Upload hier bitte hereinziehen') %]
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            [% /if %]



            [% if $id > 0 %]
                <div class="row">
                    <div class="col-md-12">
                        <iframe src="index.php?module=project&class=projectticket&pid=[% $project.projectid %]&iframe=1&showTicketsInIFrame=1" width="98%" border="0" frameborder="0" height="600"></iframe>
                    </div>
                </div>
                [% if $Tools->FCS_Count($project.contract) %]
                    <div class="card panel-info shadow-sm rounded">
                        <div class="card-header">
                            <h3 class="card-title">[% $user->gettext('Wartungsvertrag') %]</h3>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>[% $user->gettext('Kostenstelle') %]</th>
                                            <th>[% $user->gettext('Interne Nummer') %]</th>
                                            <th>[% $user->gettext('Vertragsnummer') %]</th>
                                            <th>[% $user->gettext('Zuständig') %]</th>
                                            <th>[% $user->gettext('Bezeichnung') %]</th>
                                            <th>[% $user->gettext('Vertragswert') %]</th>
                                            <th>[% $user->gettext('Gültig ab') %]</th>
                                            <th>[% $user->gettext('Gültig bis') %]</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        [% foreach from=$project.contract item=contract %]
                                            <tr>
                                                <td>[% $contract.costcenter %] - [% $contract.cdesc %]</td>
                                                <td>[% $contract.inventoryno %]</td>
                                                <td>[% $contract.contractno %]</td>
                                                <td>[% $contract.description %]</td>
                                                <td>[% $contract.name %][% if $contract.name != '' && $contract.prename != '' %], [% /if %][% $contract.prename %]</td>
                                                <td>[% $contract.contractvalue|number_format:2:",":"." %] [% if $hmcompany == 'OTTO FISCHER AG'%]CHF[% else %][% $user->getCurrencyDescr() %][% /if %]</td>
                                                <td>[% $contract.validfrom|date_format:"%d.%m.%Y" %]</td>
                                                <td>[% $contract.validto|date_format:"%d.%m.%Y" %]</td>
                                            </tr>
                                        [% /foreach %]
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                [% /if %]
            </div>
        [% /if %]
    </div>
</div>
</div>
</form>

<!-- Trigger the modal with a button -->

<!-- Modal -->
<div id="UploadModal" class="modal fade" data-bs-backdrop='static' role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <div class="row">
                    <div class="col-sm-11"><h4 class="modal-title">[% $user->gettext('Dateien und Dokumentenstruktur werden hochgeladen...') %]</h4></div>
                    
                </div>
                
            </div>
            <div class="modal-body">
                <div class="alert alert-info" id="SuccessAlert">[% $user->gettext('Bitte warten Sie, bis alle Uploads fertig sind.') %]</div>
                <div id="FileUpload" style="">
                    <div id="FileFound" style="display:none;">
                        <div class="" id = "ProgressSection"  style="max-height: 500px; overflow-y: scroll">

                        </div>
                    </div>

                </div>
                <p></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal" onclick="window.location.href = 'index.php?module=project&event=edit&id=[% $id%]';" id="CloseUpload">[% $user->gettext("Fertig") %]</button>
            </div>
        </div>

    </div>
</div>
            
<div id="UploadFileModal" class="modal fade" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
                <h4 class="modal-title">[% $user->gettext('Datei hochladen') %]</h4>
            </div>
            <div class="modal-body">
                <div class="alert alert-info" id="SuccessAlertFile" style="display:none;">[% $user->gettext('Bitte warten Sie, bis das Upload fertig ist.') %]</div>
                <div id="SingleFileUpload" style="display:none;">
                    <p>[% $user->gettext('Datei') %] <b id="SingleFileName"></b> [% $user->gettext('wird hochgeladen') %]</p>
                     <div class="progress"><div class="progress-bar progress-bar-info" id="FileBar_Single" role="progressbar" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100" style="width:0%"></div></div>
                     <p id="StatusError_Single" style="color:red;"></p>
                     <p style="color:red;" id="ErrorNotice_Single"></p>
                </div>
                <div id="SingleFileDrop" class="well">
                            <div class="dz-message">
                                <h3>[% $user->gettext('Datei hochladen') %]</h3>
                                [% $user->gettext('Datei zum Upload hier hereinziehen') %]
                            </div>
                </div>
            </div>
            <div class="modal-footer">
            </div>
        </div>

    </div>
</div>
    
<div id="UploadFileTreeModal" class="modal fade" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
                <h4 class="modal-title">[% $user->gettext('Ordner hochladen') %]</h4>
            </div>
            <div class="modal-body">

                            [% if $project.documenttree %]
                                <div id="newDocTree" style="margin-bottom: 30px;">
                                </div>
                            [% /if %]
                        
                            <div id="dropAreaSubTree" class="well dropAreaSubTree">
                                <div class="dz-message">
                                    <h3>[% $user->gettext('Neuen Ordner hochladen') %]</h3>
                                    [% $user->gettext('Ordner zum Upload hier bitte hereinziehen') %]
                                </div>
                            </div>
                <input type="checkbox" value="1" name="overrideFiles" id="overrideFiles" /> <label for="overrideFiles">Bestehnde Dateien ersetzen?</label>
            </div>
            <div class="modal-footer">
            </div>
        </div>

    </div>
</div>

<script>
    $(".dialog").fancybox({
        maxWidth: 800,
        maxHeight: 600,
        closeClick: false
    });

    $(".datepicker").datepicker({
        language: ts_lang,
        dateFormat: 'dd.mm.yy'});



    var Level1ID = 0;
    var REL_PATH = "[% $rel_path %]";

    [% if $lang->cur_language == 'de' %]
    var TEMP_LANG = "calendar_de.html";
    [% /if %]

    function selectProjectType(el) {

        var typ = el.options[el.selectedIndex].value;

        if (typ > 0) {
    [% if $ref_level1_name|trim != "" %]

            $.getJSON("index.php?module=project&class=projecttype&event=jsonGetProjectTypeLevel1&type=" + typ, function (data) {
                showLevel1ID(data);
            });

    [% /if %]
    [% if $ref_level2_name|trim != "" %]resetCombobox("Level2ID", "", "[% $user->gettext('>> Bitte ') %][% $ref_level1_name %] [% $user->gettext(' wählen... <<') %]");[% /if %]
            } else {
    [% if $ref_level1_name|trim != "" %]resetCombobox("Level1ID", "", "[% $user->gettext('>> Bitte erst Projekttyp wählen <<') %]");[% /if %]
    [% if $ref_level2_name|trim != "" %]resetCombobox("Level2ID", "", "[% $user->gettext('>> Bitte erst Projekttyp wählen <<') %]");[% /if %]
            }
        }

    [% if $ref_level1_name|trim != "" %]
        function selectLevel1ID(el) {

            var typ = el.options[el.selectedIndex].value;
            if (typ != "") {
                Level1ID = typ;
        [% if $ref_level2_name|trim != "" %]
                $.getJSON("index.php?module=project&class=projecttype&event=jsonGetProjectTypeLevel2&type=" + typ, function (data) {
                    showLevel2ID(data);
                });
        [% /if %]
            } else {
        [% if $ref_level2_name|trim != "" %]resetCombobox("Level2ID", "", "[% $user->gettext('>> Bitte ') %][% $ref_level1_name %] [% $user->gettext(' wählen... <<') %]");[% /if %]
                }
            }
    [% /if %]

            function resetCombobox(field, val, msg) {
                var element = document.getElementById(field);
                if (element && element.options) {
                    element.length = 1;
                    element.options[0].value = val;
                    element.options[0].text = msg;
                }
            }

    [% if $ref_level1_name|trim != "" %]
            function showLevel1ID(result) {

                if (result.Level1.length > 0) {

                    var Level1 = result.Level1;
                    var element = document.getElementById("Level1ID");

                    resetCombobox("Level1ID", "", ">> Bitte wählen Sie... <<");

                    for (i = 0; i < Level1.length; i++) {
                        if (Level1ID == Level1[i].Level1ID) {
                            NewEntry = new Option(Level1[i].Level1Number + " - " + Level1[i].Level1Label, Level1[i].Level1ID, true, true);
                        } else {
                            NewEntry = new Option(Level1[i].Level1Number + " - " + Level1[i].Level1Label, Level1[i].Level1ID, false, false);
                        }
                        element.options[element.length] = NewEntry;
                    }

                } else {
                    resetCombobox("Level1ID", "", "[% $user->gettext('Keine Auswahl möglich...') %]");
                }
            }
    [% /if %]

    [% if $ref_level2_name|trim != "" %]
            function showLevel2ID(result) {

                if (result && result.Level2.length > 0) {

                    var Level2 = result.Level2;
                    var element = document.getElementById("Level2ID");
                    element.length = 0;

                    for (i = 0; i < Level2.length; i++) {
                        if (Level2.length == 1) {
                            NewEntry = new Option(Level2[i].Level2Number + " - " + Level2[i].Level2Label, Level2[i].Level2ID, true, true);
                        } else {
                            NewEntry = new Option(Level2[i].Level2Number + " - " + Level2[i].Level2Label, Level2[i].Level2ID, false, false);
                        }
                        element.options[element.length] = NewEntry;
                    }

                } else {
                    resetCombobox("Level2ID", "", "[% $user->gettext('Keine Auswahl möglich...') %]");
                }
            }
    [% /if %]

            function changeTab(el, tabname) {

                var obj = document.getElementById("TabNavigation");
                var tabs = ["BasicForm", "TicketsForm", "WartungForm"];

                if (obj && el.className != "active") {

                    var list = obj.getElementsByTagName("li");
                    for (var i = 0; i < list.length; i++) {
                        list[i].className = "";
                        document.getElementById(tabs[i]).style.display = "none";
                    }

                    el.className = "active";
                    document.getElementById(tabname + "Form").style.display = "block";
                }
            }

            $("#prjDescr").sceditor({
                format: "bbcode",
                style: "includes/js/sceditor-2.1.2/minified/jquery.sceditor.default.min.css",
                toolbar: "bold,italic,underline,subscript,superscript,horizontalrule,bulletlist,orderedlist|font,color|pastetext,source,maximize",
                colors: '#000|#F00|#11C11D|#00F|#B700B7|#FF8C00|#008080|#808080|#D3D3D3',
                emoticonsEnabled: false,
                charset: 'ISO-8859-1',
                autoUpdate: true,
                autofocus: true,
                width: '100%',
                locale: "[% $user->language_type %]"
            });



            $(".multiple").select2({theme: 'bootstrap-5',liveSearch: true});
            /** Dokumente **/
            Dropzone.options.myDropzone = {

                init: function () {

                    this.on("queuecomplete", function (file) {
                        this.removeAllFiles();
                        getAttachments(TicketID);
                    });
                }
            };

            $("div#DropzoneField").dropzone({
                url: "index.php?module=upload&event=uploadDocs&ProjectID=" + $("#ProjectID").val(),
                init: function () {
                    this.on("queuecomplete", function (file) {
                        console.log(file);
                        this.removeAllFiles();
                        getAttachments();
                    });
                }
            });

            function getAttachments(page) {

                page = page || 1;

                AttachmentList = true;
                objAttachmentList = document.getElementById("AttachmentList");
                if(objAttachmentList){
                    objAttachmentList.innerHTML = "";
                    if (page > 1) {
                        PageParameter = "&pos=" + page;
                    } else {
                        PageParameter = '';
                    }
                    console.log("as");
                    $("#AttachmentList").load("index.php?module=upload&event=showAttachmentsProject&ProjectID=" + $("#ProjectID").val() + PageParameter);
                }
            }


            function RemoveAttachment(id) {
                bootbox.confirm('[% $user->gettext('Soll das Dokument wirklich gelöscht werden?') %]', function (result) {
                    if (result) {
                        makeHttpRequest("index.php?module=upload&event=removeProjectAttachment&ProjectID=" + $("#ProjectID").val() + "&id=" + id, "buildAttachmentList", true);
                    }
                })
            }

            function buildAttachmentList() {
                getAttachments();
            }


            getAttachments();
            /** Dokumente Ende **/

</script>
[% if $id > 0 %]
    <script src="modules/project/javascript/dropfolder.js"></script>
[% /if %]
<script>

    var newSubTreeNodePath = '';
    var SubTreeParentNodeID = '';

var current_node = null;
var changedName = '';
 var JSTree = null;
 [% if $JSTree %]
            $(document).ready(function () {
                $(function () {
                
                    /**
                     * Initialize the jsTree instance on the HTML content.
                     * Display the tree view.
                     */
                    // $("#DocTree").jstree();
                    /**
                     * Initialize the jsTree instance to create tree view
                     * out of JSON content.
                     */
                    JSTree = $("#DocTree").jstree({
                         "plugins" : [ "themes", "html_data", "ui", "crrm", "contextmenu" ],
                        'contextmenu': {
                            'items': customMenu
                        },
                        core: {
                            'check_callback': function (operation, node, node_parent, node_position, more) {
			// operation can be 'create_node', 'rename_node', 'delete_node', 'move_node', 'copy_node' or 'edit'
			// in case of 'rename_node' node_position is filled with the new node name
                                return true;
                        },
                            /**
                             * Add the JSON content inside the "data" attribute.
                             */
                            data: [% $JSTree %],
                        },
                    }).bind("rename_node.jstree", function (event, data) {
                            console.log("Node is renamed: ", event);
                            
                            // Wenn Dateiname geändert wird, muss die Datenbankverküpfung ebenfalls aktualisiert werden
                             if(data.node.icon === 'jstree-file'){
                                 console.log(data.node);
                                $.post('index.php?module=project&event=UpdateFilenameInDatenbank', {'FileName': data.node.text, 'OldName': data.node.original.text, 'ProjectID': ProjectID}, function(){
                                    var path = $("#DocTree").jstree(true).get_path(data.node, "/");
                                        if(data.node.icon === 'jstree-file'){
                                             $.post("index.php?module=project&event=SendMailProjectJSON", {"ProjectID": [% $id %], "DocEvent": 2, "DocumentPath": path}, function(data){
                                                  var json = exportJSON();
                                                  console.log("Neue JSON: "+json);
                                             })
                                          }
                                          else{
                                               var json = exportJSON();
                                               console.log("Neue JSON: "+json);
                                          }
                                });
                              }
                              else{
                                   var json = exportJSON();
                                   console.log("Neue JSON: "+json);
                              }
                       }).bind("delete_node.jstree", function (event, data) {
                            console.log("Node is deleted: ", event);
                            var path = $("#DocTree").jstree(true).get_path(data.node, "/");
                            if(data.node.icon === 'jstree-file'){
                                 $.post("index.php?module=project&event=SendMailProjectJSON", {"ProjectID": [% $id %], "DocEvent": 3, "DocumentPath": path}, function(data){
                                      var json = exportJSON();
                                      console.log("Neue JSON: "+json);
                                 })
                              }
                              else{
                                   var json = exportJSON();
                                   console.log("Neue JSON: "+json);
                              }
                        }).bind("create_node.jstree", function (event, data) {
                            
                            console.log("Node is created: ", data);
                             var path = $("#DocTree").jstree(true).get_path(data.node, "/");
                              var jstree = $('#DocTree').jstree(true); 
                              if(data.node.icon === 'jstree-file'){
                                 $.post("index.php?module=project&event=SendMailProjectJSON", {"ProjectID": [% $id %], "DocEvent": 1, "DocumentPath": path}, function(data){
                                      var json = exportJSON();
                                      console.log("Neue JSON: "+json);
                                 })
                              }
                              else{
                                   var json = exportJSON();
                                   console.log("Neue JSON: "+json);
                              }
                             
                            
                        }).bind('loaded.jstree', function(e, data) {
                            console.log("JSTree ist völlig geladen. Datenbank aktualisieren...");
                            exportJSON();
                        });
                        // JSON Struktur in Datenbankspeichern
                        

            })
        });
        [% /if %]
            
   var ZIPAutoclick = true;    
   var TreeAutoclick = true;  
      /**
 *
 */
function exportJSON() {
// First, add full path to node

var jsonFlat  = JSON.stringify($("#DocTree").jstree(true).get_json('#', {flat:true}));
var nodes = JSON.parse(jsonFlat);
nodes.forEach(function(node){
    var jsTreeNode  = $("#DocTree").jstree(true).get_node(node);
     var path = $("#DocTree").jstree(true).get_path( node, "/");
     console.log(path);
     if(jsTreeNode.data != null){
        jsTreeNode.data.fullpath = path;
        jsTreeNode.data.hash = CryptoJS.enc.Hex.stringify(CryptoJS.SHA1("/"+path));
     }
      console.log(jsTreeNode);
})

/*
   $('.jstree-node').each(function(){
        var id   = $(this).attr('id');
         console.log(id);
        var text = $(this).children('a').text();
        var node  = $("#DocTree").jstree(true).get_node($(this));
        var path = $("#DocTree").jstree(true).get_path( node, "/");
        node.data.fullpath = path;
        console.log(node);
    });*/
    
    var json  = JSON.stringify($("#DocTree").jstree(true).get_json('#', {flat:false}));
    $.post("index.php?module=project&event=storeJSON", {'json':json, 'ProjectID': ProjectID }, function(){
        console.log("Neue JSON gespeichert");
            [% if $DownloadZip %]
                    if(ZIPAutoclick){
                            document.getElementById('DownloadZIP').click();
                            ZIPAutoclick = false;
                        }
            [% /if %]
                 [% if $ExportTree %]
                    if(TreeAutoclick){
                            document.getElementById('ExportTree').click();
                            TreeAutoclick = false;
                        }
            [% /if %]
    });
    return json;
}


            
            function customMenu(node){
                var selectedNodes = $('#DocTree').jstree('get_selected', true);
                console.log(selectedNodes);
                if(selectedNodes.length == 1)
                {
                    var items = {
                        'item1' : {
                            'label' : 'Umbenennen',
                            'action' : function () { 
                               var jstree = $('#DocTree').jstree(true); 
                                 jstree.edit(node);    
                            }
                        },
                        [% if $user->hasRight(1600) && $user->hasRight(26) %]
                        'item2' : {
                            'label' : 'Löschen',
                            'action' : function () {
                                if (confirm("Möchten Sie diesen Ordner/diese Datei löschen?") === true) {
                                           var jstree = $('#DocTree').jstree(true); 
                                            jstree.delete_node(node);    
                                 } 
                            }
                        }
                        [% /if %]

                    };
                     [% if $user->hasRight(1600) && $user->hasRight(26) %]
                    if(node.icon !== 'jstree-file'){
                         items.item3 = {
                                 'label': 'Neuer Ordner',
                                 'action': function(){
                                     $('#DocTree').jstree(true).create_node(node.id, {
                                            "text": "Neuer Ordner"
                                          }, "last");
                                 }
                             };
                              items.item4 = {
                                 'label': 'Neue Datei',
                                 'action': function(){
                                     current_node = node;
                                     $("#UploadFileModal").modal('show');
                                 }
                            };
                              
                              items.item5 = {
                                 'label': 'Weiteren Ordner hochladen',
                                 'action': function(){
                                     current_node = node;
                                     newSubTreeNodePath = $("#DocTree").jstree(true).get_path(node, "/");
                                     SubTreeParentNodeID = current_node.id;
                                     $("#UploadFileTreeModal").modal('show');
                                 }
                             };
                             
                     }
                     [% /if %]

                     if(node.icon === 'jstree-file'){
                         items.item5 = {
                                 'label': 'Herunterladen',
                             'action': function () {
                                 var path = $("#DocTree").jstree(true).get_path(node, "/");                                    
                                 var filehash = CryptoJS.enc.Hex.stringify(CryptoJS.SHA1("/"+path));
                                      console.log("Herunterladen Path: " + "/"+path + " Hash: " + filehash);
                                      window.open('index.php?module=project&event=DownloadSingleProjectFile&FileName='+filehash+'&ProjectID='+ProjectID);
                                     

                                 }
                             };
                             
                              items.item6 = {
                                 'label': 'Rückfragen zu Dokument',
                                 'action': function(){
                                      var path = $("#DocTree").jstree(true).get_path( node, "/");
                                      var title = 'Rückfrage zum Dokument: '+path;
                                      var ProjectID = '[% $id %]';
                                      window.open('index.php?module=ticket&event=newTicket&DocQuestion=1&title='+encodeURIComponent(title)+'&projectid='+ProjectID, '_blank').focus();


                                 }
                             };
                     }
                }
                else{
                     var items = {
                        'item1' : {
                            'label' : 'Gewählte Dateien als ZIP herunterladen',
                            'action' : function () { 
                                console.log(selectedNodes);
                                let filesArr = [];
                                for(let i = 0; i < selectedNodes.length; i++){
                                    if(selectedNodes[i].icon==='jstree-file'){
                                        filesArr.push(selectedNodes[i].text);
                                    }
                                }
                                let getString = filesArr.join(',');
                                console.log(getString);
                                window.open('index.php?module=project&event=downloadZip&id=[% $id %]&files='+getString);
                            }
                        },
                    }
                }

                return items;
}

var singleFileDrop = document.getElementById("SingleFileDrop");
// Einzige Datei hochladen
singleFileDrop.addEventListener(
        "dragover",
        function (e) {
            e = e || event;
            e.preventDefault();
        },
        false
        );
singleFileDrop.addEventListener('drop', handleSingleFileDrop, false);

function handleSingleFileDrop(e){
    e.preventDefault();
    let dt = e.dataTransfer;
    let files = dt.files;
    
    uploadSingleFile(files);
}

/**
 * uploadSingleFile
 */
function uploadSingleFile(files) {
    ([...files]).forEach(function(file){
        console.log(file);
            $("#SingleFileUpload").show();
            $("#SingleFileName").html(file.name);
            var url = 'index.php?module=upload';
            var xhr = new XMLHttpRequest();
            var formData = new FormData()
            xhr.open('POST', url, true);
            xhr.addEventListener('readystatechange', function (e) {
                if (xhr.readyState === 4 && xhr.status === 200) {
                   $("#FileBar_Single").css('width', '100%');
                       $("#UploadFileModal").modal('hide');
                        $("#SingleFileUpload").hide();
                        $("#SingleFileName").html('');
                        $("#FileBar_Single").css('width', '0%');
                       $('#DocTree').jstree(true).create_node(current_node.id, {
                                        "text": file.name,
                                        "icon": 'jstree-file',
                       }, "last");
                   
                    // Done. Inform the user
                } else if (xhr.readyState === 4 && xhr.status !== 200) {
                    $("#FileBar_Single").removeClass('progress-bar-info');
                    $("#FileBar_Single").addClass('progress-bar-danger');
                    $("#FileBar_Single").css('width', '100%');
                    $("#StatusError_Single").html('<b>HTTP Status' + xhr.status + ' - Fehler: '+xhr.statusText+'</b>');
                    $("#ErrorNotice_Single").html('Es ist ein Fehler aufgetreten. Bitte überprüfen Sie die Serverkonfiguration und laden Sie die Datei oder den gesamten Baum erneut hoch.');
                }
            })

            xhr.onprogress = function(pe) {
                 console.log("File Upload: ", pe);
                if(pe.lengthComputable) {
                 var percentage = Math.round((pe.loaded/pe.total)*100);
                 $("#FileBar_Single").css('width', percentage+'%');
                }
            }

            formData.append('UploadFile', file);
            formData.append('FilePathFolder', '');
            formData.append('ShortDescr', 'Project_'+ProjectID+'_' + file.name);
            xhr.send(formData);
            return;
    })
}

/**
 * 
 */


</script>

<script  src="includes/js/hm-quill.js"></script>
<script>
                            var editor = document.getElementsByClassName('ql-editor');
                            editor[0].innerHTML = `[% $project.description %]`;

                            setTimeout(() => {
                                quill.focus();
                            })
</script>

<!-- Component Project Type end -->
